/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util;

import org.aya.api.Global;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.LocalVar;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface Constants {
    @NotNull
    @NonNls
    public static final String ANONYMOUS_PREFIX = "_";
    @NotNull
    @NonNls
    public static final String GENERATED_POSTFIX = "$";
    @NotNull
    @NonNls
    public static final String SCOPE_SEPARATOR = "::";

    @NotNull
    public static LocalVar anonymous() {
        return new LocalVar(ANONYMOUS_PREFIX, SourcePos.NONE);
    }

    @NotNull
    public static LocalVar randomlyNamed(@NotNull SourcePos pos) {
        return new LocalVar(Constants.randomName(pos), pos);
    }

    @NotNull
    public static String randomName(@NotNull Object pos) {
        if (Global.NO_RANDOM_NAME) {
            return ANONYMOUS_PREFIX;
        }
        return ANONYMOUS_PREFIX + Math.abs(pos.hashCode()) % 10;
    }
}

