/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.control.Either;
import kala.tuple.Unit;
import kala.value.Ref;
import org.aya.api.concrete.ConcreteExpr;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.api.util.WithPos;
import org.aya.concrete.desugar.BinOpParser;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.desugar.Desugarer;
import org.aya.concrete.resolve.context.ModuleContext;
import org.aya.concrete.resolve.visitor.ExprResolver;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.term.Term;
import org.aya.distill.BaseDistiller;
import org.aya.distill.ConcreteDistiller;
import org.aya.generic.Level;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Expr
extends ConcreteExpr {
    public <P, R> R doAccept(@NotNull Visitor<P, R> var1, P var2);

    default public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
        visitor.traceEntrance(this, p);
        R ret = this.doAccept(visitor, p);
        visitor.traceExit(ret, this, p);
        return ret;
    }

    @Contract(mutates="this")
    default public Expr resolve(@NotNull ModuleContext context) {
        ExprResolver exprResolver = new ExprResolver(false, (DynamicSeq<PreLevelVar>)DynamicSeq.create(), (DynamicSeq<Stmt>)DynamicSeq.create());
        return this.accept(exprResolver, context);
    }

    @NotNull
    default public Expr desugar(@NotNull Reporter reporter) {
        return this.accept(new Desugarer(new BinOpSet(reporter)), Unit.unit());
    }

    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return this.accept(new ConcreteDistiller(options), BaseDistiller.Outer.Free);
    }

    public static interface Visitor<P, R> {
        default public void traceEntrance(@NotNull Expr expr, P p) {
        }

        default public void traceExit(R r, @NotNull Expr expr, P p) {
        }

        public R visitRef(@NotNull RefExpr var1, P var2);

        public R visitUnresolved(@NotNull UnresolvedExpr var1, P var2);

        public R visitLam(@NotNull LamExpr var1, P var2);

        public R visitPi(@NotNull PiExpr var1, P var2);

        public R visitSigma(@NotNull SigmaExpr var1, P var2);

        public R visitRawUniv(@NotNull RawUnivExpr var1, P var2);

        public R visitUniv(@NotNull UnivExpr var1, P var2);

        public R visitApp(@NotNull AppExpr var1, P var2);

        public R visitHole(@NotNull HoleExpr var1, P var2);

        public R visitTup(@NotNull TupExpr var1, P var2);

        public R visitProj(@NotNull ProjExpr var1, P var2);

        public R visitNew(@NotNull NewExpr var1, P var2);

        public R visitLitInt(@NotNull LitIntExpr var1, P var2);

        public R visitRawUnivArgs(@NotNull RawUnivArgsExpr var1, P var2);

        public R visitUnivArgs(@NotNull UnivArgsExpr var1, P var2);

        public R visitLsuc(@NotNull LSucExpr var1, P var2);

        public R visitLmax(@NotNull LMaxExpr var1, P var2);

        public R visitLitString(@NotNull LitStringExpr var1, P var2);

        public R visitBinOpSeq(@NotNull BinOpSeq var1, P var2);

        public R visitError(@NotNull ErrorExpr var1, P var2);
    }

    public static final class Param
    extends Record
    implements ParamLike<Expr> {
        @NotNull
        private final SourcePos sourcePos;
        @NotNull
        private final LocalVar ref;
        @Nullable
        private final Expr type;
        private final boolean pattern;
        private final boolean explicit;

        public Param(@NotNull Param param, @Nullable Expr type) {
            this(param.sourcePos, param.ref, type, param.pattern, param.explicit);
        }

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar var, boolean explicit) {
            this(sourcePos, var, null, false, explicit);
        }

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar ref, @Nullable Expr type, boolean pattern, boolean explicit) {
            this.sourcePos = sourcePos;
            this.ref = ref;
            this.type = type;
            this.pattern = pattern;
            this.explicit = explicit;
        }

        @NotNull
        public Param mapExpr(@NotNull @NotNull Function<@NotNull Expr, @Nullable Expr> mapper) {
            return new Param(this.sourcePos, this.ref, this.type != null ? mapper.apply(this.type) : null, this.pattern, this.explicit);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Param.class, "sourcePos;ref;type;pattern;explicit", "sourcePos", "ref", "type", "pattern", "explicit"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Param.class, "sourcePos;ref;type;pattern;explicit", "sourcePos", "ref", "type", "pattern", "explicit"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Param.class, "sourcePos;ref;type;pattern;explicit", "sourcePos", "ref", "type", "pattern", "explicit"}, this, o);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }

        @Override
        @NotNull
        public LocalVar ref() {
            return this.ref;
        }

        @Override
        @Nullable
        public Expr type() {
            return this.type;
        }

        @Override
        public boolean pattern() {
            return this.pattern;
        }

        @Override
        public boolean explicit() {
            return this.explicit;
        }
    }

    public record BinOpSeq(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<BinOpParser.Elem> seq) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitBinOpSeq(this, p);
        }
    }

    public record LitStringExpr(@NotNull SourcePos sourcePos, @NotNull String string) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLitString(this, p);
        }
    }

    public record LMaxExpr(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Expr> levels) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLmax(this, p);
        }
    }

    public record LSucExpr(@NotNull SourcePos sourcePos, @NotNull Expr expr) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLsuc(this, p);
        }
    }

    public record LitIntExpr(@NotNull SourcePos sourcePos, int integer) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLitInt(this, p);
        }
    }

    public record Field(@NotNull String name, @NotNull ImmutableSeq<WithPos<LocalVar>> bindings, @NotNull Expr body) {
    }

    public record NewExpr(@NotNull SourcePos sourcePos, @NotNull Expr struct, @NotNull ImmutableSeq<Field> fields) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitNew(this, p);
        }
    }

    public record ProjExpr(@NotNull SourcePos sourcePos, @NotNull Expr tup, @NotNull Either<Integer, WithPos<String>> ix, @NotNull Ref<@Nullable Var> resolvedIx, @NotNull Ref<Term> theCore) implements Expr,
    WithTerm
    {
        public ProjExpr(@NotNull SourcePos sourcePos, @NotNull Expr tup, @NotNull Either<Integer, WithPos<String>> ix, @NotNull Ref<@Nullable Var> resolvedIx) {
            this(sourcePos, tup, ix, resolvedIx, (Ref<Term>)new Ref());
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitProj(this, p);
        }
    }

    public record TupExpr(@NotNull SourcePos sourcePos, @NotNull @NotNull ImmutableSeq<@NotNull Expr> items) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitTup(this, p);
        }
    }

    public record UnivArgsExpr(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Level<PreLevelVar>> univArgs) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitUnivArgs(this, p);
        }
    }

    public record RawUnivArgsExpr(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Expr> univArgs) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitRawUnivArgs(this, p);
        }
    }

    public record UnivExpr(@NotNull SourcePos sourcePos, @NotNull Level<PreLevelVar> level) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitUniv(this, p);
        }
    }

    public record RawUnivExpr(@NotNull SourcePos sourcePos) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitRawUniv(this, p);
        }
    }

    public record RefExpr(@NotNull SourcePos sourcePos, @NotNull Var resolvedVar, @NotNull Ref<Term> theCore) implements Expr,
    WithTerm
    {
        public RefExpr(@NotNull SourcePos sourcePos, @NotNull Var resolvedVar) {
            this(sourcePos, resolvedVar, (Ref<Term>)new Ref());
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitRef(this, p);
        }
    }

    public record SigmaExpr(@NotNull SourcePos sourcePos, boolean co, @NotNull @NotNull ImmutableSeq<@NotNull Param> params) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitSigma(this, p);
        }
    }

    public record LamExpr(@NotNull SourcePos sourcePos, @NotNull Param param, @NotNull Expr body) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLam(this, p);
        }
    }

    public record PiExpr(@NotNull SourcePos sourcePos, boolean co, @NotNull Param param, @NotNull Expr last) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitPi(this, p);
        }
    }

    public record NamedArg(@Nullable String name, @NotNull Expr expr) implements AyaDocile
    {
        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return this.name == null ? this.expr.toDoc(options) : Doc.braced((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)this.name), Doc.symbol((String)"=>"), this.expr.toDoc(options)}));
        }
    }

    public record AppExpr(@NotNull SourcePos sourcePos, @NotNull Expr function, @NotNull Arg<NamedArg> argument) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitApp(this, p);
        }
    }

    public record HoleExpr(@NotNull SourcePos sourcePos, boolean explicit, @Nullable Expr filling, Ref<ImmutableSeq<LocalVar>> accessibleLocal) implements Expr
    {
        public HoleExpr(@NotNull SourcePos sourcePos, boolean explicit, @Nullable Expr filling) {
            this(sourcePos, explicit, filling, (Ref<ImmutableSeq<LocalVar>>)new Ref());
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitHole(this, p);
        }
    }

    public record ErrorExpr(@NotNull SourcePos sourcePos, @NotNull AyaDocile description) implements Expr
    {
        public ErrorExpr(@NotNull SourcePos sourcePos, @NotNull Doc description) {
            this(sourcePos, options -> description);
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitError(this, p);
        }
    }

    public record UnresolvedExpr(@NotNull SourcePos sourcePos, @NotNull QualifiedID name) implements Expr
    {
        public UnresolvedExpr(@NotNull SourcePos sourcePos, @NotNull String name) {
            this(sourcePos, new QualifiedID(sourcePos, name));
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitUnresolved(this, p);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WithTerm
    extends Expr {
        @NotNull
        public Ref<Term> theCore();

        @Nullable
        default public Term core() {
            return (Term)this.theCore().value;
        }
    }
}

