/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.util.Assoc;
import org.aya.concrete.desugar.error.OperatorProblem;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.stmt.OpDecl;
import org.aya.util.MutableGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BinOpSet(@NotNull Reporter reporter, @NotNull MutableSet<BinOP> ops, @NotNull MutableGraph<BinOP> tighterGraph) {
    @NotNull
    static final BinOP APP_ELEM = BinOP.from(SourcePos.NONE, OpDecl.APPLICATION);

    public BinOpSet(@NotNull Reporter reporter) {
        this(reporter, (MutableSet<BinOP>)MutableSet.of((Object)APP_ELEM), (MutableGraph<BinOP>)MutableGraph.create());
    }

    public void bind(@NotNull OpDecl op, @NotNull OpDecl.BindPred pred, @NotNull OpDecl target, @NotNull SourcePos sourcePos) {
        BinOP targetElem;
        BinOP opElem = this.ensureHasElem(op, sourcePos);
        if (opElem == (targetElem = this.ensureHasElem(target, sourcePos))) {
            this.reporter.report((Problem)new OperatorProblem.BindSelfError(sourcePos));
            throw new Context.ResolvingInterruptedException();
        }
        switch (pred) {
            case Tighter: {
                this.addTighter(opElem, targetElem);
                break;
            }
            case Looser: {
                this.addTighter(targetElem, opElem);
            }
        }
    }

    public PredCmp compare(@NotNull BinOP lhs, @NotNull BinOP rhs) {
        if (lhs == APP_ELEM) {
            return PredCmp.Tighter;
        }
        if (rhs == APP_ELEM) {
            return PredCmp.Looser;
        }
        if (lhs == rhs) {
            return PredCmp.Equal;
        }
        if (this.tighterGraph.hasPath((Object)lhs, (Object)rhs)) {
            return PredCmp.Tighter;
        }
        if (this.tighterGraph.hasPath((Object)rhs, (Object)lhs)) {
            return PredCmp.Looser;
        }
        return PredCmp.Undefined;
    }

    public Assoc assocOf(@Nullable OpDecl opDecl) {
        if (this.isOperand(opDecl)) {
            return Assoc.Invalid;
        }
        return this.ensureHasElem((OpDecl)opDecl).assoc;
    }

    public boolean isOperand(@Nullable OpDecl opDecl) {
        return opDecl == null || opDecl.opInfo() == null;
    }

    public BinOP ensureHasElem(@NotNull OpDecl opDecl) {
        return this.ensureHasElem(opDecl, SourcePos.NONE);
    }

    public BinOP ensureHasElem(@NotNull OpDecl opDecl, @NotNull SourcePos sourcePos) {
        Option elem = this.ops.find(e -> e.op == opDecl);
        if (elem.isDefined()) {
            return (BinOP)elem.get();
        }
        BinOP newElem = BinOP.from(sourcePos, opDecl);
        this.ops.add((Object)newElem);
        return newElem;
    }

    private void addTighter(@NotNull BinOP from, @NotNull BinOP to) {
        this.tighterGraph.suc((Object)to);
        this.tighterGraph.suc((Object)from).append((Object)to);
    }

    public void reportIfCyclic() {
        ImmutableSeq cycles = this.tighterGraph.findCycles();
        if (cycles.isNotEmpty()) {
            cycles.forEach(c -> this.reporter.report((Problem)new OperatorProblem.Circular((ImmutableSeq<BinOP>)c)));
            throw new Context.ResolvingInterruptedException();
        }
    }

    public record BinOP(@NotNull SourcePos firstBind, @NotNull OpDecl op, @NotNull String name, @NotNull Assoc assoc) {
        @NotNull
        private static OpDecl.OpInfo ensureOperator(@NotNull OpDecl opDecl) {
            OpDecl.OpInfo op = opDecl.opInfo();
            if (op == null) {
                throw new IllegalArgumentException("not an operator");
            }
            return op;
        }

        @NotNull
        private static BinOP from(@NotNull SourcePos sourcePos, @NotNull OpDecl opDecl) {
            OpDecl.OpInfo op = BinOP.ensureOperator(opDecl);
            return new BinOP(sourcePos, opDecl, op.name(), op.assoc());
        }
    }

    public static enum PredCmp {
        Looser,
        Tighter,
        Undefined,
        Equal;

    }
}

