/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.remark;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.util.NormalizeMode;
import org.aya.concrete.Expr;
import org.aya.concrete.parse.AyaParsing;
import org.aya.concrete.parse.AyaProducer;
import org.aya.concrete.remark.Literate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CodeOptions(@Nullable NormalizeMode mode, @NotNull DistillerOptions options, @NotNull ShowCode showCode) {
    @NotNull
    public static final Pattern PARSER = Pattern.compile("\\A(([\\w ]*)(\\|([\\w ]*)\\|([\\w ]*))?:)?(.*)\\z");

    @NotNull
    public static Literate.Code analyze(@NotNull String literal, @NotNull AyaProducer producer) {
        DistillerOptions distillOpts = new DistillerOptions();
        Matcher matcher = PARSER.matcher(literal);
        boolean found = matcher.find();
        assert (found);
        String commonOpt = matcher.group(2);
        NormalizeMode mode = null;
        ShowCode showCode = ShowCode.Concrete;
        if (commonOpt != null) {
            if ((commonOpt = commonOpt.toUpperCase(Locale.ROOT)).contains("C")) {
                showCode = ShowCode.Core;
            } else if (commonOpt.contains("T")) {
                showCode = ShowCode.Type;
            }
            if (commonOpt.contains("W")) {
                mode = NormalizeMode.WHNF;
            } else if (commonOpt.contains("N")) {
                mode = NormalizeMode.NF;
            }
        }
        String open = matcher.group(4);
        String close = matcher.group(5);
        if (open != null && close != null) {
            open = open.toUpperCase(Locale.ROOT);
            close = close.toUpperCase(Locale.ROOT);
            distillOpts.map.put(DistillerOptions.Key.ShowImplicitArgs, !close.contains("I"));
            distillOpts.map.put(DistillerOptions.Key.ShowImplicitPats, !close.contains("P"));
            distillOpts.map.put(DistillerOptions.Key.ShowLevels, open.contains("U"));
            distillOpts.map.put(DistillerOptions.Key.ShowLambdaTypes, open.contains("L"));
        } else {
            distillOpts.map.put(DistillerOptions.Key.ShowImplicitArgs, true);
            distillOpts.map.put(DistillerOptions.Key.ShowImplicitPats, true);
        }
        Expr expr = producer.visitExpr(AyaParsing.parser(matcher.group(6)).expr());
        CodeOptions options = new CodeOptions(mode, distillOpts, showCode);
        return new Literate.Code(expr, options);
    }

    public static enum ShowCode {
        Concrete,
        Core,
        Type;

    }
}

