/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.context;

import java.util.function.Function;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.Var;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.error.AmbiguousNameError;
import org.aya.concrete.resolve.error.AmbiguousNameWarn;
import org.aya.concrete.resolve.error.DuplicateModNameError;
import org.aya.concrete.resolve.error.DuplicateNameError;
import org.aya.concrete.resolve.error.ModNameNotFoundError;
import org.aya.concrete.resolve.error.ModShadowingWarn;
import org.aya.concrete.resolve.error.QualifiedNameNotFoundError;
import org.aya.concrete.resolve.error.ShadowingWarn;
import org.aya.concrete.stmt.Stmt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleContext
extends Context {
    @Override
    @NotNull
    public Context parent();

    @Override
    @NotNull
    default public Reporter reporter() {
        return this.parent().reporter();
    }

    @NotNull
    public MutableMap<String, MutableMap<Seq<String>, Var>> definitions();

    @NotNull
    public MutableMap<ImmutableSeq<String>, MutableMap<String, Var>> modules();

    @Override
    @Nullable
    default public Var getUnqualifiedLocalMaybe(@NotNull String name, @NotNull SourcePos sourcePos) {
        MutableMap result = (MutableMap)this.definitions().getOrNull((Object)name);
        if (result == null) {
            return null;
        }
        if (result.size() == 1) {
            return (Var)result.iterator().next().getValue();
        }
        DynamicSeq disamb = DynamicSeq.create();
        result.forEach((k, v) -> disamb.append(k));
        return (Var)this.reportAndThrow(new AmbiguousNameError(name, (ImmutableSeq<Seq<String>>)disamb.toImmutableSeq(), sourcePos));
    }

    @Override
    @Nullable
    default public Var getQualifiedLocalMaybe(@NotNull @NotNull ImmutableSeq<@NotNull String> modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        MutableMap mod = (MutableMap)this.modules().getOrNull(modName);
        if (mod == null) {
            return null;
        }
        Var ref = (Var)mod.getOrNull((Object)name);
        if (ref == null) {
            this.reportAndThrow(new QualifiedNameNotFoundError((Seq<String>)modName, name, sourcePos));
        }
        return ref;
    }

    @Override
    @Nullable
    default public MutableMap<String, Var> getModuleLocalMaybe(@NotNull ImmutableSeq<String> modName) {
        return (MutableMap)this.modules().getOrNull(modName);
    }

    default public void importModules(@NotNull ImmutableSeq<String> modName, @NotNull Stmt.Accessibility accessibility, @NotNull MutableMap<ImmutableSeq<String>, MutableMap<String, Var>> module, @NotNull SourcePos sourcePos) {
        module.forEach((name, mod) -> this.importModule(accessibility, sourcePos, (ImmutableSeq<String>)modName.concat((SeqLike)name), (MutableMap<String, Var>)mod));
    }

    default public void importModule(@NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos, ImmutableSeq<String> componentName, MutableMap<String, Var> mod) {
        MutableMap<ImmutableSeq<String>, MutableMap<String, Var>> modules = this.modules();
        if (modules.containsKey(componentName)) {
            this.reportAndThrow(new DuplicateModNameError((Seq<String>)componentName, sourcePos));
        }
        if (this.getModuleMaybe(componentName, sourcePos) != null) {
            this.reporter().report((Problem)new ModShadowingWarn((Seq<String>)componentName, sourcePos));
        }
        modules.set(componentName, mod);
    }

    default public void openModule(@NotNull ImmutableSeq<String> modName, @NotNull Stmt.Accessibility accessibility, @NotNull Function<String, Boolean> using, @NotNull Map<String, String> rename, @NotNull SourcePos sourcePos) {
        MutableMap<String, Var> mod = this.getModuleMaybe(modName, sourcePos);
        if (mod == null) {
            this.reportAndThrow(new ModNameNotFoundError((Seq<String>)modName, sourcePos));
        }
        mod.forEach((name, ref) -> {
            if (((Boolean)using.apply((String)name)).booleanValue()) {
                String newName = (String)rename.getOrDefault(name, name);
                this.addGlobal(modName, newName, accessibility, (Var)ref, sourcePos);
            }
        });
    }

    default public void addGlobalSimple(@NotNull Stmt.Accessibility acc, @NotNull Var ref, @NotNull SourcePos sourcePos) {
        this.addGlobal((ImmutableSeq<String>)TOP_LEVEL_MOD_NAME, ref.name(), acc, ref, sourcePos);
    }

    default public void addGlobal(@NotNull ImmutableSeq<String> modName, @NotNull String name, @NotNull Stmt.Accessibility accessibility, @NotNull Var ref, @NotNull SourcePos sourcePos) {
        MutableMap<String, MutableMap<Seq<String>, Var>> definitions = this.definitions();
        if (!definitions.containsKey((Object)name)) {
            if (this.getUnqualifiedMaybe(name, sourcePos) != null && !name.startsWith("_")) {
                this.reporter().report((Problem)new ShadowingWarn(name, sourcePos));
            }
            definitions.set((Object)name, (Object)MutableHashMap.create());
        } else if (((MutableMap)definitions.get((Object)name)).containsKey(modName)) {
            this.reportAndThrow(new DuplicateNameError(name, ref, sourcePos));
        } else {
            this.reporter().report((Problem)new AmbiguousNameWarn(name, sourcePos));
        }
        ((MutableMap)definitions.get((Object)name)).set(modName, (Object)ref);
        if (modName.equals((Object)TOP_LEVEL_MOD_NAME)) {
            ((MutableMap)this.modules().get((Object)TOP_LEVEL_MOD_NAME)).set((Object)name, (Object)ref);
        }
    }
}

