/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.module;

import java.io.IOException;
import java.nio.file.Path;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.collection.mutable.MutableMap;
import kala.function.CheckedConsumer;
import org.aya.api.error.CollectingReporter;
import org.aya.api.error.DelayedReporter;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourceFileLocator;
import org.aya.api.ref.Var;
import org.aya.api.util.InternalException;
import org.aya.concrete.Expr;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.parse.AyaParsing;
import org.aya.concrete.resolve.ResolveInfo;
import org.aya.concrete.resolve.ShallowResolveInfo;
import org.aya.concrete.resolve.context.EmptyContext;
import org.aya.concrete.resolve.context.ModuleContext;
import org.aya.concrete.resolve.context.PhysicalModuleContext;
import org.aya.concrete.resolve.module.ModuleLoader;
import org.aya.concrete.resolve.visitor.StmtShallowResolver;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.Def;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.order.IncrementalTycker;
import org.aya.tyck.order.SCCTycker;
import org.aya.tyck.trace.Trace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FileModuleLoader(@NotNull SourceFileLocator locator, @NotNull Path basePath, @NotNull Reporter reporter, @Nullable FileModuleLoaderCallback callback,  @Nullable Trace.Builder builder) implements ModuleLoader
{
    @NotNull
    private Path resolveFile(@NotNull @NotNull Seq<@NotNull String> path) {
        Path withoutExt = (Path)path.foldLeft((Object)this.basePath, Path::resolve);
        return withoutExt.resolveSibling(withoutExt.getFileName() + ".aya");
    }

    @Override
    @Nullable
    public MutableMap<ImmutableSeq<String>, MutableMap<String, Var>> load(@NotNull @NotNull ImmutableSeq<@NotNull String> path, @NotNull ModuleLoader recurseLoader) {
        Path sourcePath = this.resolveFile((Seq<String>)path);
        try {
            ImmutableSeq<Stmt> program = AyaParsing.program(this.locator, this.reporter, sourcePath);
            PhysicalModuleContext context = new EmptyContext(this.reporter).derive((Seq<String>)path);
            FileModuleLoader.tyckModule(context, recurseLoader, program, this.reporter, resolveInfo -> {
                if (this.callback != null) {
                    this.callback.onResolved(sourcePath, (ShallowResolveInfo)resolveInfo, program);
                }
            }, defs -> {
                if (this.callback != null) {
                    this.callback.onTycked(sourcePath, program, (ImmutableSeq<Def>)defs);
                }
            }, this.builder);
            return context.exports;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void tyckModule(@NotNull ModuleContext context, @NotNull ModuleLoader recurseLoader, @NotNull ImmutableSeq<Stmt> program, @NotNull Reporter reporter, @NotNull CheckedConsumer<ShallowResolveInfo, E> onResolved, @NotNull CheckedConsumer<ImmutableSeq<Def>, E> onTycked, @Nullable Trace.Builder builder) throws E {
        ShallowResolveInfo shallowResolveInfo = new ShallowResolveInfo((DynamicSeq<ImmutableSeq<String>>)DynamicSeq.create());
        StmtShallowResolver shallowResolver = new StmtShallowResolver(recurseLoader, shallowResolveInfo);
        program.forEach(s -> s.accept(shallowResolver, context));
        ResolveInfo resolveInfo = new ResolveInfo(new BinOpSet(reporter));
        Stmt.resolve(program, resolveInfo);
        DelayedReporter delayedReporter = new DelayedReporter(reporter);
        IncrementalTycker sccTycker = new IncrementalTycker(new SCCTycker(builder, (CollectingReporter)delayedReporter), resolveInfo);
        try (DelayedReporter delayedReporter2 = delayedReporter;){
            ImmutableSeq SCCs = resolveInfo.declGraph().topologicalOrder().view().appendedAll((Iterable)resolveInfo.sampleGraph().topologicalOrder()).toImmutableSeq();
            SCCs.forEach(sccTycker::tyckSCC);
        }
        finally {
            onResolved.acceptChecked((Object)shallowResolveInfo);
            onTycked.acceptChecked((Object)sccTycker.sccTycker().wellTyped().toImmutableSeq());
        }
    }

    public static @NotNull ExprTycker.Result tyckExpr(@NotNull ModuleContext context, @NotNull Expr expr, @NotNull Reporter reporter,  @Nullable Trace.Builder builder) {
        Expr resolvedExpr = expr.resolve(context);
        try (DelayedReporter delayedReporter = new DelayedReporter(reporter);){
            ExprTycker tycker = new ExprTycker((Reporter)delayedReporter, builder);
            ExprTycker.Result result = tycker.zonk(expr, tycker.synthesize(resolvedExpr.desugar((Reporter)delayedReporter)));
            return result;
        }
    }

    public static void handleInternalError(@NotNull InternalException e) {
        e.printStackTrace();
        e.printHint();
        System.err.println("Please report the stacktrace to the developers so a better error handling could be made.\nDon't forget to inform the version of Aya you're using and attach your code for reproduction.");
    }

    public static interface FileModuleLoaderCallback {
        public void onResolved(@NotNull Path var1, @NotNull ShallowResolveInfo var2, @NotNull ImmutableSeq<Stmt> var3);

        public void onTycked(@NotNull Path var1, @NotNull ImmutableSeq<Stmt> var2, @NotNull ImmutableSeq<Def> var3);
    }
}

