/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.visitor;

import kala.tuple.Unit;
import org.aya.api.error.Problem;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.Var;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.resolve.ResolveInfo;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.error.UnknownOperatorError;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.OpDecl;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.jetbrains.annotations.NotNull;

public final class BindResolver
implements Stmt.Visitor<ResolveInfo, Unit> {
    @NotNull
    public static final BindResolver INSTANCE = new BindResolver();

    private BindResolver() {
    }

    @Override
    public Unit visitModule( @NotNull Command.Module mod, ResolveInfo info) {
        this.visitAll(mod.contents(), info);
        return Unit.unit();
    }

    @Override
    public Unit visitImport( @NotNull Command.Import cmd, ResolveInfo info) {
        return Unit.unit();
    }

    @Override
    public Unit visitOpen( @NotNull Command.Open cmd, ResolveInfo info) {
        return Unit.unit();
    }

    public void visitBind(@NotNull OpDecl self, @NotNull OpDecl.BindBlock bind, ResolveInfo info) {
        if (bind == OpDecl.BindBlock.EMPTY) {
            return;
        }
        Context ctx = (Context)bind.context().value;
        assert (ctx != null) : "no shallow resolver?";
        BinOpSet opSet = info.opSet();
        bind.resolvedLoosers().value = bind.loosers().map(looser -> this.bind(self, opSet, ctx, OpDecl.BindPred.Looser, (QualifiedID)looser));
        bind.resolvedTighters().value = bind.tighters().map(tighter -> this.bind(self, opSet, ctx, OpDecl.BindPred.Tighter, (QualifiedID)tighter));
    }

    @NotNull
    private DefVar<?, ?> bind(@NotNull OpDecl self, @NotNull BinOpSet opSet, @NotNull Context ctx, @NotNull OpDecl.BindPred pred, @NotNull QualifiedID id) {
        Var var = ctx.get(id);
        if (var instanceof DefVar) {
            DefVar defVar = (DefVar)var;
            var = defVar.concrete;
            if (var instanceof OpDecl) {
                OpDecl op = (OpDecl)var;
                opSet.bind(self, pred, op, id.sourcePos());
                return defVar;
            }
        }
        opSet.reporter().report((Problem)new UnknownOperatorError(id.sourcePos(), id.join()));
        throw new Context.ResolvingInterruptedException();
    }

    @Override
    public Unit visitCtor(@NotNull Decl.DataCtor ctor, ResolveInfo info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit visitField(@NotNull Decl.StructField field, ResolveInfo info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit visitData( @NotNull Decl.DataDecl decl, ResolveInfo info) {
        decl.body.forEach(ctor -> this.visitBind((OpDecl)ctor, ctor.bindBlock, info));
        this.visitBind(decl, decl.bindBlock, info);
        return Unit.unit();
    }

    @Override
    public Unit visitStruct( @NotNull Decl.StructDecl decl, ResolveInfo info) {
        decl.fields.forEach(field -> this.visitBind((OpDecl)field, field.bindBlock, info));
        this.visitBind(decl, decl.bindBlock, info);
        return Unit.unit();
    }

    @Override
    public Unit visitFn( @NotNull Decl.FnDecl decl, ResolveInfo info) {
        this.visitBind(decl, decl.bindBlock, info);
        return Unit.unit();
    }

    @Override
    public Unit visitPrim(@NotNull Decl.PrimDecl decl, ResolveInfo info) {
        return Unit.unit();
    }

    @Override
    public Unit visitLevels( @NotNull Generalize.Levels levels, ResolveInfo info) {
        return Unit.unit();
    }

    @Override
    public Unit visitExample( @NotNull Sample.Working example, ResolveInfo info) {
        return example.delegate().accept(this, info);
    }

    @Override
    public Unit visitCounterexample( @NotNull Sample.Counter example, ResolveInfo info) {
        return example.delegate().accept(this, info);
    }

    @Override
    public Unit visitRemark(@NotNull Remark remark, ResolveInfo info) {
        return Unit.unit();
    }
}

