/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.tuple.Tuple2;
import org.aya.api.concrete.ConcreteDecl;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.api.util.WithPos;
import org.aya.concrete.Expr;
import org.aya.concrete.resolve.context.BindContext;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.error.GeneralizedNotAvailableError;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.visitor.ExprFixpoint;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record ExprResolver(boolean allowGeneralized, @NotNull DynamicSeq<PreLevelVar> allowedLevels, @NotNull DynamicSeq<Stmt> reference) implements ExprFixpoint<Context>
{
    @Override
    @NotNull
    public Expr visitUnresolved(@NotNull Expr.UnresolvedExpr expr, Context ctx) {
        SourcePos sourcePos = expr.sourcePos();
        QualifiedID name = expr.name();
        Var resolved = ctx.get(name);
        Expr.RefExpr refExpr = new Expr.RefExpr(sourcePos, resolved);
        Var var = resolved;
        Objects.requireNonNull(var);
        Var var2 = var;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PreLevelVar.class, DefVar.class}, (Object)var2, n)) {
            case 0: {
                PreLevelVar levelVar = (PreLevelVar)var2;
                if (this.allowGeneralized) {
                    this.allowedLevels.append((Object)levelVar);
                    break;
                }
                if (this.allowedLevels.contains((Object)levelVar)) break;
                ctx.reporter().report((Problem)new GeneralizedNotAvailableError(refExpr));
                throw new Context.ResolvingInterruptedException();
            }
            case 1: {
                DefVar ref = (DefVar)var2;
                ConcreteDecl concreteDecl = ref.concrete;
                Objects.requireNonNull(concreteDecl);
                ConcreteDecl concreteDecl2 = concreteDecl;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Decl.DataCtor.class, Decl.StructField.class}, (Object)concreteDecl2, n2)) {
                    case 0: {
                        Decl decl = (Decl)concreteDecl2;
                        this.reference.append((Object)decl);
                        break block0;
                    }
                    case 1: {
                        Decl.DataCtor ctor = (Decl.DataCtor)concreteDecl2;
                        this.reference.append((Object)((Stmt)ctor.dataRef.concrete));
                        break block0;
                    }
                    case 2: {
                        Decl.StructField field = (Decl.StructField)concreteDecl2;
                        this.reference.append((Object)((Stmt)field.structRef.concrete));
                        break block0;
                    }
                }
                throw new IllegalStateException("unreachable");
            }
        }
        return refExpr;
    }

    @NotNull
    public Tuple2<Expr.Param, Context> visitParam(@NotNull Expr.Param param, Context ctx) {
        Expr type = param.type();
        type = type == null ? null : type.accept(this, ctx);
        return Tuple2.of((Object)new Expr.Param(param, type), (Object)ctx.bind(param.ref(), param.sourcePos()));
    }

    @Contract(pure=true)
    @NotNull
    public Tuple2<ImmutableSeq<Expr.Param>, Context> resolveParams(@NotNull SeqLike<Expr.Param> params, Context ctx) {
        if (params.isEmpty()) {
            return Tuple2.of((Object)ImmutableSeq.empty(), (Object)ctx);
        }
        Expr.Param first = (Expr.Param)params.first();
        Expr type = first.type();
        type = type == null ? null : type.accept(this, ctx);
        BindContext newCtx = ctx.bind(first.ref(), first.sourcePos());
        Tuple2<ImmutableSeq<Expr.Param>, Context> result = this.resolveParams((SeqLike<Expr.Param>)params.view().drop(1), newCtx);
        return Tuple2.of((Object)((ImmutableSeq)result._1).prepended((Object)new Expr.Param(first, type)), (Object)((Context)result._2));
    }

    @Override
    @NotNull
    public Expr visitLam(@NotNull Expr.LamExpr expr, Context ctx) {
        Tuple2<Expr.Param, Context> param = this.visitParam(expr.param(), ctx);
        Expr body = expr.body().accept(this, (Context)param._2);
        return new Expr.LamExpr(expr.sourcePos(), (Expr.Param)param._1, body);
    }

    @Override
    public @NotNull Expr.Field visitField(@NotNull Expr.Field t, Context context) {
        for (WithPos binding : t.bindings()) {
            context = context.bind((LocalVar)binding.data(), binding.sourcePos());
        }
        return ExprFixpoint.super.visitField(t, context);
    }

    @Override
    @NotNull
    public Expr visitPi(@NotNull Expr.PiExpr expr, Context ctx) {
        Tuple2<Expr.Param, Context> param = this.visitParam(expr.param(), ctx);
        Expr last = expr.last().accept(this, (Context)param._2);
        return new Expr.PiExpr(expr.sourcePos(), expr.co(), (Expr.Param)param._1, last);
    }

    @Override
    @NotNull
    public Expr visitSigma(@NotNull Expr.SigmaExpr expr, Context ctx) {
        Tuple2<ImmutableSeq<Expr.Param>, Context> params = this.resolveParams((SeqLike<Expr.Param>)expr.params(), ctx);
        return new Expr.SigmaExpr(expr.sourcePos(), expr.co(), (ImmutableSeq<Expr.Param>)((ImmutableSeq)params._1));
    }

    @Override
    @NotNull
    public Expr visitHole(@NotNull Expr.HoleExpr expr, Context context) {
        expr.accessibleLocal().set((Object)context.collect((DynamicSeq<LocalVar>)DynamicSeq.create()).toImmutableSeq());
        return ExprFixpoint.super.visitHole(expr, context);
    }
}

