/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.visitor;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.tuple.Tuple2;
import kala.tuple.Unit;
import kala.value.Ref;
import org.aya.api.ref.PreLevelVar;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.resolve.ResolveInfo;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.visitor.ExprResolver;
import org.aya.concrete.resolve.visitor.PatResolver;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Stmt;
import org.aya.util.MutableGraph;
import org.jetbrains.annotations.NotNull;

public final class StmtResolver
implements Stmt.Visitor<ResolveInfo, Unit> {
    @NotNull
    public static final StmtResolver INSTANCE = new StmtResolver();

    private StmtResolver() {
    }

    @Override
    public Unit visitModule( @NotNull Command.Module mod, ResolveInfo info) {
        this.visitAll(mod.contents(), info);
        return Unit.unit();
    }

    @Override
    public Unit visitImport( @NotNull Command.Import cmd, ResolveInfo info) {
        return Unit.unit();
    }

    @Override
    public Unit visitOpen( @NotNull Command.Open cmd, ResolveInfo info) {
        return Unit.unit();
    }

    @Override
    public Unit visitCtor(@NotNull Decl.DataCtor ctor, ResolveInfo info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit visitField(@NotNull Decl.StructField field, ResolveInfo info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit visitData( @NotNull Decl.DataDecl decl, ResolveInfo info) {
        DynamicSeq reference = DynamicSeq.create();
        ExprResolver signatureResolver = new ExprResolver(true, (DynamicSeq<PreLevelVar>)DynamicSeq.create(), (DynamicSeq<Stmt>)reference);
        Tuple2<ImmutableSeq<Expr.Param>, Context> local = signatureResolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = (ImmutableSeq)local._1;
        decl.result = decl.result.accept(signatureResolver, (Context)local._2);
        ExprResolver bodyResolver = new ExprResolver(false, signatureResolver.allowedLevels(), (DynamicSeq<Stmt>)reference);
        for (Decl.DataCtor ctor : decl.body) {
            Ref localCtxWithPat = new Ref((Object)((Context)local._2));
            ctor.patterns = ctor.patterns.map(pattern -> PatResolver.INSTANCE.subpatterns((Ref<Context>)localCtxWithPat, (Pattern)pattern));
            Tuple2<ImmutableSeq<Expr.Param>, Context> ctorLocal = bodyResolver.resolveParams((SeqLike<Expr.Param>)ctor.telescope, (Context)localCtxWithPat.value);
            ctor.telescope = (ImmutableSeq)ctorLocal._1;
            ctor.clauses = ctor.clauses.map(clause -> PatResolver.INSTANCE.matchy((Pattern.Clause)clause, (Context)ctorLocal._2, bodyResolver));
        }
        info.declGraph().suc((Object)decl).appendAll((Iterable)reference);
        return Unit.unit();
    }

    @Override
    public Unit visitStruct( @NotNull Decl.StructDecl decl, ResolveInfo info) {
        DynamicSeq reference = DynamicSeq.create();
        ExprResolver signatureResolver = new ExprResolver(true, (DynamicSeq<PreLevelVar>)DynamicSeq.create(), (DynamicSeq<Stmt>)reference);
        Tuple2<ImmutableSeq<Expr.Param>, Context> local = signatureResolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = (ImmutableSeq)local._1;
        decl.result = decl.result.accept(signatureResolver, (Context)local._2);
        ExprResolver bodyResolver = new ExprResolver(false, signatureResolver.allowedLevels(), (DynamicSeq<Stmt>)reference);
        decl.fields.forEach(field -> {
            Tuple2<ImmutableSeq<Expr.Param>, Context> fieldLocal = bodyResolver.resolveParams((SeqLike<Expr.Param>)field.telescope, (Context)local._2);
            field.telescope = (ImmutableSeq)fieldLocal._1;
            field.result = field.result.accept(bodyResolver, (Context)fieldLocal._2);
            field.body = field.body.map(e -> e.accept(bodyResolver, fieldLocal._2));
            field.clauses = field.clauses.map(clause -> PatResolver.INSTANCE.matchy((Pattern.Clause)clause, (Context)fieldLocal._2, bodyResolver));
        });
        info.declGraph().suc((Object)decl).appendAll((Iterable)reference);
        return Unit.unit();
    }

    @Override
    public Unit visitFn( @NotNull Decl.FnDecl decl, ResolveInfo info) {
        DynamicSeq reference = DynamicSeq.create();
        ExprResolver signatureResolver = new ExprResolver(true, (DynamicSeq<PreLevelVar>)DynamicSeq.create(), (DynamicSeq<Stmt>)reference);
        Tuple2<ImmutableSeq<Expr.Param>, Context> local = signatureResolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = (ImmutableSeq)local._1;
        decl.result = decl.result.accept(signatureResolver, (Context)local._2);
        ExprResolver bodyResolver = new ExprResolver(false, signatureResolver.allowedLevels(), (DynamicSeq<Stmt>)reference);
        decl.body = decl.body.map(expr -> expr.accept(bodyResolver, local._2), pats -> pats.map(clause -> PatResolver.INSTANCE.matchy((Pattern.Clause)clause, (Context)local._2, bodyResolver)));
        info.declGraph().suc((Object)decl).appendAll((Iterable)reference);
        return Unit.unit();
    }

    @Override
    public Unit visitPrim(@NotNull Decl.PrimDecl decl, ResolveInfo info) {
        ExprResolver resolver = new ExprResolver(false, (DynamicSeq<PreLevelVar>)DynamicSeq.create(), (DynamicSeq<Stmt>)DynamicSeq.create());
        Tuple2<ImmutableSeq<Expr.Param>, Context> local = resolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = (ImmutableSeq)local._1;
        if (decl.result != null) {
            decl.result = decl.result.accept(resolver, (Context)local._2);
        }
        info.declGraph().suc((Object)decl).appendAll(resolver.reference());
        return Unit.unit();
    }

    @Override
    public Unit visitLevels( @NotNull Generalize.Levels levels, ResolveInfo info) {
        return Unit.unit();
    }

    @Override
    public Unit visitExample(@NotNull Sample.Working example, ResolveInfo info) {
        this.visitSample(example, info);
        return Unit.unit();
    }

    @Override
    public Unit visitCounterexample(@NotNull Sample.Counter example, ResolveInfo info) {
        this.visitSample(example, info);
        return Unit.unit();
    }

    private void visitSample(@NotNull Sample sample, ResolveInfo info) {
        Stmt delegate = sample.delegate();
        ResolveInfo delegateInfo = new ResolveInfo(info.opSet(), (MutableGraph<Stmt>)MutableGraph.create(), (MutableGraph<Stmt>)MutableGraph.create());
        delegate.accept(this, delegateInfo);
        info.sampleGraph().suc((Object)sample).appendAll((Iterable)delegateInfo.declGraph().suc((Object)delegate));
    }

    @Override
    public Unit visitRemark(@NotNull Remark remark, ResolveInfo info) {
        info.sampleGraph().suc((Object)remark).appendAll(remark.doResolve(info));
        return Unit.unit();
    }
}

