/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.visitor;

import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple2;
import kala.tuple.Unit;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.api.util.WithPos;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.resolve.ShallowResolveInfo;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.context.ModuleContext;
import org.aya.concrete.resolve.context.NoExportContext;
import org.aya.concrete.resolve.context.PhysicalModuleContext;
import org.aya.concrete.resolve.error.ModNotFoundError;
import org.aya.concrete.resolve.module.ModuleLoader;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.OpDecl;
import org.aya.concrete.stmt.Stmt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record StmtShallowResolver(@NotNull ModuleLoader loader, @Nullable ShallowResolveInfo resolveInfo) implements Stmt.Visitor<ModuleContext, Unit>
{
    @Override
    public Unit visitModule( @NotNull Command.Module mod, @NotNull ModuleContext context) {
        PhysicalModuleContext newCtx = context.derive(mod.name());
        this.visitAll(mod.contents(), newCtx);
        context.importModules((ImmutableSeq<String>)ImmutableSeq.of((Object)mod.name()), mod.accessibility(), newCtx.exports, mod.sourcePos());
        return Unit.unit();
    }

    @Override
    public Unit visitImport( @NotNull Command.Import cmd, @NotNull ModuleContext context) {
        MutableMap<ImmutableSeq<String>, MutableMap<String, Var>> success;
        ImmutableSeq<String> ids = cmd.path().ids();
        if (this.resolveInfo != null) {
            this.resolveInfo.imports().append(ids);
        }
        if ((success = this.loader.load(ids)) == null) {
            context.reportAndThrow(new ModNotFoundError((Seq<String>)cmd.path().ids(), cmd.sourcePos()));
        }
        context.importModules(cmd.path().ids(), Stmt.Accessibility.Private, success, cmd.sourcePos());
        return Unit.unit();
    }

    @Override
    public Unit visitOpen( @NotNull Command.Open cmd, @NotNull ModuleContext context) {
        context.openModule(cmd.path().ids(), cmd.accessibility(), cmd.useHide()::uses, (Map<String, String>)MutableHashMap.create(), cmd.sourcePos());
        return Unit.unit();
    }

    public void visitBind( @NotNull OpDecl.BindBlock bind, @NotNull ModuleContext context) {
        if (bind != OpDecl.BindBlock.EMPTY) {
            bind.context().value = context;
        }
    }

    @Override
    public Unit visitRemark(@NotNull Remark remark, @NotNull ModuleContext context) {
        remark.ctx = context;
        return Unit.unit();
    }

    private void visitDecl(@NotNull Decl decl, @NotNull ModuleContext context) {
        decl.ref().module = context.moduleName();
        context.addGlobalSimple(decl.accessibility(), (Var)decl.ref(), decl.sourcePos());
        decl.ctx = context;
    }

    @Override
    public Unit visitLevels( @NotNull Generalize.Levels levels, @NotNull ModuleContext context) {
        for (WithPos level : levels.levels()) {
            PreLevelVar genVar = (PreLevelVar)level.data();
            context.addGlobalSimple(levels.accessibility(), (Var)genVar, level.sourcePos());
        }
        return Unit.unit();
    }

    @Override
    public Unit visitData(@NotNull Decl.DataDecl decl, @NotNull ModuleContext context) {
        this.visitDecl(decl, context);
        PhysicalModuleContext dataInnerCtx = context.derive(decl.ref().name());
        ImmutableSeq ctorSymbols = decl.body.map(ctor -> {
            this.visitCtor((Decl.DataCtor)ctor, dataInnerCtx);
            return Tuple2.of((Object)ctor.ref.name(), ctor.ref);
        });
        context.importModules((ImmutableSeq<String>)ImmutableSeq.of((Object)decl.ref().name()), decl.accessibility(), (MutableMap<ImmutableSeq<String>, MutableMap<String, Var>>)MutableHashMap.of(Context.TOP_LEVEL_MOD_NAME, (Object)MutableHashMap.from((Iterable)ctorSymbols)), decl.sourcePos());
        decl.ctx = dataInnerCtx;
        this.visitBind(decl.bindBlock, dataInnerCtx);
        return Unit.unit();
    }

    @Override
    public Unit visitStruct(@NotNull Decl.StructDecl decl, @NotNull ModuleContext context) {
        this.visitDecl(decl, context);
        PhysicalModuleContext structInnerCtx = context.derive(decl.ref().name());
        decl.fields.forEach(field -> this.visitField((Decl.StructField)field, structInnerCtx));
        decl.ctx = structInnerCtx;
        this.visitBind(decl.bindBlock, structInnerCtx);
        return Unit.unit();
    }

    @Override
    public Unit visitFn(@NotNull Decl.FnDecl decl, @NotNull ModuleContext context) {
        this.visitDecl(decl, context);
        this.visitBind(decl.bindBlock, context);
        return Unit.unit();
    }

    @Override
    public Unit visitPrim(@NotNull Decl.PrimDecl decl, @NotNull ModuleContext moduleContext) {
        this.visitDecl(decl, moduleContext);
        return Unit.unit();
    }

    @Override
    public Unit visitExample( @NotNull Sample.Working example, @NotNull ModuleContext context) {
        example.delegate().accept(this, this.exampleContext(context));
        return Unit.unit();
    }

    @Override
    public Unit visitCounterexample( @NotNull Sample.Counter example, @NotNull ModuleContext context) {
        PhysicalModuleContext childCtx = this.exampleContext(context).derive("counter");
        Decl delegate = example.delegate();
        delegate.ctx = childCtx;
        childCtx.addGlobalSimple(Stmt.Accessibility.Private, (Var)delegate.ref(), delegate.sourcePos);
        return Unit.unit();
    }

    @NotNull
    private NoExportContext exampleContext(@NotNull ModuleContext context) {
        if (context instanceof PhysicalModuleContext) {
            PhysicalModuleContext physical = (PhysicalModuleContext)context;
            return physical.exampleContext();
        }
        throw new IllegalArgumentException("Invalid context: " + context);
    }

    @Override
    public Unit visitCtor(@NotNull Decl.DataCtor ctor, @NotNull ModuleContext context) {
        ctor.ref().module = context.moduleName();
        context.addGlobalSimple(Stmt.Accessibility.Public, (Var)ctor.ref, ctor.sourcePos);
        this.visitBind(ctor.bindBlock, context);
        return Unit.unit();
    }

    @Override
    public Unit visitField(@NotNull Decl.StructField field, @NotNull ModuleContext context) {
        field.ref().module = context.moduleName();
        context.addGlobalSimple(Stmt.Accessibility.Public, (Var)field.ref, field.sourcePos);
        this.visitBind(field.bindBlock, context);
        return Unit.unit();
    }
}

