/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import kala.collection.immutable.ImmutableSeq;
import org.aya.api.error.SourcePos;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Command
extends Stmt {

    public record Module(@NotNull SourcePos sourcePos, @NotNull String name, @NotNull @NotNull ImmutableSeq<@NotNull Stmt> contents) implements Command
    {
        @Override
        @NotNull
        public Stmt.Accessibility accessibility() {
            return Stmt.Accessibility.Public;
        }

        @Override
        public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
            return visitor.visitModule(this, p);
        }
    }

    public record Open(@NotNull SourcePos sourcePos, @NotNull Stmt.Accessibility accessibility, @NotNull QualifiedID path, @NotNull UseHide useHide) implements Command
    {
        @Override
        public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
            return visitor.visitOpen(this, p);
        }

        public record UseHide(@NotNull @NotNull ImmutableSeq<@NotNull String> list, @NotNull Strategy strategy) {
            public static final UseHide EMPTY = new UseHide((ImmutableSeq<String>)ImmutableSeq.empty(), Strategy.Hiding);

            public boolean uses(String name) {
                return switch (this.strategy) {
                    default -> throw new IncompatibleClassChangeError();
                    case Strategy.Using -> this.list.contains((Object)name);
                    case Strategy.Hiding -> !this.list.contains((Object)name);
                };
            }

            public static enum Strategy {
                Using,
                Hiding;

            }
        }
    }

    public record Import(@NotNull SourcePos sourcePos, @NotNull QualifiedID path, @Nullable String asName) implements Command
    {
        @Override
        @NotNull
        public Stmt.Accessibility accessibility() {
            return Stmt.Accessibility.Private;
        }

        @Override
        public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
            return visitor.visitImport(this, p);
        }
    }
}

