/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Unit;
import org.aya.api.util.Arg;
import org.aya.concrete.Expr;
import org.jetbrains.annotations.NotNull;

public interface ExprConsumer<P>
extends Expr.Visitor<P, Unit> {
    @Override
    default public Unit visitRef(@NotNull Expr.RefExpr expr, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitUnresolved(@NotNull Expr.UnresolvedExpr expr, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitError(@NotNull Expr.ErrorExpr error, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitHole(@NotNull Expr.HoleExpr holeExpr, P p) {
        Expr expr = holeExpr.filling();
        if (expr != null) {
            expr.accept(this, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitBinOpSeq(@NotNull Expr.BinOpSeq binOpSeq, P p) {
        binOpSeq.seq().forEach(e -> e.expr().accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitNew(@NotNull Expr.NewExpr expr, P p) {
        expr.fields().forEach(e -> e.body().accept(this, p));
        return (Unit)expr.struct().accept(this, p);
    }

    @Override
    default public Unit visitUniv(@NotNull Expr.UnivExpr expr, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitRawUniv(@NotNull Expr.RawUnivExpr expr, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitRawUnivArgs(@NotNull Expr.RawUnivArgsExpr expr, P p) {
        expr.univArgs().forEach(e -> e.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitUnivArgs(@NotNull Expr.UnivArgsExpr expr, P p) {
        return Unit.unit();
    }

    private void visitArg(@NotNull Arg<Expr.NamedArg> arg, P p) {
        ((Expr.NamedArg)arg.term()).expr().accept(this, p);
    }

    @Override
    default public Unit visitApp(@NotNull Expr.AppExpr expr, P p) {
        this.visitArg(expr.argument(), p);
        return (Unit)expr.function().accept(this, p);
    }

    default public void visitParams(@NotNull @NotNull ImmutableSeq<@NotNull Expr.Param> params, P p) {
        params.forEach(param -> {
            if (param.type() != null) {
                param.type().accept(this, p);
            }
        });
    }

    @Override
    default public Unit visitLam(@NotNull Expr.LamExpr expr, P p) {
        this.visitParams((ImmutableSeq<Expr.Param>)ImmutableSeq.of((Object)expr.param()), p);
        return (Unit)expr.body().accept(this, p);
    }

    @Override
    default public Unit visitPi(@NotNull Expr.PiExpr expr, P p) {
        this.visitParams((ImmutableSeq<Expr.Param>)ImmutableSeq.of((Object)expr.param()), p);
        return (Unit)expr.last().accept(this, p);
    }

    @Override
    default public Unit visitSigma(@NotNull Expr.SigmaExpr expr, P p) {
        this.visitParams(expr.params(), p);
        return Unit.unit();
    }

    @Override
    default public Unit visitTup(@NotNull Expr.TupExpr expr, P p) {
        expr.items().forEach(item -> item.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitProj(@NotNull Expr.ProjExpr expr, P p) {
        return (Unit)expr.tup().accept(this, p);
    }

    @Override
    default public Unit visitLitInt(@NotNull Expr.LitIntExpr expr, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitLmax(@NotNull Expr.LMaxExpr expr, P p) {
        for (Expr level : expr.levels()) {
            level.accept(this, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitLsuc(@NotNull Expr.LSucExpr expr, P p) {
        return (Unit)expr.expr().accept(this, p);
    }

    @Override
    default public Unit visitLitString(@NotNull Expr.LitStringExpr expr, P p) {
        return Unit.unit();
    }
}

