/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core;

import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.tuple.Tuple2;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.core.term.CallTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Substituter;
import org.aya.generic.Constants;
import org.aya.tyck.TyckState;
import org.jetbrains.annotations.NotNull;

public final class Meta
implements Var {
    @NotNull
    public final ImmutableSeq<Term.Param> contextTele;
    @NotNull
    public final ImmutableSeq<Term.Param> telescope;
    @NotNull
    public final String name;
    @NotNull
    public final Term result;
    @NotNull
    public final SourcePos sourcePos;
    @NotNull
    public final DynamicSeq<Tuple2<Substituter.TermSubst, Term>> conditions = DynamicSeq.create();

    public SeqView<Term.Param> fullTelescope() {
        return this.contextTele.view().concat(this.telescope);
    }

    public boolean solve(@NotNull TyckState state, @NotNull Term t) {
        if (t.findUsages(this) > 0) {
            return false;
        }
        state.metas().put((Object)this, (Object)t);
        return true;
    }

    private Meta(@NotNull ImmutableSeq<Term.Param> contextTele, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull String name, @NotNull Term result, @NotNull SourcePos sourcePos) {
        this.contextTele = contextTele;
        this.telescope = telescope;
        this.name = name;
        this.result = result;
        this.sourcePos = sourcePos;
    }

    @NotNull
    public static Meta from(@NotNull ImmutableSeq<Term.Param> contextTele, @NotNull String name, @NotNull Term result, @NotNull SourcePos sourcePos) {
        if (result instanceof FormTerm.Pi) {
            FormTerm.Pi pi = (FormTerm.Pi)result;
            DynamicSeq buf = DynamicSeq.create();
            Term r = pi.parameters((DynamicSeq<Term.Param>)buf);
            return new Meta(contextTele, (ImmutableSeq<Term.Param>)buf.toImmutableSeq(), name, r, sourcePos);
        }
        return new Meta(contextTele, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), name, result, sourcePos);
    }

    @NotNull
    public FormTerm.Pi asPi(@NotNull String domName, @NotNull String codName, boolean explicit, @NotNull ImmutableSeq<Arg<Term>> contextArgs) {
        assert (this.telescope.isEmpty());
        Meta domVar = Meta.from(this.contextTele, domName, this.result, this.sourcePos);
        Meta codVar = Meta.from(this.contextTele, codName, this.result, this.sourcePos);
        CallTerm.Hole dom = new CallTerm.Hole(domVar, contextArgs, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
        CallTerm.Hole cod = new CallTerm.Hole(codVar, contextArgs, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
        Term.Param domParam = new Term.Param(Constants.randomlyNamed(this.sourcePos), dom, explicit);
        return new FormTerm.Pi(domParam, cod);
    }

    @NotNull
    public String name() {
        return this.name;
    }
}

