/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Unit;
import org.aya.api.core.CorePat;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.LocalVar;
import org.aya.api.util.Arg;
import org.aya.concrete.stmt.Decl;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.PatToTerm;
import org.aya.core.term.CallTerm;
import org.aya.core.term.Term;
import org.aya.distill.BaseDistiller;
import org.aya.distill.CoreDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.LocalCtx;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Debug.Renderer(text="toTerm().toDoc(DistillerOptions.DEBUG).debugRender()")
public interface Pat
extends CorePat {
    @NotNull
    public Term type();

    public <P, R> R accept(@NotNull Visitor<P, R> var1, P var2);

    @NotNull
    default public Term toTerm() {
        return this.accept(PatToTerm.INSTANCE, Unit.unit());
    }

    @NotNull
    default public Arg<Term> toArg() {
        return new Arg((AyaDocile)this.toTerm(), this.explicit());
    }

    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return this.accept(new CoreDistiller(options), BaseDistiller.Outer.Free);
    }

    public void storeBindings(@NotNull LocalCtx var1);

    @NotNull
    public static ImmutableSeq<Term.Param> extractTele(@NotNull SeqLike<Pat> pats) {
        LocalCtx localCtx = new LocalCtx();
        for (Pat pat : pats) {
            pat.storeBindings(localCtx);
        }
        return localCtx.extract();
    }

    public static interface Visitor<P, R> {
        public R visitBind(@NotNull Bind var1, P var2);

        public R visitTuple(@NotNull Tuple var1, P var2);

        public R visitCtor(@NotNull Ctor var1, P var2);

        public R visitAbsurd(@NotNull Absurd var1, P var2);

        public R visitPrim(@NotNull Prim var1, P var2);
    }

    public record PrototypeClause(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Pat> patterns, @NotNull Option<Term> expr) implements AyaDocile
    {
        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            Doc doc = new CoreDistiller(options).visitMaybeCtorPatterns((SeqLike<Pat>)this.patterns, BaseDistiller.Outer.Free, Doc.COMMA);
            if (this.expr.isDefined()) {
                return Doc.sep((Doc[])new Doc[]{doc, Doc.symbol((String)"=>"), ((Term)this.expr.get()).toDoc(options)});
            }
            return doc;
        }

        @NotNull
        public static PrototypeClause prototypify(@NotNull Matching clause) {
            return new PrototypeClause(clause.sourcePos(), clause.patterns(), (Option<Term>)Option.some((Object)clause.body()));
        }

        @NotNull
        public PrototypeClause mapTerm(@NotNull Function<Term, Term> termMap) {
            return new PrototypeClause(this.sourcePos, this.patterns, (Option<Term>)this.expr.map(termMap));
        }

        @NotNull
        public static @NotNull Option<@NotNull Matching> deprototypify(@NotNull PrototypeClause clause) {
            return clause.expr.map(term -> new Matching(clause.sourcePos, clause.patterns, (Term)term));
        }
    }

    public static final class Prim
    extends Record
    implements Pat {
        private final boolean explicit;
        @NotNull
        private final DefVar<PrimDef, Decl.PrimDecl> ref;
        @NotNull
        private final Term type;

        public Prim(boolean explicit, @NotNull DefVar<PrimDef, Decl.PrimDecl> ref, @NotNull Term type) {
            this.explicit = explicit;
            this.ref = ref;
            this.type = type;
        }

        @Nullable
        public LocalVar as() {
            return null;
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitPrim(this, p);
        }

        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Prim.class, "explicit;ref;type", "explicit", "ref", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Prim.class, "explicit;ref;type", "explicit", "ref", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Prim.class, "explicit;ref;type", "explicit", "ref", "type"}, this, o);
        }

        public boolean explicit() {
            return this.explicit;
        }

        @NotNull
        public DefVar<PrimDef, Decl.PrimDecl> ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public Term type() {
            return this.type;
        }
    }

    public static final class Ctor
    extends Record
    implements Pat {
        private final boolean explicit;
        @NotNull
        private final DefVar<CtorDef, Decl.DataCtor> ref;
        @NotNull
        private final ImmutableSeq<Pat> params;
        @Nullable
        private final LocalVar as;
        @NotNull
        private final CallTerm.Data type;

        public Ctor(boolean explicit, @NotNull DefVar<CtorDef, Decl.DataCtor> ref, @NotNull ImmutableSeq<Pat> params, @Nullable LocalVar as, @NotNull CallTerm.Data type) {
            this.explicit = explicit;
            this.ref = ref;
            this.params = params;
            this.as = as;
            this.type = type;
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitCtor(this, p);
        }

        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
            if (this.as != null) {
                localCtx.put(this.as, this.type);
            }
            this.params.forEach(pat -> pat.storeBindings(localCtx));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Ctor.class, "explicit;ref;params;as;type", "explicit", "ref", "params", "as", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Ctor.class, "explicit;ref;params;as;type", "explicit", "ref", "params", "as", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Ctor.class, "explicit;ref;params;as;type", "explicit", "ref", "params", "as", "type"}, this, o);
        }

        public boolean explicit() {
            return this.explicit;
        }

        @NotNull
        public DefVar<CtorDef, Decl.DataCtor> ref() {
            return this.ref;
        }

        @NotNull
        public ImmutableSeq<Pat> params() {
            return this.params;
        }

        @Nullable
        public LocalVar as() {
            return this.as;
        }

        @Override
        @NotNull
        public CallTerm.Data type() {
            return this.type;
        }
    }

    public static final class Tuple
    extends Record
    implements Pat {
        private final boolean explicit;
        @NotNull
        private final ImmutableSeq<Pat> pats;
        @Nullable
        private final LocalVar as;
        @NotNull
        private final Term type;

        public Tuple(boolean explicit, @NotNull ImmutableSeq<Pat> pats, @Nullable LocalVar as, @NotNull Term type) {
            this.explicit = explicit;
            this.pats = pats;
            this.as = as;
            this.type = type;
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitTuple(this, p);
        }

        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
            if (this.as != null) {
                localCtx.put(this.as, this.type);
            }
            this.pats.forEach(pat -> pat.storeBindings(localCtx));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Tuple.class, "explicit;pats;as;type", "explicit", "pats", "as", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Tuple.class, "explicit;pats;as;type", "explicit", "pats", "as", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Tuple.class, "explicit;pats;as;type", "explicit", "pats", "as", "type"}, this, o);
        }

        public boolean explicit() {
            return this.explicit;
        }

        @NotNull
        public ImmutableSeq<Pat> pats() {
            return this.pats;
        }

        @Nullable
        public LocalVar as() {
            return this.as;
        }

        @Override
        @NotNull
        public Term type() {
            return this.type;
        }
    }

    public static final class Absurd
    extends Record
    implements Pat {
        private final boolean explicit;
        @NotNull
        private final Term type;

        public Absurd(boolean explicit, @NotNull Term type) {
            this.explicit = explicit;
            this.type = type;
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitAbsurd(this, p);
        }

        @Nullable
        public LocalVar as() {
            return null;
        }

        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
            throw new IllegalStateException();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Absurd.class, "explicit;type", "explicit", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Absurd.class, "explicit;type", "explicit", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Absurd.class, "explicit;type", "explicit", "type"}, this, o);
        }

        public boolean explicit() {
            return this.explicit;
        }

        @Override
        @NotNull
        public Term type() {
            return this.type;
        }
    }

    public static final class Bind
    extends Record
    implements Pat {
        private final boolean explicit;
        @NotNull
        private final LocalVar as;
        @NotNull
        private final Term type;

        public Bind(boolean explicit, @NotNull LocalVar as, @NotNull Term type) {
            this.explicit = explicit;
            this.as = as;
            this.type = type;
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitBind(this, p);
        }

        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
            localCtx.put(this.as, this.type);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Bind.class, "explicit;as;type", "explicit", "as", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Bind.class, "explicit;as;type", "explicit", "as", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Bind.class, "explicit;as;type", "explicit", "as", "type"}, this, o);
        }

        public boolean explicit() {
            return this.explicit;
        }

        @NotNull
        public LocalVar as() {
            return this.as;
        }

        @Override
        @NotNull
        public Term type() {
            return this.type;
        }
    }
}

