/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Unit;
import org.aya.api.distill.AyaDocile;
import org.aya.api.ref.LocalVar;
import org.aya.api.util.Arg;
import org.aya.core.def.CtorDef;
import org.aya.core.pat.Pat;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.jetbrains.annotations.NotNull;

public class PatToTerm
implements Pat.Visitor<Unit, Term> {
    @NotNull
    static final PatToTerm INSTANCE = new PatToTerm();

    protected PatToTerm() {
    }

    @Override
    public Term visitAbsurd(@NotNull Pat.Absurd absurd, Unit unit) {
        return new RefTerm(new LocalVar("()"), absurd.type());
    }

    @Override
    public Term visitPrim(@NotNull Pat.Prim prim, Unit unit) {
        return new CallTerm.Prim(prim.ref(), (ImmutableSeq<Sort>)ImmutableSeq.empty(), (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
    }

    @Override
    public Term visitBind(@NotNull Pat.Bind bind, Unit unit) {
        return new RefTerm(bind.as(), bind.type());
    }

    @Override
    public Term visitTuple(@NotNull Pat.Tuple tuple, Unit unit) {
        return new IntroTerm.Tuple((ImmutableSeq<Term>)tuple.pats().map(p -> p.accept(this, Unit.unit())));
    }

    @Override
    public Term visitCtor(@NotNull Pat.Ctor ctor, Unit unit) {
        CallTerm.Data data = ctor.type();
        CtorDef core = (CtorDef)ctor.ref().core;
        ImmutableSeq tele = core.selfTele;
        ImmutableSeq args = ctor.params().view().zip((Iterable)tele.view()).map(p -> new Arg((AyaDocile)((Pat)p._1).accept(this, Unit.unit()), ((Term.Param)p._2).explicit())).toImmutableSeq();
        return new CallTerm.Con(data.ref(), ctor.ref(), data.args(), data.sortArgs(), (ImmutableSeq<Arg<Term>>)args);
    }
}

