/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.core.pat.Pat;
import org.aya.core.visitor.Substituter;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PatUnify(@NotNull Substituter.TermSubst lhsSubst, @NotNull Substituter.TermSubst rhsSubst) {
    private void unify(@NotNull Pat lhs, @NotNull Pat rhs) {
        Pat pat = lhs;
        Objects.requireNonNull(pat);
        Pat pat2 = pat;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Bind.class, Pat.Tuple.class, Pat.Absurd.class, Pat.Prim.class, Pat.Ctor.class}, (Object)pat2, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                Pat.Bind bind = (Pat.Bind)pat2;
                break;
            }
            case 1: {
                Pat.Tuple tuple = (Pat.Tuple)pat2;
                if (rhs instanceof Pat.Tuple) {
                    Pat.Tuple tuple1 = (Pat.Tuple)rhs;
                    this.visitList(tuple.pats(), tuple1.pats());
                    break;
                }
                this.reportError(lhs, rhs);
                break;
            }
            case 2: {
                Pat.Absurd absurd = (Pat.Absurd)pat2;
                throw new IllegalStateException();
            }
            case 3: {
                Pat.Prim prim = (Pat.Prim)pat2;
                if (!(rhs instanceof Pat.Prim)) {
                    this.reportError(lhs, rhs);
                    break;
                }
                Pat.Prim prim1 = (Pat.Prim)rhs;
                assert (prim.ref() == prim1.ref());
                break;
            }
            case 4: {
                Pat.Ctor ctor = (Pat.Ctor)pat2;
                if (rhs instanceof Pat.Ctor) {
                    Pat.Ctor ctor1 = (Pat.Ctor)rhs;
                    assert (ctor.ref() == ctor1.ref());
                    this.visitList(ctor.params(), ctor1.params());
                    break;
                }
                this.reportError(lhs, rhs);
            }
        }
    }

    private void visitList(ImmutableSeq<Pat> lpats, ImmutableSeq<Pat> rpats) {
        assert (rpats.sizeEquals(lpats.size()));
        lpats.zip(rpats).forEach(pp -> PatUnify.unifyPat((Pat)pp._1, (Pat)pp._2, this.lhsSubst, this.rhsSubst));
    }

    private static void visitAs(@Nullable LocalVar as, Pat rhs, PatUnify unifier) {
        if (as == null) {
            return;
        }
        unifier.lhsSubst.add((Var)as, rhs.toTerm());
    }

    private void reportError(@NotNull Pat lhs, @NotNull Pat pat) {
        Doc doc = Doc.sep((Doc[])new Doc[]{lhs.toDoc(DistillerOptions.debug()), Doc.plain((String)"and"), pat.toDoc(DistillerOptions.debug())});
        throw new IllegalArgumentException(doc.debugRender() + " are patterns of different types!");
    }

    private static void unifyPat(Pat lhs, Pat rhs, Substituter.TermSubst lhsSubst, Substituter.TermSubst rhsSubst) {
        PatUnify unify;
        if (rhs instanceof Pat.Bind) {
            unify = new PatUnify(rhsSubst, lhsSubst);
            unify.unify(rhs, lhs);
        } else {
            unify = new PatUnify(lhsSubst, rhsSubst);
            unify.unify(lhs, rhs);
        }
        PatUnify.visitAs(lhs.as(), rhs, unify);
        PatUnify.visitAs(rhs.as(), lhs, unify);
    }

    public static void unifyPat(@NotNull SeqLike<Pat> lpats, @NotNull SeqLike<Pat> rpats, @NotNull Substituter.TermSubst lhsSubst, @NotNull Substituter.TermSubst rhsSubst) {
        assert (rpats.sizeEquals(lpats));
        lpats.view().zip(rpats).forEach(pp -> PatUnify.unifyPat((Pat)pp._1, (Pat)pp._2, lhsSubst, rhsSubst));
    }
}

