/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import org.aya.api.concrete.ConcreteDecl;
import org.aya.api.core.CoreDef;
import org.aya.api.distill.AyaDocile;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.LocalVar;
import org.aya.api.util.Arg;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerLevel;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SerTerm
extends Serializable {
    @NotNull
    public Term de(@NotNull DeState var1);

    public record FieldRef(@NotNull SerDef.QName name) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new RefTerm.Field(state.def(this.name));
        }
    }

    public record Access(@NotNull SerTerm of, @NotNull SerDef.QName ref, @NotNull @NotNull ImmutableSeq<@NotNull SerLevel.Max> sortArgs, @NotNull @NotNull ImmutableSeq<@NotNull SerArg> structArgs, @NotNull @NotNull ImmutableSeq<@NotNull SerArg> fieldArgs) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Access(this.of.de(state), state.def(this.ref), (ImmutableSeq<Sort>)this.sortArgs.map(max -> max.de(state.levelCache)), (ImmutableSeq<Arg<Term>>)this.structArgs.map(arg -> arg.de(state)), (ImmutableSeq<Arg<Term>>)this.fieldArgs.map(arg -> arg.de(state)));
        }
    }

    public record Tup(@NotNull ImmutableSeq<SerTerm> components) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.Tuple((ImmutableSeq<Term>)this.components.map(t -> t.de(state)));
        }
    }

    public record ConCall(@NotNull SerDef.QName dataRef, @NotNull SerDef.QName selfRef, @NotNull CallData dataArgs, @NotNull ImmutableSeq<SerArg> args) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Con(state.def(this.dataRef), state.def(this.selfRef), this.dataArgs.de(state), this.dataArgs.de(state.levelCache), (ImmutableSeq<Arg<Term>>)this.args.map(arg -> arg.de(state)));
        }
    }

    public record PrimCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Prim(state.def(this.name), this.data.de(state.levelCache), this.data.de(state));
        }
    }

    public record DataCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public CallTerm.Data de(@NotNull DeState state) {
            return new CallTerm.Data(state.def(this.name), this.data.de(state.levelCache), this.data.de(state));
        }
    }

    public record FnCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Fn(state.def(this.name), this.data.de(state.levelCache), this.data.de(state));
        }
    }

    public record StructCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Struct(state.def(this.name), this.data.de(state.levelCache), this.data.de(state));
        }
    }

    public record CallData(@NotNull ImmutableSeq<SerLevel.Max> sortArgs, @NotNull ImmutableSeq<SerArg> args) implements Serializable
    {
        @NotNull
        public ImmutableSeq<Sort> de(@NotNull MutableMap<Integer, Sort.LvlVar> levelCache) {
            return this.sortArgs.map(max -> max.de(levelCache));
        }

        @NotNull
        public ImmutableSeq<Arg<Term>> de(@NotNull DeState state) {
            return this.args.map(arg -> arg.de(state));
        }
    }

    public record App(@NotNull SerTerm of, @NotNull SerArg arg) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ElimTerm.App(this.of.de(state), this.arg.de(state));
        }
    }

    public record SerArg(@NotNull SerTerm arg, boolean explicit) implements Serializable
    {
        @NotNull
        public Arg<Term> de(@NotNull DeState state) {
            return new Arg((AyaDocile)this.arg.de(state), this.explicit);
        }
    }

    public record Proj(@NotNull SerTerm of, int ix) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ElimTerm.Proj(this.of.de(state), this.ix);
        }
    }

    public record New(@NotNull StructCall call) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            throw new UnsupportedOperationException("TODO");
        }
    }

    public record Lam(@NotNull SerParam param, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.Lambda(this.param.de(state), this.body.de(state));
        }
    }

    public record Ref(@NotNull SimpVar var, @NotNull SerTerm type) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new RefTerm(state.var(this.var), this.type.de(state));
        }
    }

    public record Univ(@NotNull SerLevel.Max u) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Univ(this.u.de(state.levelCache));
        }
    }

    public record Sigma(@NotNull ImmutableSeq<SerParam> params) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Sigma((ImmutableSeq<Term.Param>)this.params.map(p -> p.de(state)));
        }
    }

    public record Pi(@NotNull SerParam param, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Pi(this.param.de(state), this.body.de(state));
        }
    }

    public record SerParam(boolean explicit, boolean pattern, @NotNull SimpVar var, @NotNull SerTerm term) implements Serializable
    {
        @NotNull
        public Term.Param de(@NotNull DeState state) {
            return new Term.Param(state.var(this.var), this.term.de(state), this.pattern, this.explicit);
        }
    }

    public record SimpVar(int var, @NotNull String name) implements Serializable
    {
    }

    public record DeState(@NotNull MutableMap<Seq<String>, MutableMap<Integer, DefVar<?, ?>>> defCache, @NotNull MutableMap<Integer, Sort.LvlVar> levelCache, @NotNull MutableMap<Integer, LocalVar> localCache) {
        public DeState() {
            this(MutableMap.create(), (MutableMap<Integer, Sort.LvlVar>)MutableMap.create(), (MutableMap<Integer, LocalVar>)MutableMap.create());
        }

        @NotNull
        public LocalVar var(@NotNull SimpVar var) {
            return (LocalVar)this.localCache.getOrPut((Object)var.var, () -> new LocalVar(var.name));
        }

        @NotNull
        public <Core extends CoreDef, Concrete extends ConcreteDecl> DefVar<Core, Concrete> def(@NotNull SerDef.QName name) {
            DefVar dv = (DefVar)((MutableMap)this.defCache.getOrPut(name.mod(), MutableHashMap::new)).getOrPut((Object)name.id(), () -> DefVar.empty((String)name.name()));
            assert (Objects.equals(name.name(), dv.name()));
            return dv;
        }
    }
}

