/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Signatured;
import org.aya.core.Meta;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.sort.Sort;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.Term;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CallTerm
extends Term {
    @NotNull
    public Var ref();

    @NotNull
    public @NotNull ImmutableSeq<@NotNull Sort> sortArgs();

    @NotNull
    public @NotNull ImmutableSeq<@NotNull Arg<Term>> args();

    @Contract(pure=true)
    @NotNull
    public static Term make(@NotNull Term f, @NotNull Arg<Term> arg) {
        if (f instanceof Hole) {
            Hole hole = (Hole)f;
            if (hole.args.sizeLessThan(hole.ref.telescope)) {
                return new Hole(hole.ref, hole.contextArgs, (ImmutableSeq<Arg<Term>>)hole.args.appended(arg));
            }
        }
        if (!(f instanceof IntroTerm.Lambda)) {
            return new ElimTerm.App(f, arg);
        }
        IntroTerm.Lambda lam = (IntroTerm.Lambda)f;
        return CallTerm.make(lam, arg);
    }

    @NotNull
    public static Term make(IntroTerm.Lambda lam, @NotNull Arg<Term> arg) {
        Term.Param param = lam.param();
        if (!1.$assertionsDisabled && arg.explicit() != param.explicit()) {
            throw new AssertionError();
        }
        return lam.body().subst((Var)param.ref(), (Term)arg.term());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class Hole
    extends Record
    implements CallTerm {
        @NotNull
        private final Meta ref;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> contextArgs;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> args;

        public Hole(@NotNull Meta ref, @NotNull @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> contextArgs, @NotNull @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> args) {
            this.ref = ref;
            this.contextArgs = contextArgs;
            this.args = args;
        }

        @NotNull
        public FormTerm.Pi asPi(boolean explicit) {
            return this.ref.asPi(this.ref.name() + "dom", this.ref.name() + "cod", explicit, this.contextArgs);
        }

        @NotNull
        public @NotNull SeqView<@NotNull Arg<Term>> fullArgs() {
            return this.contextArgs.view().concat(this.args);
        }

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitHole(this, p);
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Sort> sortArgs() {
            return ImmutableSeq.empty();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Hole.class, "ref;contextArgs;args", "ref", "contextArgs", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Hole.class, "ref;contextArgs;args", "ref", "contextArgs", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Hole.class, "ref;contextArgs;args", "ref", "contextArgs", "args"}, this, o);
        }

        @Override
        @NotNull
        public Meta ref() {
            return this.ref;
        }

        @NotNull
        public @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> contextArgs() {
            return this.contextArgs;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> args() {
            return this.args;
        }
    }

    public static final class Access
    extends Record
    implements CallTerm {
        @NotNull
        private final Term of;
        @NotNull
        private final DefVar<FieldDef, Decl.StructField> ref;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Sort> sortArgs;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> structArgs;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> fieldArgs;

        public Access(@NotNull Term of, @NotNull DefVar<FieldDef, Decl.StructField> ref, @NotNull @NotNull ImmutableSeq<@NotNull Sort> sortArgs, @NotNull @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> structArgs, @NotNull @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> fieldArgs) {
            this.of = of;
            this.ref = ref;
            this.sortArgs = sortArgs;
            this.structArgs = structArgs;
            this.fieldArgs = fieldArgs;
        }

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitAccess(this, p);
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Arg<Term>> args() {
            return this.structArgs.concat(this.fieldArgs);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Access.class, "of;ref;sortArgs;structArgs;fieldArgs", "of", "ref", "sortArgs", "structArgs", "fieldArgs"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Access.class, "of;ref;sortArgs;structArgs;fieldArgs", "of", "ref", "sortArgs", "structArgs", "fieldArgs"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Access.class, "of;ref;sortArgs;structArgs;fieldArgs", "of", "ref", "sortArgs", "structArgs", "fieldArgs"}, this, o);
        }

        @NotNull
        public Term of() {
            return this.of;
        }

        @NotNull
        public DefVar<FieldDef, Decl.StructField> ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Sort> sortArgs() {
            return this.sortArgs;
        }

        @NotNull
        public @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> structArgs() {
            return this.structArgs;
        }

        @NotNull
        public @NotNull ImmutableSeq<@NotNull Arg<@NotNull Term>> fieldArgs() {
            return this.fieldArgs;
        }
    }

    public record Con(@NotNull ConHead head, @NotNull ImmutableSeq<Arg<Term>> conArgs) implements CallTerm
    {
        public Con(@NotNull DefVar<DataDef, Decl.DataDecl> dataRef, @NotNull DefVar<CtorDef, Decl.DataCtor> ref, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> dataArgs, @NotNull @NotNull ImmutableSeq<@NotNull Sort> sortArgs, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> conArgs) {
            this(new ConHead(dataRef, ref, sortArgs, dataArgs), conArgs);
        }

        @NotNull
        public DefVar<CtorDef, Decl.DataCtor> ref() {
            return this.head.ref;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Sort> sortArgs() {
            return this.head.sortArgs;
        }

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitConCall(this, p);
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<Arg<@NotNull Term>> args() {
            return this.head.dataArgs.view().concat(this.conArgs).toImmutableSeq();
        }
    }

    public record ConHead(@NotNull DefVar<DataDef, Decl.DataDecl> dataRef, @NotNull DefVar<CtorDef, Decl.DataCtor> ref, @NotNull @NotNull ImmutableSeq<@NotNull Sort> sortArgs, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> dataArgs) {
        @NotNull
        public Data underlyingDataCall() {
            return new Data(this.dataRef, this.sortArgs, this.dataArgs);
        }
    }

    public static final class Struct
    extends Record
    implements CallTerm {
        @NotNull
        private final DefVar<StructDef, Decl.StructDecl> ref;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Sort> sortArgs;
        @NotNull
        private final @NotNull ImmutableSeq<Arg<@NotNull Term>> args;

        public Struct(@NotNull DefVar<StructDef, Decl.StructDecl> ref, @NotNull @NotNull ImmutableSeq<@NotNull Sort> sortArgs, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args) {
            this.ref = ref;
            this.sortArgs = sortArgs;
            this.args = args;
        }

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitStructCall(this, p);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Struct.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Struct.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Struct.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this, o);
        }

        @NotNull
        public DefVar<StructDef, Decl.StructDecl> ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Sort> sortArgs() {
            return this.sortArgs;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<Arg<@NotNull Term>> args() {
            return this.args;
        }
    }

    public static final class Data
    extends Record
    implements CallTerm {
        @NotNull
        private final DefVar<DataDef, Decl.DataDecl> ref;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Sort> sortArgs;
        @NotNull
        private final @NotNull ImmutableSeq<Arg<@NotNull Term>> args;

        public Data(@NotNull DefVar<DataDef, Decl.DataDecl> ref, @NotNull @NotNull ImmutableSeq<@NotNull Sort> sortArgs, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args) {
            this.ref = ref;
            this.sortArgs = sortArgs;
            this.args = args;
        }

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitDataCall(this, p);
        }

        @NotNull
        public ConHead conHead(@NotNull DefVar<CtorDef, Decl.DataCtor> ctorRef) {
            return new ConHead(this.ref, ctorRef, this.sortArgs, this.args);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this, o);
        }

        @NotNull
        public DefVar<DataDef, Decl.DataDecl> ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Sort> sortArgs() {
            return this.sortArgs;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<Arg<@NotNull Term>> args() {
            return this.args;
        }
    }

    public static final class Prim
    extends Record
    implements CallTerm {
        @NotNull
        private final DefVar<PrimDef, Decl.PrimDecl> ref;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Sort> sortArgs;
        @NotNull
        private final @NotNull ImmutableSeq<Arg<@NotNull Term>> args;

        public Prim(@NotNull DefVar<PrimDef, Decl.PrimDecl> ref, @NotNull @NotNull ImmutableSeq<@NotNull Sort> sortArgs, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args) {
            this.ref = ref;
            this.sortArgs = sortArgs;
            this.args = args;
        }

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitPrimCall(this, p);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Prim.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Prim.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Prim.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this, o);
        }

        @NotNull
        public DefVar<PrimDef, Decl.PrimDecl> ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Sort> sortArgs() {
            return this.sortArgs;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<Arg<@NotNull Term>> args() {
            return this.args;
        }
    }

    public static final class Fn
    extends Record
    implements CallTerm {
        @NotNull
        private final DefVar<FnDef, Decl.FnDecl> ref;
        @NotNull
        private final @NotNull ImmutableSeq<@NotNull Sort> sortArgs;
        @NotNull
        private final @NotNull ImmutableSeq<Arg<@NotNull Term>> args;

        public Fn(@NotNull DefVar<FnDef, Decl.FnDecl> ref, @NotNull @NotNull ImmutableSeq<@NotNull Sort> sortArgs, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args) {
            this.ref = ref;
            this.sortArgs = sortArgs;
            this.args = args;
        }

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitFnCall(this, p);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Fn.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Fn.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Fn.class, "ref;sortArgs;args", "ref", "sortArgs", "args"}, this, o);
        }

        @NotNull
        public DefVar<FnDef, Decl.FnDecl> ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<@NotNull Sort> sortArgs() {
            return this.sortArgs;
        }

        @Override
        @NotNull
        public @NotNull ImmutableSeq<Arg<@NotNull Term>> args() {
            return this.args;
        }
    }

    @FunctionalInterface
    public static interface Factory<D extends Def, S extends Signatured> {
        @Contract(pure=true, value="_,_,_->new")
        @NotNull
        public CallTerm make(DefVar<D, S> var1, ImmutableSeq<@NotNull Sort> var2, ImmutableSeq<@NotNull Arg<Term>> var3);
    }
}

