/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.Var;
import org.aya.core.sort.Sort;
import org.aya.core.term.Term;
import org.aya.generic.Constants;
import org.aya.generic.Level;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FormTerm
extends Term {
    @NotNull
    public static Univ freshUniv(@NotNull SourcePos pos) {
        return new Univ(new Sort(new Level.Reference<Sort.LvlVar>(new Sort.LvlVar(Constants.randomName(pos), pos))));
    }

    public record Univ(@NotNull Sort sort) implements FormTerm
    {
        @NotNull
        public static final Univ ZERO = new Univ(new Sort(new Level.Constant<Sort.LvlVar>(0)));

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitUniv(this, p);
        }
    }

    public record Sigma(@NotNull @NotNull ImmutableSeq<@NotNull Term.Param> params) implements FormTerm
    {
        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitSigma(this, p);
        }
    }

    public record Pi(@NotNull Term.Param param, @NotNull Term body) implements FormTerm
    {
        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitPi(this, p);
        }

        @NotNull
        public Term substBody(@NotNull Term term) {
            return this.body.subst((Var)this.param.ref(), term);
        }

        @NotNull
        public Term parameters(@NotNull @NotNull DynamicSeq<@NotNull Term.Param> params) {
            params.append((Object)this.param);
            Term t = this.body;
            while (t instanceof Pi) {
                Pi pi = (Pi)t;
                params.append((Object)pi.param);
                t = pi.body;
            }
            return t;
        }

        @NotNull
        public static Term make(@NotNull @NotNull SeqLike<@NotNull Term.Param> telescope, @NotNull Term body) {
            return (Term)telescope.view().foldRight((Object)body, Pi::new);
        }
    }
}

