/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import org.aya.api.distill.DistillerOptions;
import org.aya.api.util.NormalizeMode;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Unfolder;
import org.aya.tyck.TyckState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Normalizer(@Nullable TyckState state) implements Unfolder<NormalizeMode>
{
    @Override
    @NotNull
    public Term visitApp(@NotNull ElimTerm.App term, NormalizeMode mode) {
        Term fn = term.of().accept(this, mode);
        if (fn instanceof IntroTerm.Lambda) {
            IntroTerm.Lambda lambda = (IntroTerm.Lambda)fn;
            return CallTerm.make(lambda, this.visitArg(term.arg(), mode)).accept(this, mode);
        }
        if (mode == NormalizeMode.NF) {
            return CallTerm.make(fn, this.visitArg(term.arg(), mode));
        }
        return term;
    }

    @Override
    @NotNull
    public Term visitRef(@NotNull RefTerm term, NormalizeMode mode) {
        return term;
    }

    @Override
    @NotNull
    public Term visitFieldRef(@NotNull RefTerm.Field term, NormalizeMode normalizeMode) {
        return term;
    }

    @Override
    @NotNull
    public Term visitLam(@NotNull IntroTerm.Lambda term, NormalizeMode mode) {
        if (mode != NormalizeMode.NF) {
            return term;
        }
        return Unfolder.super.visitLam(term, mode);
    }

    @Override
    @NotNull
    public Term visitPi(@NotNull FormTerm.Pi term, NormalizeMode mode) {
        if (mode != NormalizeMode.NF) {
            return term;
        }
        return Unfolder.super.visitPi(term, mode);
    }

    @Override
    @NotNull
    public Term visitSigma(@NotNull FormTerm.Sigma term, NormalizeMode mode) {
        if (mode != NormalizeMode.NF) {
            return term;
        }
        return Unfolder.super.visitSigma(term, mode);
    }

    @Override
    @NotNull
    public Term visitTup(@NotNull IntroTerm.Tuple term, NormalizeMode mode) {
        if (mode != NormalizeMode.NF) {
            return term;
        }
        return Unfolder.super.visitTup(term, mode);
    }

    @Override
    @NotNull
    public Term visitProj(@NotNull ElimTerm.Proj term, NormalizeMode mode) {
        Term tup = term.of().accept(this, NormalizeMode.WHNF);
        int ix = term.ix();
        if (!(tup instanceof IntroTerm.Tuple)) {
            return tup == term.of() ? term : new ElimTerm.Proj(tup, ix);
        }
        IntroTerm.Tuple t = (IntroTerm.Tuple)tup;
        assert (t.items().sizeGreaterThanOrEquals(ix) && ix > 0) : term.toDoc(DistillerOptions.debug()).debugRender();
        return ((Term)t.items().get(ix - 1)).accept(this, mode);
    }
}

