/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import kala.tuple.Unit;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Substituter;
import org.aya.core.visitor.TermFixpoint;
import org.jetbrains.annotations.NotNull;

public final class Renamer
implements TermFixpoint<Unit> {
    private final Substituter.TermSubst subst = new Substituter.TermSubst((MutableMap<Var, Term>)MutableMap.create());

    @Override
    @NotNull
    public Term visitFieldRef(@NotNull RefTerm.Field field, Unit unit) {
        return (Term)this.subst.map().getOrDefault(field.ref(), (Object)field);
    }

    @Override
    @NotNull
    public Term visitRef(@NotNull RefTerm ref, Unit unused) {
        return (Term)this.subst.map().getOrElse((Object)ref.var(), () -> TermFixpoint.super.visitRef(ref, Unit.unit()));
    }

    @Override
    @NotNull
    public Term visitLam(@NotNull IntroTerm.Lambda lambda, Unit unit) {
        Term.Param param = this.handleBinder(lambda.param());
        return new IntroTerm.Lambda(param, lambda.body().accept(this, unit));
    }

    @Override
    @NotNull
    public Term visitPi(@NotNull FormTerm.Pi pi, Unit unit) {
        Term.Param param = this.handleBinder(pi.param());
        return new FormTerm.Pi(param, pi.body().accept(this, unit));
    }

    @NotNull
    private Term.Param handleBinder(@NotNull Term.Param param) {
        LocalVar v = param.renameVar();
        Term type = param.type().accept(this, Unit.unit());
        this.subst.addDirectly((Var)param.ref(), new RefTerm(v, type));
        return new Term.Param(v, type, param.pattern(), param.explicit());
    }

    @Override
    @NotNull
    public Term visitSigma(@NotNull FormTerm.Sigma term, Unit unit) {
        return new FormTerm.Sigma((ImmutableSeq<Term.Param>)term.params().map(this::handleBinder));
    }
}

