/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.util.function.BiFunction;
import kala.collection.View;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import org.aya.api.distill.AyaDocile;
import org.aya.api.ref.DefVar;
import org.aya.api.util.Arg;
import org.aya.concrete.stmt.Decl;
import org.aya.core.def.FieldDef;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.generic.ParamLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TermFixpoint<P>
extends Term.Visitor<P, Term> {
    @Override
    @NotNull
    default public Term visitHole(@NotNull CallTerm.Hole term, P p) {
        ImmutableSeq contextArgs = term.contextArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq args = term.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (term.contextArgs().sameElements((Iterable)contextArgs, true) && term.args().sameElements((Iterable)args, true)) {
            return term;
        }
        return new CallTerm.Hole(term.ref(), (ImmutableSeq<Arg<Term>>)contextArgs, (ImmutableSeq<Arg<Term>>)args);
    }

    @Override
    @NotNull
    default public Term visitFieldRef(@NotNull RefTerm.Field term, P p) {
        return term;
    }

    @Override
    @NotNull
    default public Term visitDataCall(@NotNull CallTerm.Data dataCall, P p) {
        ImmutableSeq args = dataCall.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq sortArgs = dataCall.sortArgs().mapNotNull(sort -> this.visitSort((Sort)sort, p));
        if (!sortArgs.sizeEquals(dataCall.sortArgs().size())) {
            return new ErrorTerm(dataCall);
        }
        if (dataCall.sortArgs().sameElements((Iterable)sortArgs, true) && dataCall.args().sameElements((Iterable)args, true)) {
            return dataCall;
        }
        return new CallTerm.Data(dataCall.ref(), (ImmutableSeq<Sort>)sortArgs, (ImmutableSeq<Arg<Term>>)args);
    }

    @Override
    @NotNull
    default public ErrorTerm visitError(@NotNull ErrorTerm term, P p) {
        return term;
    }

    @Override
    @NotNull
    default public Term visitConCall(@NotNull CallTerm.Con conCall, P p) {
        ImmutableSeq dataArgs = conCall.head().dataArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq conArgs = conCall.conArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq sortArgs = conCall.sortArgs().mapNotNull(sort -> this.visitSort((Sort)sort, p));
        if (!sortArgs.sizeEquals(conCall.sortArgs().size())) {
            return new ErrorTerm(conCall);
        }
        if (conCall.head().dataArgs().sameElements((Iterable)dataArgs, true) && conCall.sortArgs().sameElements((Iterable)sortArgs, true) && conCall.conArgs().sameElements((Iterable)conArgs, true)) {
            return conCall;
        }
        CallTerm.ConHead head = new CallTerm.ConHead(conCall.head().dataRef(), conCall.head().ref(), (ImmutableSeq<Sort>)sortArgs, (ImmutableSeq<Arg<Term>>)dataArgs);
        return new CallTerm.Con(head, (ImmutableSeq<Arg<Term>>)conArgs);
    }

    @Override
    @NotNull
    default public Term visitStructCall(@NotNull CallTerm.Struct structCall, P p) {
        ImmutableSeq args = structCall.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq sortArgs = structCall.sortArgs().mapNotNull(sort -> this.visitSort((Sort)sort, p));
        if (!sortArgs.sizeEquals(structCall.sortArgs().size())) {
            return new ErrorTerm(structCall);
        }
        if (structCall.sortArgs().sameElements((Iterable)sortArgs, true) && structCall.args().sameElements((Iterable)args, true)) {
            return structCall;
        }
        return new CallTerm.Struct(structCall.ref(), (ImmutableSeq<Sort>)sortArgs, (ImmutableSeq<Arg<Term>>)args);
    }

    private <T> T visitParameterized(@NotNull Term.Param theParam, @NotNull Term theBody, @NotNull P p, @NotNull T original, @NotNull @NotNull BiFunction<@NotNull Term.Param, @NotNull Term, T> callback) {
        Term.Param param = new Term.Param(theParam, (Term)theParam.type().accept(this, p));
        Term body = (Term)theBody.accept(this, p);
        if (param.type() == theParam.type() && body == theBody) {
            return original;
        }
        return callback.apply(param, body);
    }

    @Override
    @NotNull
    default public Term visitLam(@NotNull IntroTerm.Lambda term, P p) {
        return this.visitParameterized(term.param(), term.body(), p, term, IntroTerm.Lambda::new);
    }

    @Override
    @NotNull
    default public Term visitUniv(@NotNull FormTerm.Univ term, P p) {
        Sort sort = this.visitSort(term.sort(), p);
        if (sort == null) {
            return new ErrorTerm(term);
        }
        if (sort == term.sort()) {
            return term;
        }
        return new FormTerm.Univ(sort);
    }

    @Override
    @NotNull
    default public Term visitPi(@NotNull FormTerm.Pi term, P p) {
        return this.visitParameterized(term.param(), term.body(), p, term, FormTerm.Pi::new);
    }

    @Override
    @NotNull
    default public Term visitSigma(@NotNull FormTerm.Sigma term, P p) {
        ImmutableSeq params = term.params().map(param -> new Term.Param((ParamLike<?>)param, (Term)param.type().accept(this, p)));
        if (params.sameElements(term.params(), true)) {
            return term;
        }
        return new FormTerm.Sigma((ImmutableSeq<Term.Param>)params);
    }

    @Override
    @NotNull
    default public Term visitRef(@NotNull RefTerm term, P p) {
        Term ty = (Term)term.type().accept(this, p);
        if (ty == term.type()) {
            return term;
        }
        return new RefTerm(term.var(), ty);
    }

    @NotNull
    default public Arg<Term> visitArg(@NotNull Arg<Term> arg, P p) {
        Term term = (Term)((Term)arg.term()).accept(this, p);
        if (term == arg.term()) {
            return arg;
        }
        return new Arg((AyaDocile)term, arg.explicit());
    }

    @Nullable
    default public Sort visitSort(@NotNull Sort sort, P p) {
        return sort;
    }

    @Override
    @NotNull
    default public Term visitApp(@NotNull ElimTerm.App term, P p) {
        Term function = (Term)term.of().accept(this, p);
        Arg<Term> arg = this.visitArg(term.arg(), p);
        if (function == term.of() && arg == term.arg()) {
            return term;
        }
        return CallTerm.make(function, arg);
    }

    @Override
    @NotNull
    default public Term visitFnCall(@NotNull CallTerm.Fn fnCall, P p) {
        ImmutableSeq args = fnCall.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq sortArgs = fnCall.sortArgs().mapNotNull(sort -> this.visitSort((Sort)sort, p));
        if (!sortArgs.sizeEquals(fnCall.sortArgs().size())) {
            return new ErrorTerm(fnCall);
        }
        if (fnCall.sortArgs().sameElements((Iterable)sortArgs, true) && fnCall.args().sameElements((Iterable)args, true)) {
            return fnCall;
        }
        return new CallTerm.Fn(fnCall.ref(), (ImmutableSeq<Sort>)sortArgs, (ImmutableSeq<Arg<Term>>)args);
    }

    @Override
    @NotNull
    default public Term visitPrimCall(@NotNull CallTerm.Prim prim, P p) {
        ImmutableSeq args = prim.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq sortArgs = prim.sortArgs().mapNotNull(sort -> this.visitSort((Sort)sort, p));
        if (!sortArgs.sizeEquals(prim.sortArgs().size())) {
            return new ErrorTerm(prim);
        }
        if (prim.args().sameElements((Iterable)args, true) && prim.sortArgs().sameElements((Iterable)sortArgs, true)) {
            return prim;
        }
        return new CallTerm.Prim(prim.ref(), (ImmutableSeq<Sort>)sortArgs, (ImmutableSeq<Arg<Term>>)args);
    }

    @Override
    @NotNull
    default public Term visitTup(@NotNull IntroTerm.Tuple term, P p) {
        ImmutableSeq items = term.items().map(x -> (Term)x.accept(this, p));
        if (term.items().sameElements((Iterable)items, true)) {
            return term;
        }
        return new IntroTerm.Tuple((ImmutableSeq<Term>)items);
    }

    @Override
    @NotNull
    default public Term visitNew(@NotNull IntroTerm.New struct, P p) {
        View itemsView = struct.params().view().map((k, v) -> Tuple.of((Object)k, (Object)((Term)v.accept(this, p))));
        ImmutableMap items = ImmutableMap.from((Iterable)itemsView);
        return new IntroTerm.New(struct.struct(), (ImmutableMap<DefVar<FieldDef, Decl.StructField>, Term>)items);
    }

    @Override
    @NotNull
    default public Term visitProj(@NotNull ElimTerm.Proj term, P p) {
        Term tuple = (Term)term.of().accept(this, p);
        if (tuple == term.of()) {
            return term;
        }
        return new ElimTerm.Proj(tuple, term.ix());
    }

    @Override
    @NotNull
    default public Term visitAccess(@NotNull CallTerm.Access term, P p) {
        Term tuple = (Term)term.of().accept(this, p);
        ImmutableSeq args = term.fieldArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq structArgs = term.structArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (term.fieldArgs().sameElements((Iterable)args, true) && term.structArgs().sameElements((Iterable)structArgs, true) && tuple == term.of()) {
            return term;
        }
        return new CallTerm.Access(tuple, term.ref(), term.sortArgs(), (ImmutableSeq<Arg<Term>>)structArgs, (ImmutableSeq<Arg<Term>>)args);
    }
}

