/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiFunction;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Sample;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDistiller {
    @NotNull
    public static final Style KEYWORD = Style.preset((String)"aya:Keyword");
    @NotNull
    public static final Style FN_CALL = Style.preset((String)"aya:FnCall");
    @NotNull
    public static final Style DATA_CALL = Style.preset((String)"aya:DataCall");
    @NotNull
    public static final Style STRUCT_CALL = Style.preset((String)"aya:StructCall");
    @NotNull
    public static final Style CON_CALL = Style.preset((String)"aya:ConCall");
    @NotNull
    public static final Style FIELD_CALL = Style.preset((String)"aya:FieldCall");
    @NotNull
    public static final Style GENERALIZED = Style.preset((String)"aya:Generalized");
    @NotNull
    public final DistillerOptions options;

    protected BaseDistiller(@NotNull DistillerOptions options) {
        this.options = options;
    }

    @NotNull
    <T extends AyaDocile> Doc visitCalls(boolean infix, @NotNull Doc fn, @NotNull Fmt<T> fmt, Outer outer, @NotNull @NotNull SeqView<@NotNull Arg<@NotNull T>> args) {
        ImmutableSeq visibleArgs = ((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs) != false ? args : args.filter(Arg::explicit)).toImmutableSeq();
        if (visibleArgs.isEmpty()) {
            return infix ? Doc.parened((Doc)fn) : fn;
        }
        if (infix) {
            Arg firstArg = (Arg)visibleArgs.first();
            if (!firstArg.explicit()) {
                return this.prefix(Doc.parened((Doc)fn), fmt, outer, visibleArgs.view());
            }
            Doc first = (Doc)fmt.apply(Outer.BinOp, firstArg.term());
            if (visibleArgs.sizeEquals(1)) {
                return BaseDistiller.checkParen(outer, Doc.sep((Doc[])new Doc[]{first, fn}), Outer.BinOp);
            }
            Doc triple = Doc.sep((Doc[])new Doc[]{first, fn, this.visitArg(fmt, (Arg)visibleArgs.get(1), Outer.BinOp)});
            if (visibleArgs.sizeEquals(2)) {
                return BaseDistiller.checkParen(outer, triple, Outer.BinOp);
            }
            return this.prefix(Doc.parened((Doc)triple), fmt, outer, visibleArgs.view().drop(2));
        }
        return this.prefix(fn, fmt, outer, visibleArgs.view());
    }

    @NotNull
    private <T extends AyaDocile> Doc prefix(@NotNull Doc fn, @NotNull Fmt<T> fmt, Outer outer, SeqView<Arg<T>> args) {
        Doc call = Doc.sep((Doc[])new Doc[]{fn, Doc.sep((SeqLike)args.map(arg -> this.visitArg(fmt, (Arg)arg, Outer.AppSpine)))});
        return BaseDistiller.checkParen(outer, call, Outer.AppSpine);
    }

    private <T extends AyaDocile> Doc visitArg(@NotNull Fmt<T> fmt, @NotNull Arg<T> arg, @NotNull Outer outer) {
        if (arg.explicit()) {
            return (Doc)fmt.apply(outer, arg.term());
        }
        return Doc.braced((Doc)((Doc)fmt.apply(Outer.Free, arg.term())));
    }

    @NotNull
    public static Doc checkParen(@NotNull Outer outer, @NotNull Doc binApp, @NotNull Outer binOp) {
        return outer.ordinal() >= binOp.ordinal() ? Doc.parened((Doc)binApp) : binApp;
    }

    @NotNull
    Doc ctorDoc(@NotNull Outer outer, boolean ex, Doc ctorDoc, LocalVar ctorAs, boolean noParams) {
        Doc withAs;
        boolean as = ctorAs != null;
        Doc withEx = ex ? ctorDoc : Doc.braced((Doc)ctorDoc);
        Doc doc = withAs = !as ? withEx : Doc.sep((Doc[])new Doc[]{Doc.parened((Doc)withEx), Doc.plain((String)"as"), BaseDistiller.linkDef((Var)ctorAs)});
        return !ex && !as ? withAs : (outer != Outer.Free && !noParams ? Doc.parened((Doc)withAs) : withAs);
    }

    Doc visitTele(@NotNull SeqLike<? extends ParamLike<?>> telescope) {
        if (telescope.isEmpty()) {
            return Doc.empty();
        }
        ParamLike last = (ParamLike)telescope.first();
        DynamicSeq buf = DynamicSeq.create();
        DynamicSeq names = DynamicSeq.of((Object)last.nameDoc());
        for (ParamLike param : telescope.view().drop(1)) {
            if (!Objects.equals(param.type(), last.type())) {
                buf.append((Object)last.toDoc(Doc.sep((SeqLike)names), this.options));
                names.clear();
                last = param;
            }
            names.append((Object)param.nameDoc());
        }
        buf.append((Object)last.toDoc(Doc.sep((SeqLike)names), this.options));
        return Doc.sep((SeqLike)buf);
    }

    @NotNull
    Doc lambdaParam(@NotNull ParamLike<?> param) {
        return (Boolean)this.options.map.get(DistillerOptions.Key.ShowLambdaTypes) != false ? param.toDoc(this.options) : (param.explicit() ? param.nameDoc() : Doc.braced((Doc)param.nameDoc()));
    }

    @NotNull
    public static Doc varDoc(@NotNull Var ref) {
        return Doc.linkRef((Doc)Doc.plain((String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    static Doc coe(boolean coerce) {
        return coerce ? Doc.styled((Style)KEYWORD, (String)"coerce") : Doc.empty();
    }

    @NotNull
    static Doc primDoc(Var ref) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"prim"), BaseDistiller.linkDef(ref, FN_CALL)});
    }

    @NotNull
    public static Doc linkDef(@NotNull Var ref, @NotNull Style color) {
        return Doc.linkDef((Doc)Doc.styled((Style)color, (String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    static Doc linkRef(@NotNull Var ref, @NotNull Style color) {
        return Doc.linkRef((Doc)Doc.styled((Style)color, (String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    public static Doc linkDef(@NotNull Var ref) {
        return Doc.linkDef((Doc)Doc.plain((String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    static Doc visitDefVar(DefVar<?, ?> ref) {
        Style style = BaseDistiller.chooseStyle(ref.concrete);
        return style != null ? BaseDistiller.linkDef(ref, style) : BaseDistiller.varDoc(ref);
    }

    @Nullable
    protected static Style chooseStyle(Object concrete) {
        Object object = concrete;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.FnDecl.class, Decl.DataDecl.class, Decl.DataCtor.class, Decl.StructDecl.class, Decl.StructField.class, Decl.PrimDecl.class, Sample.class}, (Object)object, n)) {
            case 0 -> {
                Decl.FnDecl d = (Decl.FnDecl)object;
                yield FN_CALL;
            }
            case 1 -> {
                Decl.DataDecl d = (Decl.DataDecl)object;
                yield DATA_CALL;
            }
            case 2 -> {
                Decl.DataCtor d = (Decl.DataCtor)object;
                yield CON_CALL;
            }
            case 3 -> {
                Decl.StructDecl d = (Decl.StructDecl)object;
                yield STRUCT_CALL;
            }
            case 4 -> {
                Decl.StructField d = (Decl.StructField)object;
                yield FIELD_CALL;
            }
            case 5 -> {
                Decl.PrimDecl d = (Decl.PrimDecl)object;
                yield FN_CALL;
            }
            case 6 -> {
                Sample sample = (Sample)object;
                yield BaseDistiller.chooseStyle(sample.delegate());
            }
            default -> null;
        };
    }

    @FunctionalInterface
    protected static interface Fmt<T extends AyaDocile>
    extends BiFunction<Outer, T, Doc> {
    }

    public static enum Outer {
        Free,
        Codomain,
        BinOp,
        AppHead,
        AppSpine,
        ProjHead;

    }
}

