/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.tuple.Unit;
import org.aya.api.concrete.ConcretePat;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.api.util.WithPos;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.BinOpParser;
import org.aya.concrete.remark.Literate;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.OpDecl;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.visitor.ExprConsumer;
import org.aya.distill.BaseDistiller;
import org.aya.generic.Modifier;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.util.StringEscapeUtil;
import org.jetbrains.annotations.NotNull;

public class ConcreteDistiller
extends BaseDistiller
implements Stmt.Visitor<Unit, Doc>,
Pattern.Visitor<BaseDistiller.Outer, Doc>,
Expr.Visitor<BaseDistiller.Outer, Doc> {
    public ConcreteDistiller(@NotNull DistillerOptions options) {
        super(options);
    }

    @Override
    public Doc visitRef(@NotNull Expr.RefExpr expr, BaseDistiller.Outer outer) {
        Var ref = expr.resolvedVar();
        if (ref instanceof DefVar) {
            DefVar defVar = (DefVar)ref;
            return ConcreteDistiller.visitDefVar(defVar);
        }
        if (ref instanceof PreLevelVar) {
            PreLevelVar levelVar = (PreLevelVar)ref;
            return ConcreteDistiller.linkRef((Var)levelVar, GENERALIZED);
        }
        return ConcreteDistiller.varDoc(ref);
    }

    @Override
    public Doc visitUnresolved(@NotNull Expr.UnresolvedExpr expr, BaseDistiller.Outer outer) {
        return Doc.plain((String)expr.name().join());
    }

    @Override
    public Doc visitLam(@NotNull Expr.LamExpr expr, BaseDistiller.Outer outer) {
        if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)).booleanValue() && !expr.param().explicit()) {
            return expr.body().accept(this, outer);
        }
        DynamicSeq prelude = DynamicSeq.of((Object)Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"\\")), (Object)this.lambdaParam(expr.param()));
        if (!(expr.body() instanceof Expr.HoleExpr)) {
            prelude.append((Object)Doc.symbol((String)"=>"));
            prelude.append((Object)expr.body().accept(this, BaseDistiller.Outer.Free));
        }
        return Doc.sep((SeqLike)prelude);
    }

    @Override
    public Doc visitPi(final @NotNull Expr.PiExpr expr, BaseDistiller.Outer outer) {
        Doc doc;
        final boolean[] data = new boolean[]{false, false};
        expr.last().accept(new ExprConsumer<Unit>(){

            @Override
            public Unit visitRef(@NotNull Expr.RefExpr ref, Unit unit) {
                if (ref.resolvedVar() == expr.param().ref()) {
                    data[0] = true;
                }
                return unit;
            }

            @Override
            public Unit visitUnresolved(@NotNull Expr.UnresolvedExpr expr2, Unit unit) {
                data[1] = true;
                return unit;
            }
        }, Unit.unit());
        if (!data[0] && !data[1]) {
            Expr type = expr.param().type();
            Doc tyDoc = type != null ? type.toDoc(this.options) : Doc.symbol((String)"?");
            doc = Doc.sep((Doc[])new Doc[]{expr.param().explicit() ? tyDoc : Doc.braced((Doc)tyDoc), Doc.symbol((String)"->"), expr.last().accept(this, BaseDistiller.Outer.Codomain)});
        } else {
            doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Pi")), expr.param().toDoc(this.options), Doc.symbol((String)"->"), expr.last().accept(this, BaseDistiller.Outer.Codomain)});
        }
        return ConcreteDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
    }

    @Override
    public Doc visitSigma(@NotNull Expr.SigmaExpr expr, BaseDistiller.Outer outer) {
        Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Sig")), this.visitTele((SeqLike<? extends ParamLike<?>>)expr.params().dropLast(1)), Doc.symbol((String)"**"), Objects.requireNonNull(((Expr.Param)expr.params().last()).type()).accept(this, BaseDistiller.Outer.Codomain)});
        return ConcreteDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
    }

    @Override
    public Doc visitRawUniv(@NotNull Expr.RawUnivExpr expr, BaseDistiller.Outer outer) {
        return Doc.styled((Style)KEYWORD, (String)"Type");
    }

    @Override
    public Doc visitRawUnivArgs(@NotNull Expr.RawUnivArgsExpr expr, BaseDistiller.Outer outer) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"universe"), Doc.commaList((SeqLike)expr.univArgs().view().map(e -> e.accept(this, BaseDistiller.Outer.Free)))});
    }

    @Override
    public Doc visitUnivArgs(@NotNull Expr.UnivArgsExpr expr, BaseDistiller.Outer outer) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"universe"), Doc.commaList((SeqLike)expr.univArgs().view().map(e -> e.toDoc(this.options)))});
    }

    @Override
    public Doc visitUniv(@NotNull Expr.UnivExpr expr, BaseDistiller.Outer outer) {
        Doc fn = Doc.styled((Style)KEYWORD, (String)"Type");
        if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowLevels)).booleanValue()) {
            return fn;
        }
        return this.visitCalls(false, fn, (nc, l) -> l.toDoc(this.options), outer, SeqView.of(expr.level()).map(t -> new Arg((AyaDocile)t, true)));
    }

    @Override
    public Doc visitApp(@NotNull Expr.AppExpr expr, BaseDistiller.Outer outer) {
        return this.visitCalls(false, expr.function().accept(this, BaseDistiller.Outer.AppHead), (nest, arg) -> arg.expr().accept(this, nest), outer, SeqView.of(expr.argument()));
    }

    @Override
    public Doc visitLsuc(@NotNull Expr.LSucExpr expr, BaseDistiller.Outer outer) {
        return this.visitCalls(false, Doc.styled((Style)KEYWORD, (String)"lsuc"), (nest, arg) -> arg.accept(this, nest), outer, SeqView.of((Object)new Arg((AyaDocile)expr.expr(), true)));
    }

    @Override
    public Doc visitLmax(@NotNull Expr.LMaxExpr expr, BaseDistiller.Outer outer) {
        return this.visitCalls(false, Doc.styled((Style)KEYWORD, (String)"lmax"), (nest, arg) -> arg.accept(this, nest), outer, expr.levels().view().map(term -> new Arg((AyaDocile)term, true)));
    }

    @Override
    public Doc visitHole(@NotNull Expr.HoleExpr expr, BaseDistiller.Outer outer) {
        if (!expr.explicit()) {
            return Doc.symbol((String)"_");
        }
        Expr filling = expr.filling();
        if (filling == null) {
            return Doc.symbol((String)"{??}");
        }
        return Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"{?"), filling.accept(this, BaseDistiller.Outer.Free), Doc.symbol((String)"?}")});
    }

    @Override
    public Doc visitTup(@NotNull Expr.TupExpr expr, BaseDistiller.Outer outer) {
        return Doc.parened((Doc)Doc.commaList((SeqLike)expr.items().view().map(e -> e.accept(this, BaseDistiller.Outer.Free))));
    }

    @Override
    public Doc visitProj(@NotNull Expr.ProjExpr expr, BaseDistiller.Outer outer) {
        return Doc.cat((Doc[])new Doc[]{expr.tup().accept(this, BaseDistiller.Outer.ProjHead), Doc.plain((String)"."), Doc.plain((String)((String)expr.ix().fold(Objects::toString, WithPos::data)))});
    }

    @Override
    public Doc visitNew(@NotNull Expr.NewExpr expr, BaseDistiller.Outer outer) {
        return Doc.cblock((Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"new"), expr.struct().accept(this, BaseDistiller.Outer.Free)}), (int)2, (Doc)Doc.vcat((SeqLike)expr.fields().view().map(t -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), Doc.plain((String)t.name()), Doc.emptyIf((boolean)t.bindings().isEmpty(), () -> Doc.sep((SeqLike)t.bindings().map(v -> ConcreteDistiller.varDoc((Var)v.data())))), Doc.plain((String)"=>"), t.body().accept(this, BaseDistiller.Outer.Free)}))));
    }

    @Override
    public Doc visitLitInt(@NotNull Expr.LitIntExpr expr, BaseDistiller.Outer outer) {
        return Doc.plain((String)String.valueOf(expr.integer()));
    }

    @Override
    public Doc visitLitString(@NotNull Expr.LitStringExpr expr, BaseDistiller.Outer outer) {
        return Doc.plain((String)("\"" + StringEscapeUtil.escapeStringCharacters((String)expr.string()) + "\""));
    }

    @Override
    public Doc visitError(@NotNull Expr.ErrorExpr error, BaseDistiller.Outer outer) {
        return Doc.angled((Doc)error.description().toDoc(this.options));
    }

    @Override
    public Doc visitBinOpSeq(@NotNull Expr.BinOpSeq binOpSeq, BaseDistiller.Outer outer) {
        ImmutableSeq<BinOpParser.Elem> seq = binOpSeq.seq();
        if (seq.sizeEquals(1)) {
            return ((BinOpParser.Elem)seq.first()).expr().accept(this, outer);
        }
        return this.visitCalls(false, ((BinOpParser.Elem)seq.first()).expr().accept(this, BaseDistiller.Outer.AppSpine), (nest, arg) -> arg.accept(this, nest), outer, seq.view().drop(1).map(e -> new Arg((AyaDocile)e.expr(), e.explicit())));
    }

    @Override
    public Doc visitTuple(@NotNull Pattern.Tuple tuple, BaseDistiller.Outer outer) {
        Doc tup = Doc.licit((boolean)tuple.explicit(), (Doc)Doc.commaList((SeqLike)tuple.patterns().view().map(p -> p.accept(this, BaseDistiller.Outer.Free))));
        return tuple.as() == null ? tup : Doc.sep((Doc[])new Doc[]{tup, Doc.styled((Style)KEYWORD, (String)"as"), ConcreteDistiller.linkDef((Var)tuple.as())});
    }

    @Override
    public Doc visitNumber(@NotNull Pattern.Number number, BaseDistiller.Outer outer) {
        Doc doc = Doc.plain((String)String.valueOf(number.number()));
        return number.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitBind(@NotNull Pattern.Bind bind, BaseDistiller.Outer outer) {
        Doc doc = ConcreteDistiller.linkDef((Var)bind.bind());
        return bind.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitAbsurd(@NotNull Pattern.Absurd absurd, BaseDistiller.Outer outer) {
        Doc doc = Doc.styled((Style)KEYWORD, (String)"impossible");
        return absurd.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitCalmFace(@NotNull Pattern.CalmFace calmFace, BaseDistiller.Outer outer) {
        Doc doc = Doc.plain((String)"_");
        return calmFace.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitCtor(@NotNull Pattern.Ctor ctor, BaseDistiller.Outer outer) {
        Doc name = Doc.styled((Style)CON_CALL, (String)((String)ctor.name().data()));
        Doc ctorDoc = ctor.params().isEmpty() ? name : Doc.sep((Doc[])new Doc[]{name, this.visitMaybeCtorPatterns((SeqLike<Pattern>)ctor.params(), BaseDistiller.Outer.AppSpine, Doc.ALT_WS)});
        return this.ctorDoc(outer, ctor.explicit(), ctorDoc, ctor.as(), ctor.params().isEmpty());
    }

    private Doc visitMaybeCtorPatterns(SeqLike<Pattern> patterns, BaseDistiller.Outer outer, @NotNull Doc delim) {
        patterns = (Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats) != false ? patterns : patterns.view().filter(ConcretePat::explicit);
        return Doc.join((Doc)delim, (SeqLike)patterns.view().map(p -> p.accept(this, outer)));
    }

    public Doc matchy(@NotNull Pattern.Clause match) {
        Doc doc = this.visitMaybeCtorPatterns((SeqLike<Pattern>)match.patterns, BaseDistiller.Outer.Free, Doc.plain((String)", "));
        return (Doc)match.expr.map(e -> Doc.sep((Doc[])new Doc[]{doc, Doc.plain((String)"=>"), e.accept(this, BaseDistiller.Outer.Free)})).getOrDefault((Object)doc);
    }

    private Doc visitAccess(@NotNull Stmt.Accessibility accessibility, Stmt.Accessibility def) {
        if (accessibility == def) {
            return Doc.empty();
        }
        return Doc.styled((Style)KEYWORD, (String)accessibility.keyword);
    }

    @Override
    public Doc visitImport(@NotNull Command.Import cmd, Unit unit) {
        DynamicSeq prelude = DynamicSeq.of((Object)Doc.styled((Style)KEYWORD, (String)"import"), (Object)Doc.symbol((String)cmd.path().join()));
        if (cmd.asName() != null) {
            prelude.append((Object)Doc.styled((Style)KEYWORD, (String)"as"));
            prelude.append((Object)Doc.plain((String)cmd.asName()));
        }
        return Doc.sep((SeqLike)prelude);
    }

    @Override
    public Doc visitOpen(@NotNull Command.Open cmd, Unit unit) {
        Doc[] docArray = new Doc[5];
        docArray[0] = this.visitAccess(cmd.accessibility(), Stmt.Accessibility.Private);
        docArray[1] = Doc.styled((Style)KEYWORD, (String)"open");
        docArray[2] = Doc.plain((String)cmd.path().join());
        docArray[3] = Doc.styled((Style)KEYWORD, (String)(switch (cmd.useHide().strategy()) {
            default -> throw new IncompatibleClassChangeError();
            case Command.Open.UseHide.Strategy.Using -> "using";
            case Command.Open.UseHide.Strategy.Hiding -> "hiding";
        }));
        docArray[4] = Doc.parened((Doc)Doc.commaList((SeqLike)cmd.useHide().list().view().map(Doc::plain)));
        return Doc.sepNonEmpty((Doc[])docArray);
    }

    @Override
    public Doc visitModule(@NotNull Command.Module mod, Unit unit) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{this.visitAccess(mod.accessibility(), Stmt.Accessibility.Public), Doc.styled((Style)KEYWORD, (String)"module"), Doc.plain((String)mod.name()), Doc.plain((String)"{")}), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)mod.contents().view().map(stmt -> stmt.accept(this, Unit.unit())))), Doc.plain((String)"}")});
    }

    @Override
    public Doc visitRemark(@NotNull Remark remark, Unit unit) {
        Literate literate = remark.literate;
        return literate != null ? literate.toDoc() : Doc.plain((String)remark.raw);
    }

    @Override
    public Doc visitData(@NotNull Decl.DataDecl decl, Unit unit) {
        DynamicSeq prelude = DynamicSeq.of((Object)this.visitAccess(decl.accessibility(), Stmt.Accessibility.Public), (Object)Doc.styled((Style)KEYWORD, (String)"data"), (Object)ConcreteDistiller.linkDef(decl.ref, DATA_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)decl.telescope));
        this.appendResult((DynamicSeq<Doc>)prelude, decl.result);
        return Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), Doc.emptyIf((boolean)decl.body.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)decl.body.view().map(ctor -> this.visitCtor((Decl.DataCtor)ctor, Unit.unit()))))})), this.visitBindBlock(decl.bindBlock)});
    }

    @Override
    public Doc visitCtor(@NotNull Decl.DataCtor ctor, Unit unit) {
        DynamicSeq prelude = DynamicSeq.of((Object)ConcreteDistiller.coe(ctor.coerce), (Object)ConcreteDistiller.linkDef(ctor.ref, CON_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)ctor.telescope), (Object)this.visitClauses(ctor.clauses, true));
        Doc doc = Doc.sepNonEmpty((SeqLike)prelude);
        if (ctor.patterns.isNotEmpty()) {
            Doc pats = Doc.commaList((SeqLike)ctor.patterns.view().map(pattern -> pattern.accept(this, BaseDistiller.Outer.Free)));
            return Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), pats, Doc.plain((String)"=>"), doc});
        }
        return Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc});
    }

    private Doc visitClauses(@NotNull ImmutableSeq<Pattern.Clause> clauses, boolean wrapInBraces) {
        if (clauses.isEmpty()) {
            return Doc.empty();
        }
        Doc clausesDoc = Doc.vcat((SeqLike)clauses.view().map(this::matchy).map(doc -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc})));
        return wrapInBraces ? Doc.braced((Doc)clausesDoc) : clausesDoc;
    }

    @Override
    public Doc visitStruct(@NotNull Decl.StructDecl decl, Unit unit) {
        DynamicSeq prelude = DynamicSeq.of((Object)this.visitAccess(decl.accessibility(), Stmt.Accessibility.Public), (Object)Doc.styled((Style)KEYWORD, (String)"struct"), (Object)ConcreteDistiller.linkDef(decl.ref, STRUCT_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)decl.telescope));
        this.appendResult((DynamicSeq<Doc>)prelude, decl.result);
        return Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), Doc.emptyIf((boolean)decl.fields.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)decl.fields.view().map(field -> this.visitField((Decl.StructField)field, Unit.unit()))))})), this.visitBindBlock(decl.bindBlock)});
    }

    private void appendResult(DynamicSeq<Doc> prelude, Expr result) {
        if (result instanceof Expr.HoleExpr) {
            return;
        }
        prelude.append((Object)Doc.symbol((String)":"));
        prelude.append((Object)result.accept(this, BaseDistiller.Outer.Free));
    }

    @Override
    public Doc visitField(@NotNull Decl.StructField field, Unit unit) {
        DynamicSeq doc = DynamicSeq.of((Object)Doc.symbol((String)"|"), (Object)ConcreteDistiller.coe(field.coerce), (Object)ConcreteDistiller.linkDef(field.ref, FIELD_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)field.telescope));
        this.appendResult((DynamicSeq<Doc>)doc, field.result);
        if (field.body.isDefined()) {
            doc.append((Object)Doc.symbol((String)"=>"));
            doc.append((Object)((Expr)field.body.get()).accept(this, BaseDistiller.Outer.Free));
        }
        doc.append((Object)this.visitClauses(field.clauses, true));
        return Doc.sepNonEmpty((SeqLike)doc);
    }

    @Override
    public Doc visitFn(@NotNull Decl.FnDecl decl, Unit unit) {
        DynamicSeq prelude = DynamicSeq.of((Object)this.visitAccess(decl.accessibility(), Stmt.Accessibility.Public), (Object)Doc.styled((Style)KEYWORD, (String)"def"));
        prelude.appendAll((Iterable)Seq.from(decl.modifiers).view().map(this::visitModifier));
        prelude.append((Object)ConcreteDistiller.linkDef(decl.ref, FN_CALL));
        prelude.append((Object)this.visitTele((SeqLike<? extends ParamLike<?>>)decl.telescope));
        this.appendResult((DynamicSeq<Doc>)prelude, decl.result);
        return Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), (Doc)decl.body.fold(expr -> Doc.cat((Doc[])new Doc[]{Doc.ONE_WS, Doc.symbol((String)"=>"), Doc.ONE_WS, expr.accept(this, BaseDistiller.Outer.Free)}), clauses -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)this.visitClauses((ImmutableSeq<Pattern.Clause>)clauses, false))})), this.visitBindBlock(decl.bindBlock)});
    }

    public Doc visitBindBlock(@NotNull OpDecl.BindBlock bindBlock) {
        if (bindBlock == OpDecl.BindBlock.EMPTY) {
            return Doc.empty();
        }
        ImmutableSeq loosers = (ImmutableSeq)bindBlock.resolvedLoosers().value;
        ImmutableSeq tighters = (ImmutableSeq)bindBlock.resolvedTighters().value;
        if (loosers.isEmpty() && tighters.isEmpty()) {
            return Doc.empty();
        }
        if (loosers.isEmpty()) {
            return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"bind"), Doc.styled((Style)KEYWORD, (String)"tighter"), Doc.commaList((SeqLike)tighters.view().map(BaseDistiller::visitDefVar))}))});
        }
        if (tighters.isEmpty()) {
            return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"bind"), Doc.styled((Style)KEYWORD, (String)"looser"), Doc.commaList((SeqLike)loosers.view().map(BaseDistiller::visitDefVar))}))});
        }
        return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.cat((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"bind"), Doc.braced((Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"tighter"), Doc.commaList((SeqLike)tighters.view().map(BaseDistiller::visitDefVar)), Doc.styled((Style)KEYWORD, (String)"looser"), Doc.commaList((SeqLike)loosers.view().map(BaseDistiller::visitDefVar))}))}))});
    }

    @Override
    public Doc visitPrim(@NotNull Decl.PrimDecl decl, Unit unit) {
        return ConcreteDistiller.primDoc(decl.ref);
    }

    private Doc visitModifier(@NotNull Modifier modifier) {
        return Doc.styled((Style)KEYWORD, (String)(switch (modifier) {
            default -> throw new IncompatibleClassChangeError();
            case Modifier.Inline -> "inline";
            case Modifier.Erase -> "erase";
        }));
    }

    @Override
    public Doc visitLevels(@NotNull Generalize.Levels levels, Unit unit) {
        ImmutableSeq vars = levels.levels().map(t -> ConcreteDistiller.linkDef((Var)t.data(), GENERALIZED));
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"universe"), Doc.sep((SeqLike)vars)});
    }

    @Override
    public Doc visitExample(@NotNull Sample.Working example, Unit unit) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"example"), example.delegate().accept(this, unit)});
    }

    @Override
    public Doc visitCounterexample(@NotNull Sample.Counter example, Unit unit) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"counterexample"), example.delegate().accept(this, unit)});
    }
}

