/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.tuple.Unit;
import org.aya.api.concrete.ConcreteDecl;
import org.aya.api.core.CorePat;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.concrete.stmt.OpDecl;
import org.aya.core.Matching;
import org.aya.core.Meta;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.VarConsumer;
import org.aya.distill.BaseDistiller;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;

public class CoreDistiller
extends BaseDistiller
implements Pat.Visitor<BaseDistiller.Outer, Doc>,
Def.Visitor<Unit, Doc>,
Term.Visitor<BaseDistiller.Outer, Doc> {
    public CoreDistiller(@NotNull DistillerOptions options) {
        super(options);
    }

    @Override
    public Doc visitRef(@NotNull RefTerm term, BaseDistiller.Outer outer) {
        return CoreDistiller.varDoc((Var)term.var());
    }

    @Override
    public Doc visitLam(@NotNull IntroTerm.Lambda term, BaseDistiller.Outer outer) {
        Doc bodyDoc;
        CallTerm call;
        Var var;
        DynamicSeq params = DynamicSeq.create();
        Term body = IntroTerm.Lambda.unwrap(term, (DynamicSeq<Term.Param>)params);
        if (body instanceof CallTerm && (var = (call = (CallTerm)body).ref()) instanceof DefVar) {
            DefVar defVar = (DefVar)var;
            SeqView args = this.visibleArgsOf(call).view();
            while (params.isNotEmpty() && args.isNotEmpty()) {
                Term.Param param2 = (Term.Param)params.last();
                if (!this.checkUneta((SeqView<Arg<Term>>)args, (Term.Param)params.last())) break;
                args = args.dropLast(1);
                params.removeLast();
            }
            if (call instanceof CallTerm.Access) {
                CallTerm.Access access = (CallTerm.Access)call;
                bodyDoc = this.visitAccessHead(access);
            } else {
                Style style = CoreDistiller.chooseStyle(defVar);
                bodyDoc = style != null ? this.visitCalls(defVar, style, (SeqLike<Arg<Term>>)args, BaseDistiller.Outer.Free) : this.visitCalls(false, CoreDistiller.varDoc((Var)defVar), (SeqView<Arg<Term>>)args, BaseDistiller.Outer.Free);
            }
        } else {
            bodyDoc = body.accept(this, BaseDistiller.Outer.Free);
        }
        if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)).booleanValue()) {
            params.retainAll(Term.Param::explicit);
        }
        if (params.isEmpty()) {
            return bodyDoc;
        }
        DynamicSeq list = DynamicSeq.of((Object)Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"\\")));
        params.forEach(param -> list.append((Object)this.lambdaParam((ParamLike<?>)param)));
        list.append((Object)Doc.symbol((String)"=>"));
        list.append((Object)bodyDoc);
        Doc doc = Doc.sep((SeqLike)list);
        return CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.AppSpine);
    }

    private boolean checkUneta(SeqView<Arg<Term>> args, Term.Param param) {
        Arg arg = (Arg)args.last();
        if (arg.explicit() != param.explicit()) {
            return false;
        }
        AyaDocile ayaDocile = arg.term();
        if (!(ayaDocile instanceof RefTerm)) {
            return false;
        }
        RefTerm argRef = (RefTerm)ayaDocile;
        if (argRef.var() != param.ref()) {
            return false;
        }
        VarConsumer.UsageCounter counter = new VarConsumer.UsageCounter((Var)param.ref());
        args.dropLast(1).forEach(t -> ((Term)t.term()).accept(counter, Unit.unit()));
        return counter.usageCount() == 0;
    }

    private ImmutableSeq<Arg<Term>> visibleArgsOf(CallTerm call) {
        ImmutableSeq<Arg<Term>> immutableSeq;
        if (call instanceof CallTerm.Con) {
            CallTerm.Con con = (CallTerm.Con)call;
            immutableSeq = con.conArgs();
        } else if (call instanceof CallTerm.Access) {
            CallTerm.Access access = (CallTerm.Access)call;
            immutableSeq = access.fieldArgs();
        } else {
            immutableSeq = call.args();
        }
        return immutableSeq;
    }

    @Override
    public Doc visitPi(@NotNull FormTerm.Pi term, BaseDistiller.Outer outer) {
        if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)).booleanValue() && !term.param().explicit()) {
            return term.body().accept(this, outer);
        }
        Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Pi")), term.param().toDoc(this.options), Doc.symbol((String)"->"), term.body().accept(this, BaseDistiller.Outer.Codomain)});
        return CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
    }

    @Override
    public Doc visitSigma(@NotNull FormTerm.Sigma term, BaseDistiller.Outer outer) {
        Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Sig")), this.visitTele((SeqLike<? extends ParamLike<?>>)term.params().view().dropLast(1)), Doc.symbol((String)"**"), ((Term.Param)term.params().last()).toDoc(this.options)});
        return CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
    }

    @Override
    public Doc visitUniv(@NotNull FormTerm.Univ term, BaseDistiller.Outer outer) {
        Doc fn = Doc.styled((Style)KEYWORD, (String)"Type");
        if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowLevels)).booleanValue()) {
            return fn;
        }
        return this.visitCalls(false, fn, (nest, t) -> t.toDoc(this.options), outer, Seq.of((Object)term.sort()).view().map(t -> new Arg((AyaDocile)t, true)));
    }

    @Override
    public Doc visitApp(@NotNull ElimTerm.App term, BaseDistiller.Outer outer) {
        return this.visitCalls(false, term.of().accept(this, BaseDistiller.Outer.AppHead), (SeqView<Arg<Term>>)SeqView.of(term.arg()), outer);
    }

    @Override
    public Doc visitFnCall(@NotNull CallTerm.Fn fnCall, BaseDistiller.Outer outer) {
        return this.visitCalls(fnCall.ref(), FN_CALL, (SeqLike<Arg<Term>>)fnCall.args(), outer);
    }

    @Override
    public Doc visitPrimCall(@NotNull CallTerm.Prim prim, BaseDistiller.Outer outer) {
        return this.visitCalls(prim.ref(), FN_CALL, (SeqLike<Arg<Term>>)prim.args(), outer);
    }

    @Override
    public Doc visitDataCall(@NotNull CallTerm.Data dataCall, BaseDistiller.Outer outer) {
        return this.visitCalls(dataCall.ref(), DATA_CALL, (SeqLike<Arg<Term>>)dataCall.args(), outer);
    }

    @Override
    public Doc visitStructCall(@NotNull CallTerm.Struct structCall, BaseDistiller.Outer outer) {
        return this.visitCalls(structCall.ref(), STRUCT_CALL, (SeqLike<Arg<Term>>)structCall.args(), outer);
    }

    @Override
    public Doc visitConCall(@NotNull CallTerm.Con conCall, BaseDistiller.Outer outer) {
        return this.visitCalls(conCall.ref(), CON_CALL, (SeqLike<Arg<Term>>)conCall.conArgs(), outer);
    }

    @Override
    public Doc visitTup(@NotNull IntroTerm.Tuple term, BaseDistiller.Outer outer) {
        return Doc.parened((Doc)Doc.commaList((SeqLike)term.items().view().map(t -> t.accept(this, BaseDistiller.Outer.Free))));
    }

    @Override
    public Doc visitNew(@NotNull IntroTerm.New newTerm, BaseDistiller.Outer outer) {
        return Doc.cblock((Doc)Doc.styled((Style)KEYWORD, (String)"new"), (int)2, (Doc)Doc.vcat((SeqLike)newTerm.params().view().map((k, v) -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), CoreDistiller.linkRef((Var)k, FIELD_CALL), Doc.symbol((String)"=>"), v.accept(this, BaseDistiller.Outer.Free)})).toImmutableSeq()));
    }

    @Override
    public Doc visitProj(@NotNull ElimTerm.Proj term, BaseDistiller.Outer outer) {
        return Doc.cat((Doc[])new Doc[]{term.of().accept(this, BaseDistiller.Outer.ProjHead), Doc.symbol((String)"."), Doc.plain((String)String.valueOf(term.ix()))});
    }

    @Override
    public Doc visitAccess(@NotNull CallTerm.Access term, BaseDistiller.Outer outer) {
        return this.visitCalls(false, this.visitAccessHead(term), (SeqView<Arg<Term>>)term.fieldArgs().view(), outer);
    }

    @NotNull
    private Doc visitAccessHead(@NotNull CallTerm.Access term) {
        return Doc.cat((Doc[])new Doc[]{term.of().accept(this, BaseDistiller.Outer.ProjHead), Doc.symbol((String)"."), CoreDistiller.linkRef(term.ref(), FIELD_CALL)});
    }

    @Override
    public Doc visitHole(@NotNull CallTerm.Hole term, BaseDistiller.Outer outer) {
        Meta name = term.ref();
        Doc inner = CoreDistiller.varDoc(name);
        if (((Boolean)this.options.map.get(DistillerOptions.Key.InlineMetas)).booleanValue()) {
            return this.visitCalls(false, inner, (SeqView<Arg<Term>>)term.args().view(), outer);
        }
        return Doc.wrap((String)"{?", (String)"?}", (Doc)this.visitCalls(false, inner, (SeqView<Arg<Term>>)term.args().view(), BaseDistiller.Outer.Free));
    }

    @Override
    public Doc visitFieldRef(@NotNull RefTerm.Field term, BaseDistiller.Outer outer) {
        return CoreDistiller.linkRef(term.ref(), FIELD_CALL);
    }

    @Override
    public Doc visitError(@NotNull ErrorTerm term, BaseDistiller.Outer outer) {
        Doc doc = term.description().toDoc(this.options);
        return !term.isReallyError() ? doc : Doc.angled((Doc)doc);
    }

    private Doc visitCalls(@NotNull DefVar<?, ?> var, @NotNull Style style, @NotNull @NotNull SeqLike<@NotNull Arg<@NotNull Term>> args, BaseDistiller.Outer outer) {
        OpDecl decl;
        ConcreteDecl concreteDecl = var.concrete;
        return this.visitCalls(concreteDecl instanceof OpDecl && (decl = (OpDecl)concreteDecl).opInfo() != null, CoreDistiller.linkRef(var, style), (SeqView<Arg<Term>>)args.view(), outer);
    }

    private Doc visitCalls(boolean infix, @NotNull Doc fn, @NotNull @NotNull SeqView<@NotNull Arg<@NotNull Term>> args, BaseDistiller.Outer outer) {
        return this.visitCalls(infix, fn, (nest, term) -> term.accept(this, nest), outer, args);
    }

    @Override
    public Doc visitTuple(@NotNull Pat.Tuple tuple, BaseDistiller.Outer outer) {
        Doc tup = Doc.licit((boolean)tuple.explicit(), (Doc)Doc.commaList((SeqLike)tuple.pats().view().map(pat -> pat.accept(this, BaseDistiller.Outer.Free))));
        return tuple.as() == null ? tup : Doc.sep((Doc[])new Doc[]{tup, Doc.styled((Style)KEYWORD, (String)"as"), CoreDistiller.linkDef((Var)tuple.as())});
    }

    @Override
    public Doc visitBind(@NotNull Pat.Bind bind, BaseDistiller.Outer outer) {
        Doc doc = CoreDistiller.linkDef((Var)bind.as());
        return bind.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitAbsurd(@NotNull Pat.Absurd absurd, BaseDistiller.Outer outer) {
        Doc doc = Doc.styled((Style)KEYWORD, (String)"impossible");
        return absurd.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitPrim(@NotNull Pat.Prim prim, BaseDistiller.Outer outer) {
        Doc link = CoreDistiller.linkRef(prim.ref(), CON_CALL);
        return prim.explicit() ? link : Doc.braced((Doc)link);
    }

    @Override
    public Doc visitCtor(@NotNull Pat.Ctor ctor, BaseDistiller.Outer outer) {
        Doc ctorDoc = Doc.cat((Doc[])new Doc[]{CoreDistiller.linkRef(ctor.ref(), CON_CALL), this.visitMaybeCtorPatterns((SeqLike<Pat>)ctor.params(), BaseDistiller.Outer.AppSpine, Doc.ONE_WS)});
        return this.ctorDoc(outer, ctor.explicit(), ctorDoc, ctor.as(), ctor.params().isEmpty());
    }

    public Doc visitMaybeCtorPatterns(SeqLike<Pat> patterns, BaseDistiller.Outer outer, @NotNull Doc delim) {
        SeqView pats = (Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats) != false ? patterns : patterns.view().filter(CorePat::explicit);
        return Doc.emptyIf((boolean)pats.isEmpty(), () -> this.lambda$visitMaybeCtorPatterns$9(delim, (SeqLike)pats, outer));
    }

    @Override
    public Doc visitFn(@NotNull FnDef def, Unit unit) {
        DynamicSeq line1 = DynamicSeq.of((Object)Doc.styled((Style)KEYWORD, (String)"def"), (Object)CoreDistiller.linkDef(def.ref(), FN_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)def.telescope()), (Object)Doc.symbol((String)":"), (Object)def.result().accept(this, BaseDistiller.Outer.Free));
        return (Doc)def.body.fold(term -> Doc.sep((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.symbol((String)"=>"), term.accept(this, BaseDistiller.Outer.Free)}), clauses -> Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.nest((int)2, (Doc)this.visitClauses((ImmutableSeq<Matching>)clauses))}));
    }

    private Doc visitClauses(@NotNull ImmutableSeq<Matching> clauses) {
        return Doc.vcat((SeqLike)clauses.view().map(matching -> matching.toDoc(this.options)).map(doc -> Doc.cat((Doc[])new Doc[]{Doc.symbol((String)"|"), doc})));
    }

    @Override
    public Doc visitData(@NotNull DataDef def, Unit unit) {
        DynamicSeq line1 = DynamicSeq.of((Object)Doc.styled((Style)KEYWORD, (String)"data"), (Object)CoreDistiller.linkDef(def.ref(), DATA_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)def.telescope()), (Object)Doc.symbol((String)":"), (Object)def.result().accept(this, BaseDistiller.Outer.Free));
        return Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)def.body.view().map(ctor -> ctor.accept(this, Unit.unit()))))});
    }

    @Override
    public Doc visitCtor(@NotNull CtorDef ctor, Unit unit) {
        Doc line1;
        Doc doc = Doc.sepNonEmpty((Doc[])new Doc[]{CoreDistiller.coe(ctor.coerce), CoreDistiller.linkDef(ctor.ref(), CON_CALL), this.visitTele((SeqLike<? extends ParamLike<?>>)ctor.selfTele)});
        if (ctor.pats.isNotEmpty()) {
            Doc pats = Doc.commaList((SeqLike)ctor.pats.view().map(pat -> pat.accept(this, BaseDistiller.Outer.Free)));
            line1 = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), pats, Doc.symbol((String)"=>"), doc});
        } else {
            line1 = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc});
        }
        return Doc.cblock((Doc)line1, (int)2, (Doc)this.visitClauses((ImmutableSeq<Matching>)ctor.clauses));
    }

    @Override
    public Doc visitStruct(@NotNull StructDef def, Unit unit) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"struct"), CoreDistiller.linkDef(def.ref(), STRUCT_CALL), this.visitTele((SeqLike<? extends ParamLike<?>>)def.telescope()), Doc.symbol((String)":"), def.result().accept(this, BaseDistiller.Outer.Free)}), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)def.fields.view().map(field -> field.accept(this, Unit.unit()))))});
    }

    @Override
    public Doc visitField(@NotNull FieldDef field, Unit unit) {
        return Doc.cblock((Doc)Doc.sepNonEmpty((Doc[])new Doc[]{Doc.symbol((String)"|"), CoreDistiller.coe(field.coerce), CoreDistiller.linkDef(field.ref(), FIELD_CALL), this.visitTele((SeqLike<? extends ParamLike<?>>)field.selfTele), Doc.symbol((String)":"), field.result.accept(this, BaseDistiller.Outer.Free)}), (int)2, (Doc)this.visitClauses((ImmutableSeq<Matching>)field.clauses));
    }

    @Override
    @NotNull
    public Doc visitPrim(@NotNull PrimDef def, Unit unit) {
        return CoreDistiller.primDoc(def.ref());
    }

    private /* synthetic */ Doc lambda$visitMaybeCtorPatterns$9(Doc delim, SeqLike pats, BaseDistiller.Outer outer) {
        return Doc.cat((Doc[])new Doc[]{Doc.ONE_WS, Doc.join((Doc)delim, (SeqLike)pats.view().map(p -> p.accept(this, outer)))});
    }
}

