/*
 * Decompiled with CFR 0.152.
 */
package org.aya.generic;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.distill.CoreDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Level<V extends Var>
extends AyaDocile {
    @NotNull
    public Level<V> lift(int var1);

    @NotNull
    public static Doc levelDoc(int lift, String name) {
        if (lift > 0) {
            return Doc.parened((Doc)Doc.plain((String)(name + " + " + lift)));
        }
        return Doc.plain((String)name);
    }

    public record Reference<V extends Var>(@NotNull V ref, int lift) implements Level<V>
    {
        public Reference(@NotNull V ref) {
            this(ref, 0);
        }

        @Override
        @NotNull
        public Level<V> lift(int n) {
            return new Reference<V>(this.ref, this.lift + n);
        }

        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return Level.levelDoc(this.lift, this.ref.name());
        }
    }

    public record Constant<V extends Var>(int value) implements Level<V>
    {
        @Override
        @NotNull
        public Level<V> lift(int n) {
            return new Constant<V>(this.value + n);
        }

        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return Doc.plain((String)String.valueOf(this.value));
        }
    }

    public record Maximum(ImmutableSeq<Level<PreLevelVar>> among) implements Level<PreLevelVar>
    {
        @NotNull
        public Maximum lift(int n) {
            return new Maximum((ImmutableSeq<Level<PreLevelVar>>)this.among.map(l -> l.lift(n)));
        }

        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return Doc.parened((Doc)Doc.sep((SeqLike)this.among.view().map(l -> l.toDoc(options)).prepended((Object)Doc.styled((Style)CoreDistiller.KEYWORD, (String)"max")).toImmutableSeq()));
        }
    }

    public record Polymorphic(int lift) implements Level<PreLevelVar>
    {
        @NotNull
        public Polymorphic lift(int n) {
            return new Polymorphic(this.lift + n);
        }

        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return Level.levelDoc(this.lift, "lp");
        }
    }
}

