/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.Tuple3;
import org.aya.api.distill.AyaDocile;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.api.util.InternalException;
import org.aya.api.util.NormalizeMode;
import org.aya.api.util.WithPos;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Signatured;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.sort.LevelSubst;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Substituter;
import org.aya.core.visitor.Unfolder;
import org.aya.generic.Constants;
import org.aya.generic.Level;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.LocalCtx;
import org.aya.tyck.TyckState;
import org.aya.tyck.error.BadTypeError;
import org.aya.tyck.error.FieldProblem;
import org.aya.tyck.error.Goal;
import org.aya.tyck.error.LicitProblem;
import org.aya.tyck.error.ProjIxError;
import org.aya.tyck.error.UnifyError;
import org.aya.tyck.error.UnivArgsError;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.unify.DefEq;
import org.aya.util.Ordering;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExprTycker {
    @NotNull
    public final Reporter reporter;
    @NotNull
    public LocalCtx localCtx = new LocalCtx();
    @Nullable
    public final Trace.Builder traceBuilder;
    @NotNull
    public final TyckState state = new TyckState();
    @NotNull
    public final Sort.LvlVar universe = new Sort.LvlVar("u", null);
    @NotNull
    public final MutableMap<PreLevelVar, Sort.LvlVar> levelMapping = MutableLinkedHashMap.of();

    private void tracing(@NotNull @NotNull Consumer< @NotNull Trace.Builder> consumer) {
        if (this.traceBuilder != null) {
            consumer.accept(this.traceBuilder);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Result doSynthesize(@NotNull Expr expr) {
        Result result;
        Result result2;
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.LamExpr.class, Expr.UnivExpr.class, Expr.RefExpr.class, Expr.PiExpr.class, Expr.SigmaExpr.class, Expr.NewExpr.class, Expr.ProjExpr.class, Expr.TupExpr.class, Expr.AppExpr.class, Expr.HoleExpr.class}, (Object)expr3, n)) {
            case 0: {
                Result result3;
                Expr.LamExpr lam = (Expr.LamExpr)expr3;
                result2 = result3 = this.inherit(lam, this.generatePi(lam));
                return result2;
            }
            case 1: {
                Result result4;
                Expr.UnivExpr univ = (Expr.UnivExpr)expr3;
                Sort sort = this.transformLevel(univ.level());
                result2 = result4 = new Result(new FormTerm.Univ(sort), new FormTerm.Univ(sort.lift(1)));
                return result2;
            }
            case 2: {
                Result result5;
                Expr.RefExpr ref = (Expr.RefExpr)expr3;
                Var var = ref.resolvedVar();
                Objects.requireNonNull(var);
                Var var2 = var;
                int n2 = 0;
                result2 = result5 = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalVar.class, DefVar.class}, (Object)var2, n2)) {
                    case 0 -> {
                        LocalVar loc = (LocalVar)var2;
                        Term ty = this.localCtx.get(loc);
                        yield new Result(new RefTerm(loc, ty), ty);
                    }
                    case 1 -> {
                        DefVar defVar = (DefVar)var2;
                        yield this.inferRef(ref.sourcePos(), defVar);
                    }
                    default -> throw new IllegalStateException("Unknown var: " + ref.resolvedVar().getClass());
                });
                return result2;
            }
            case 3: {
                Result result6;
                Expr.PiExpr pi = (Expr.PiExpr)expr3;
                result2 = result6 = this.inherit(pi, FormTerm.freshUniv(pi.sourcePos()));
                return result2;
            }
            case 4: {
                Result result7;
                Expr.SigmaExpr sigma = (Expr.SigmaExpr)expr3;
                result2 = result7 = this.inherit(sigma, FormTerm.freshUniv(sigma.sourcePos()));
                return result2;
            }
            case 5: {
                Result result8;
                IntroTerm.Lambda intro;
                Term term2;
                Expr.NewExpr newExpr = (Expr.NewExpr)expr3;
                Term struct = this.synthesize((Expr)newExpr.struct()).wellTyped;
                while ((term2 = struct.normalize(this.state, NormalizeMode.WHNF)) instanceof IntroTerm.Lambda && !(intro = (IntroTerm.Lambda)term2).param().explicit()) {
                    Term holeApp = this.mockTerm(intro.param(), newExpr.struct().sourcePos());
                    struct = CallTerm.make(intro, (Arg<Term>)new Arg((AyaDocile)holeApp, false));
                }
                if (!(struct instanceof CallTerm.Struct)) {
                    Result result9;
                    result2 = result9 = this.fail((AyaDocile)newExpr.struct(), struct, (Problem)BadTypeError.structCon(newExpr, struct));
                    return result2;
                }
                CallTerm.Struct structCall = (CallTerm.Struct)struct;
                DefVar<StructDef, Decl.StructDecl> structRef = structCall.ref();
                Substituter.TermSubst subst = new Substituter.TermSubst((MutableMap<Var, Term>)MutableMap.from((Iterable)Def.defTele(structRef).view().zip(structCall.args()).map(t -> Tuple.of((Object)((Term.Param)t._1).ref(), (Object)((Term)((Arg)t._2).term())))));
                LevelSubst.Simple levelSubst = new LevelSubst.Simple((MutableMap<Sort.LvlVar, Sort>)MutableMap.from((Iterable)Def.defLevels(structRef).view().zip(structCall.sortArgs())));
                DynamicSeq fields = DynamicSeq.create();
                DynamicSeq missing = DynamicSeq.create();
                ImmutableSeq conFields = newExpr.fields();
                for (FieldDef defField : ((StructDef)structRef.core).fields) {
                    ImmutableSeq<WithPos<LocalVar>> bindings;
                    Option conFieldOpt = conFields.find(t -> t.name().equals(defField.ref().name()));
                    if (conFieldOpt.isEmpty()) {
                        if (defField.body.isEmpty()) {
                            missing.append(defField.ref());
                            continue;
                        }
                        Term field = ((Term)defField.body.get()).subst(subst, levelSubst);
                        fields.append((Object)Tuple.of(defField.ref(), (Object)field));
                        subst.add((Var)defField.ref(), field);
                        continue;
                    }
                    Expr.Field conField = (Expr.Field)conFieldOpt.get();
                    conFields = conFields.dropWhile(t -> t == conField);
                    Term type = Def.defType(defField.ref()).subst(subst, levelSubst);
                    ImmutableSeq telescope = ((FieldDef)defField.ref().core).selfTele.map(term -> term.subst(subst, levelSubst));
                    if (telescope.sizeLessThan((bindings = conField.bindings()).size())) {
                        throw new TyckerException();
                    }
                    Expr fieldExpr = (Expr)bindings.zip((Iterable)telescope).foldRight((Object)conField.body(), (pair, lamExpr) -> new Expr.LamExpr(conField.body().sourcePos(), new Expr.Param(((WithPos)pair._1).sourcePos(), (LocalVar)((WithPos)pair._1).data(), ((Term.Param)pair._2).explicit()), (Expr)lamExpr));
                    Term field = this.inherit((Expr)fieldExpr, (Term)type).wellTyped;
                    fields.append((Object)Tuple.of(defField.ref(), (Object)field));
                    subst.add((Var)defField.ref(), field);
                }
                if (missing.isNotEmpty()) {
                    Result result10;
                    result2 = result10 = this.fail((AyaDocile)newExpr, structCall, new FieldProblem.MissingFieldError(newExpr.sourcePos(), (ImmutableSeq<Var>)missing.toImmutableSeq()));
                    return result2;
                }
                if (conFields.isNotEmpty()) {
                    Result result11;
                    result2 = result11 = this.fail((AyaDocile)newExpr, structCall, new FieldProblem.NoSuchFieldError(newExpr.sourcePos(), (ImmutableSeq<String>)conFields.map(Expr.Field::name)));
                    return result2;
                }
                result2 = result8 = new Result(new IntroTerm.New(structCall, (ImmutableMap<DefVar<FieldDef, Decl.StructField>, Term>)ImmutableMap.from((Iterable)fields)), structCall);
                return result2;
            }
            case 6: {
                Result result12;
                Expr.ProjExpr proj = (Expr.ProjExpr)expr3;
                Expr struct = proj.tup();
                Result projectee = this.synthesize(struct);
                Term whnf = projectee.type.normalize(this.state, NormalizeMode.WHNF);
                result2 = result12 = (Result)proj.ix().fold(ix -> {
                    if (!(whnf instanceof FormTerm.Sigma)) {
                        return this.fail((AyaDocile)struct, whnf, (Problem)BadTypeError.sigmaAcc(struct, ix, whnf));
                    }
                    FormTerm.Sigma sigma = (FormTerm.Sigma)whnf;
                    ImmutableSeq<Term.Param> telescope = sigma.params();
                    int index = ix - 1;
                    if (index < 0 || index >= telescope.size()) {
                        return this.fail((AyaDocile)proj, (Problem)new ProjIxError(proj, (int)ix, telescope.size()));
                    }
                    Term type = ((Term.Param)telescope.get(index)).type();
                    Substituter.TermSubst subst = ElimTerm.Proj.projSubst(projectee.wellTyped, index, telescope);
                    return new Result(new ElimTerm.Proj(projectee.wellTyped, (int)ix), type.subst(subst));
                }, sp -> {
                    DefVar<FieldDef, Decl.StructField> fieldRef;
                    String fieldName = (String)sp.data();
                    if (!(whnf instanceof CallTerm.Struct)) {
                        return this.fail((AyaDocile)struct, ErrorTerm.unexpected((AyaDocile)whnf), (Problem)BadTypeError.structAcc(struct, fieldName, whnf));
                    }
                    CallTerm.Struct structCall = (CallTerm.Struct)whnf;
                    StructDef structCore = (StructDef)structCall.ref().core;
                    if (structCore == null) {
                        throw new UnsupportedOperationException("TODO");
                    }
                    Option projected = structCore.fields.find(field -> Objects.equals(field.ref().name(), fieldName));
                    if (projected.isEmpty()) {
                        return this.fail((AyaDocile)proj, new FieldProblem.UnknownField(proj, fieldName));
                    }
                    FieldDef field2 = (FieldDef)projected.get();
                    proj.resolvedIx().value = fieldRef = field2.ref();
                    Substituter.TermSubst structSubst = Unfolder.buildSubst(structCore.telescope(), structCall.args());
                    Tuple2<LevelSubst.Simple, ImmutableSeq<Sort>> levels = this.levelStuffs(struct.sourcePos(), fieldRef);
                    ImmutableSeq<Term.Param> tele = Term.Param.subst((ImmutableSeq<Term.Param>)((FieldDef)fieldRef.core).selfTele, structSubst, (LevelSubst)levels._1);
                    ImmutableSeq teleRenamed = tele.map(Term.Param::rename);
                    CallTerm.Access access = new CallTerm.Access(projectee.wellTyped, fieldRef, (ImmutableSeq<Sort>)((ImmutableSeq)levels._2), structCall.args(), (ImmutableSeq<Arg<Term>>)teleRenamed.map(Term.Param::toArg));
                    return new Result(IntroTerm.Lambda.make((SeqLike<Term.Param>)teleRenamed, access), FormTerm.Pi.make(tele, field2.result().subst(structSubst, (LevelSubst)levels._1)));
                });
                return result2;
            }
            case 7: {
                Result result13;
                Expr.TupExpr tuple = (Expr.TupExpr)expr3;
                ImmutableSeq items = tuple.items().map(this::synthesize);
                result2 = result13 = new Result(new IntroTerm.Tuple((ImmutableSeq<Term>)items.map(Result::wellTyped)), new FormTerm.Sigma((ImmutableSeq<Term.Param>)items.map(item -> new Term.Param(Constants.anonymous(), item.type, true))));
                return result2;
            }
            case 8: {
                Result result14;
                FormTerm.Pi pi;
                Expr.AppExpr appE = (Expr.AppExpr)expr3;
                Result f = this.synthesize(appE.function());
                if (f.wellTyped instanceof ErrorTerm || f.type instanceof ErrorTerm) {
                    Result result15;
                    result2 = result15 = f;
                    return result2;
                }
                Term app = f.wellTyped;
                Arg<Expr.NamedArg> argument = appE.argument();
                Expr.NamedArg namedArg = (Expr.NamedArg)argument.term();
                Expr expr4 = namedArg.expr();
                if (expr4 instanceof Expr.UnivArgsExpr) {
                    Result result16;
                    Expr.UnivArgsExpr univArgs = (Expr.UnivArgsExpr)expr4;
                    this.univArgs(app, univArgs);
                    result2 = result16 = f;
                    return result2;
                }
                Term fTy = f.type.normalize(this.state, NormalizeMode.WHNF);
                boolean argLicit = argument.explicit();
                if (fTy instanceof CallTerm.Hole) {
                    CallTerm.Hole fTyHole = (CallTerm.Hole)fTy;
                    pi = fTyHole.asPi(argLicit);
                    this.unifier(appE.sourcePos(), Ordering.Eq).compareUntyped(fTy, pi);
                    fTy = fTy.normalize(this.state, NormalizeMode.WHNF);
                }
                if (!(fTy instanceof FormTerm.Pi)) {
                    Result result17;
                    result2 = result17 = this.fail((AyaDocile)appE, f.type, (Problem)BadTypeError.pi(appE, f.type));
                    return result2;
                }
                FormTerm.Pi piTerm = (FormTerm.Pi)fTy;
                pi = piTerm;
                Substituter.TermSubst subst = new Substituter.TermSubst((MutableMap<Var, Term>)MutableMap.create());
                try {
                    while (pi.param().explicit() != argLicit || namedArg.name() != null && !Objects.equals(pi.param().ref().name(), namedArg.name())) {
                        if (!argLicit && namedArg.name() == null) {
                            Result result18;
                            result2 = result18 = this.fail((AyaDocile)appE, new ErrorTerm(pi.body()), new LicitProblem.UnexpectedImplicitArgError(argument));
                            return result2;
                        }
                        Term holeApp = this.mockTerm(pi.param().subst(subst), namedArg.expr().sourcePos());
                        app = CallTerm.make(app, (Arg<Term>)new Arg((AyaDocile)holeApp, false));
                        subst.addDirectly((Var)pi.param().ref(), holeApp);
                        pi = this.ensurePiOrThrow(pi.body());
                    }
                    pi = this.ensurePiOrThrow(pi.subst(subst).normalize(this.state, NormalizeMode.WHNF));
                }
                catch (NotPi notPi) {
                    Result result19;
                    result2 = result19 = this.fail((AyaDocile)expr, ErrorTerm.unexpected((AyaDocile)notPi.what), (Problem)BadTypeError.pi(expr, notPi.what));
                    return result2;
                }
                Term elabArg = this.inherit((Expr)namedArg.expr(), (Term)pi.param().type()).wellTyped;
                app = CallTerm.make(app, (Arg<Term>)new Arg((AyaDocile)elabArg, argLicit));
                subst.addDirectly((Var)pi.param().ref(), elabArg);
                result2 = result14 = new Result(app, pi.body().subst(subst));
                return result2;
            }
            case 9: {
                Result result20;
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                result2 = result20 = this.inherit(hole, (Term)this.localCtx.freshHole((Term)FormTerm.freshUniv((SourcePos)hole.sourcePos()), (String)Constants.randomName((Object)hole), (SourcePos)hole.sourcePos())._2);
                return result2;
            }
        }
        result2 = result = new Result(ErrorTerm.unexpected((AyaDocile)expr), new ErrorTerm(Doc.english((String)"no rule"), false));
        return result2;
    }

    private @NotNull FormTerm.Pi ensurePiOrThrow(@NotNull Term term) throws NotPi {
        if (term instanceof FormTerm.Pi) {
            FormTerm.Pi pi = (FormTerm.Pi)term;
            return pi;
        }
        throw new NotPi(term);
    }

    private void univArgs(Term app, Expr.UnivArgsExpr univArgs) {
        Term term = IntroTerm.Lambda.unwrap(app, null);
        if (term instanceof CallTerm) {
            ImmutableSeq<Level<PreLevelVar>> levels;
            CallTerm call = (CallTerm)term;
            ImmutableSeq<Sort> sortArgs = call.sortArgs();
            if (sortArgs.sizeEquals(levels = univArgs.univArgs())) {
                sortArgs.zipView(levels).forEach(t -> this.state.levelEqns().add((Sort)t._1, this.transformLevel((Level)t._2), Ordering.Eq, univArgs.sourcePos()));
            } else {
                this.reporter.report((Problem)new UnivArgsError.SizeMismatch(univArgs, sortArgs.size()));
            }
        } else {
            this.reporter.report((Problem)new UnivArgsError.Misplaced(univArgs));
        }
    }

    @NotNull
    private Result doInherit(@NotNull Expr expr, @NotNull Term term) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.TupExpr.class, Expr.HoleExpr.class, Expr.UnivExpr.class, Expr.LamExpr.class, Expr.PiExpr.class, Expr.SigmaExpr.class}, (Object)expr3, n)) {
            case 0 -> {
                Expr.TupExpr tuple = (Expr.TupExpr)expr3;
                DynamicSeq items = DynamicSeq.create();
                DynamicSeq resultTele = DynamicSeq.create();
                Term typeWHNF = term.normalize(this.state, NormalizeMode.WHNF);
                if (typeWHNF instanceof CallTerm.Hole) {
                    CallTerm.Hole hole = (CallTerm.Hole)typeWHNF;
                    yield this.unifyTyMaybeInsert(hole, this.synthesize(tuple), tuple);
                }
                if (!(typeWHNF instanceof FormTerm.Sigma)) {
                    yield this.fail((AyaDocile)tuple, term, (Problem)BadTypeError.sigmaCon(tuple, term));
                }
                FormTerm.Sigma dt = (FormTerm.Sigma)typeWHNF;
                SeqView againstTele = dt.params().view();
                Term last = ((Term.Param)dt.params().last()).type();
                Iterator iter = tuple.items().iterator();
                while (iter.hasNext()) {
                    Expr item = (Expr)iter.next();
                    Result result = this.inherit(item, ((Term.Param)againstTele.first()).type());
                    items.append((Object)result.wellTyped);
                    LocalVar ref = ((Term.Param)againstTele.first()).ref();
                    resultTele.append((Object)new Term.Param(ref, result.type, ((Term.Param)againstTele.first()).explicit()));
                    againstTele = againstTele.drop(1);
                    if (againstTele.isNotEmpty()) {
                        Substituter.TermSubst subst = new Substituter.TermSubst((Var)ref, result.wellTyped);
                        againstTele = againstTele.map(param -> param.subst(subst)).toSeq().view();
                        last = last.subst(subst);
                        continue;
                    }
                    if (iter.hasNext()) {
                        throw new TyckerException();
                    }
                    items.append((Object)this.inherit((Expr)item, (Term)last).wellTyped);
                }
                FormTerm.Sigma resTy = new FormTerm.Sigma((ImmutableSeq<Term.Param>)resultTele.toImmutableSeq());
                yield new Result(new IntroTerm.Tuple((ImmutableSeq<Term>)items.toImmutableSeq()), resTy);
            }
            case 1 -> {
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                Tuple2<CallTerm.Hole, Term> freshHole = this.localCtx.freshHole(term, Constants.randomName(hole), hole.sourcePos());
                if (hole.explicit()) {
                    this.reporter.report((Problem)new Goal(this.state, (CallTerm.Hole)freshHole._1, (ImmutableSeq<LocalVar>)((ImmutableSeq)hole.accessibleLocal().value)));
                }
                yield new Result((Term)freshHole._2, term);
            }
            case 2 -> {
                Expr.UnivExpr univExpr = (Expr.UnivExpr)expr3;
                Sort sort = this.transformLevel(univExpr.level());
                Term normTerm = term.normalize(this.state, NormalizeMode.WHNF);
                if (normTerm instanceof FormTerm.Univ) {
                    FormTerm.Univ univ = (FormTerm.Univ)normTerm;
                    this.state.levelEqns().add(sort.lift(1), univ.sort(), Ordering.Lt, univExpr.sourcePos());
                    yield new Result(new FormTerm.Univ(sort), univ);
                }
                FormTerm.Univ succ = new FormTerm.Univ(sort.lift(1));
                this.unifyTyReported(normTerm, succ, univExpr);
                yield new Result(new FormTerm.Univ(sort), term);
            }
            case 3 -> {
                Term univ;
                Expr.LamExpr lam = (Expr.LamExpr)expr3;
                if (term instanceof CallTerm.Hole) {
                    this.unifyTy(term, this.generatePi(lam), lam.sourcePos());
                }
                if (!((univ = term.normalize(this.state, NormalizeMode.WHNF)) instanceof FormTerm.Pi)) {
                    yield this.fail((AyaDocile)lam, term, (Problem)BadTypeError.pi(lam, term));
                }
                FormTerm.Pi dt = (FormTerm.Pi)univ;
                Expr.Param param = lam.param();
                if (param.explicit() != dt.param().explicit()) {
                    yield this.fail((AyaDocile)lam, dt, new LicitProblem.LicitMismatchError(lam, dt));
                }
                LocalVar var = param.ref();
                Expr lamParam = param.type();
                Term type = dt.param().type();
                if (lamParam != null) {
                    Result result = this.inherit(lamParam, FormTerm.freshUniv(lamParam.sourcePos()));
                    boolean comparison = this.unifyTy(result.wellTyped, type, lamParam.sourcePos());
                    if (!comparison) {
                        throw new TyckerException();
                    }
                    type = result.wellTyped;
                }
                Term.Param resultParam = new Term.Param(var, type, param.explicit());
                Term body = dt.substBody(resultParam.toTerm());
                yield this.localCtx.with(resultParam, () -> {
                    Result rec = this.inherit(lam.body(), body);
                    return new Result(new IntroTerm.Lambda(resultParam, rec.wellTyped), dt);
                });
            }
            case 4 -> {
                Expr.PiExpr pi = (Expr.PiExpr)expr3;
                Expr.Param param = pi.param();
                LocalVar var = param.ref();
                Expr type = param.type();
                if (type == null) {
                    type = new Expr.HoleExpr(param.sourcePos(), false, null);
                }
                Result result = this.inherit(type, term);
                Term.Param resultParam = new Term.Param(var, result.wellTyped, param.explicit());
                yield this.localCtx.with(resultParam, () -> {
                    Result last = this.inherit(pi.last(), term);
                    return new Result(new FormTerm.Pi(resultParam, last.wellTyped), term);
                });
            }
            case 5 -> {
                Expr.SigmaExpr sigma = (Expr.SigmaExpr)expr3;
                DynamicSeq resultTele = DynamicSeq.create();
                sigma.params().forEach(tuple -> {
                    Expr type = tuple.type();
                    if (type == null) {
                        throw new TyckerException();
                    }
                    Result result = this.inherit(type, term);
                    LocalVar ref = tuple.ref();
                    this.localCtx.put(ref, result.wellTyped);
                    resultTele.append((Object)Tuple.of((Object)ref, (Object)tuple.explicit(), (Object)result.wellTyped));
                });
                sigma.params().view().map(Expr.Param::ref).forEach(arg_0 -> this.localCtx.localMap().remove(arg_0));
                yield new Result(new FormTerm.Sigma(Term.Param.fromBuffer((DynamicSeq<Tuple3<LocalVar, Boolean, Term>>)resultTele)), term);
            }
            default -> this.unifyTyMaybeInsert(term, this.synthesize(expr), expr);
        };
    }

    @NotNull
    public ImmutableSeq<Sort.LvlVar> extractLevels() {
        return Seq.of((Object)this.universe).view().filter(this.state.levelEqns()::used).appendedAll((Iterable)this.levelMapping.valuesView()).toImmutableSeq();
    }

    private void traceExit(Result result, @NotNull Expr expr) {
        this.tracing(builder -> {
            builder.append(new Trace.TyckT(result.wellTyped.freezeHoles(this.state), result.type.freezeHoles(this.state), expr.sourcePos()));
            builder.reduce();
        });
        if (expr instanceof Expr.WithTerm) {
            Expr.WithTerm withTerm = (Expr.WithTerm)expr;
            withTerm.theCore().set((Object)result.wellTyped);
        }
    }

    public ExprTycker(@NotNull Reporter reporter,  @Nullable Trace.Builder traceBuilder) {
        this.reporter = reporter;
        this.traceBuilder = traceBuilder;
    }

    public void solveMetas() {
        this.state.solveMetas(this.reporter, this.traceBuilder);
    }

    @NotNull
    public Result inherit(@NotNull Expr expr, @NotNull Term type) {
        Result result;
        FormTerm.Pi pi;
        this.tracing(builder -> builder.shift(new Trace.ExprT(expr, type.freezeHoles(this.state))));
        if (type instanceof FormTerm.Pi && !(pi = (FormTerm.Pi)type).param().explicit() && ExprTycker.needImplicitParamIns(expr)) {
            Term.Param implicitParam = new Term.Param(new LocalVar("_"), pi.param().type(), false);
            Term body = this.localCtx.with((Term.Param)implicitParam, (Supplier<Result>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$inherit$16(org.aya.concrete.Expr org.aya.core.term.FormTerm$Pi org.aya.core.term.Term$Param ), ()Lorg/aya/tyck/ExprTycker$Result;)((ExprTycker)this, (Expr)expr, (FormTerm.Pi)pi, (Term.Param)implicitParam)).wellTyped;
            result = new Result(new IntroTerm.Lambda(implicitParam, body), pi);
        } else {
            result = this.doInherit(expr, type);
        }
        this.traceExit(result, expr);
        return result;
    }

    @NotNull
    public Result synthesize(@NotNull Expr expr) {
        this.tracing(builder -> builder.shift(new Trace.ExprT(expr, null)));
        Result res = this.doSynthesize(expr);
        this.traceExit(res, expr);
        return res;
    }

    private static boolean needImplicitParamIns(@NotNull Expr expr) {
        Expr.LamExpr ex;
        return expr instanceof Expr.LamExpr && (ex = (Expr.LamExpr)expr).param().explicit() || !(expr instanceof Expr.LamExpr);
    }

    @NotNull
    public Result zonk(@NotNull Expr expr, @NotNull Result result) {
        this.solveMetas();
        SourcePos pos = expr.sourcePos();
        return new Result(result.wellTyped.zonk(this, pos), result.type.zonk(this, pos));
    }

    @NotNull
    private Term generatePi(@NotNull Expr.LamExpr expr) {
        Expr.Param param = expr.param();
        return this.generatePi(expr.sourcePos(), param.ref().name(), param.explicit());
    }

    @NotNull
    private Term generatePi(@NotNull SourcePos pos, @NotNull String name, boolean explicit) {
        String genName = name + "'";
        Term domain = (Term)this.localCtx.freshHole((Term)FormTerm.freshUniv((SourcePos)pos), (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001ty"}, (String)genName)), (SourcePos)pos)._2;
        Term codomain = (Term)this.localCtx.freshHole((Term)FormTerm.freshUniv((SourcePos)pos), (SourcePos)pos)._2;
        return new FormTerm.Pi(new Term.Param(new LocalVar(genName, pos), domain, explicit), codomain);
    }

    @NotNull
    private Result fail(@NotNull AyaDocile expr, @NotNull Problem prob) {
        return this.fail(expr, ErrorTerm.typeOf(expr), prob);
    }

    @NotNull
    private Result fail(@NotNull AyaDocile expr, @NotNull Term term, @NotNull Problem prob) {
        this.reporter.report(prob);
        return new Result(new ErrorTerm(expr), term);
    }

    @NotNull
    private Sort transformLevel(@NotNull Level<PreLevelVar> level) {
        if (level instanceof Level.Polymorphic) {
            return this.state.levelEqns().markUsed(this.universe);
        }
        if (level instanceof Level.Maximum) {
            Level.Maximum m = (Level.Maximum)level;
            return Sort.merge((ImmutableSeq<Sort>)m.among().map(this::transformLevel));
        }
        Level<PreLevelVar> level2 = level;
        Objects.requireNonNull(level2);
        Level<PreLevelVar> level3 = level2;
        int n = 0;
        return new Sort((Level<Sort.LvlVar>)((Object)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Level.Reference.class, Level.Constant.class}, level3, n)) {
            case 0 -> {
                Level.Reference v = (Level.Reference)level3;
                PreLevelVar ref = (PreLevelVar)v.ref();
                Sort.LvlVar lvlVar = ref.sourcePos() != null ? new Sort.LvlVar(ref.name(), ref.sourcePos()) : (Sort.LvlVar)this.levelMapping.getOrPut((Object)ref, () -> new Sort.LvlVar(ref.name(), null));
                yield new Level.Reference<Sort.LvlVar>(lvlVar, v.lift());
            }
            case 1 -> {
                Level.Constant c = (Level.Constant)level3;
                yield new Level.Constant<Sort.LvlVar>(c.value());
            }
            default -> throw new IllegalArgumentException(level.toString());
        })));
    }

    @NotNull
    private Result inferRef(@NotNull SourcePos pos, @NotNull DefVar<?, ?> var) {
        if (var.core instanceof FnDef || var.concrete instanceof Decl.FnDecl) {
            return this.defCall(pos, var, CallTerm.Fn::new);
        }
        if (var.core instanceof PrimDef) {
            return this.defCall(pos, var, CallTerm.Prim::new);
        }
        if (var.core instanceof DataDef || var.concrete instanceof Decl.DataDecl) {
            return this.defCall(pos, var, CallTerm.Data::new);
        }
        if (var.core instanceof StructDef || var.concrete instanceof Decl.StructDecl) {
            return this.defCall(pos, var, CallTerm.Struct::new);
        }
        if (var.core instanceof CtorDef || var.concrete instanceof Decl.DataCtor) {
            DefVar<?, ?> conVar = var;
            Tuple2<LevelSubst.Simple, ImmutableSeq<Sort>> level = this.levelStuffs(pos, conVar);
            ImmutableSeq<Term.Param> tele = Term.Param.subst(Def.defTele(conVar), (LevelSubst)level._1);
            Term type = FormTerm.Pi.make(tele, Def.defResult(conVar).subst(Substituter.TermSubst.EMPTY, (LevelSubst)level._1));
            DataDef.CtorTelescopes telescopes = CtorDef.telescopes(conVar, (ImmutableSeq<Sort>)((ImmutableSeq)level._2)).rename();
            Term body = telescopes.toConCall(conVar).subst(Substituter.TermSubst.EMPTY, (LevelSubst)level._1);
            return new Result(IntroTerm.Lambda.make(telescopes.params(), body), type);
        }
        if (var.core instanceof FieldDef || var.concrete instanceof Decl.StructField) {
            DefVar<?, ?> field = var;
            return new Result(new RefTerm.Field(field), Def.defType(field));
        }
        String msg = "Def var `" + var.name() + "` has core `" + var.core + "` which we don't know.";
        throw new IllegalStateException(msg);
    }

    @NotNull
    private <D extends Def, S extends Signatured> Result defCall(@NotNull SourcePos pos, DefVar<D, S> defVar, CallTerm.Factory<D, S> function) {
        Tuple2<LevelSubst.Simple, ImmutableSeq<Sort>> level = this.levelStuffs(pos, defVar);
        ImmutableSeq<Term.Param> tele = Term.Param.subst(Def.defTele(defVar), (LevelSubst)level._1);
        ImmutableSeq teleRenamed = tele.map(Term.Param::rename);
        CallTerm body = function.make(defVar, (ImmutableSeq<Sort>)((ImmutableSeq)level._2), (ImmutableSeq<Arg<Term>>)teleRenamed.map(Term.Param::toArg));
        Term type = FormTerm.Pi.make(tele, Def.defResult(defVar).subst(Substituter.TermSubst.EMPTY, (LevelSubst)level._1));
        return new Result(IntroTerm.Lambda.make((SeqLike<Term.Param>)teleRenamed, body), type);
    }

    @NotNull
    private Tuple2<LevelSubst.Simple, ImmutableSeq<Sort>> levelStuffs(@NotNull SourcePos pos, DefVar<? extends Def, ? extends Signatured> defVar) {
        LevelSubst.Simple levelSubst = new LevelSubst.Simple((MutableMap<Sort.LvlVar, Sort>)MutableMap.create());
        ImmutableSeq levelVars = Def.defLevels(defVar).map(v -> {
            Sort.LvlVar lvlVar = new Sort.LvlVar(defVar.name() + "." + v.name(), pos);
            levelSubst.solution().put(v, (Object)new Sort(new Level.Reference<Sort.LvlVar>(lvlVar)));
            return lvlVar;
        });
        this.state.levelEqns().vars().appendAll((Iterable)levelVars);
        return Tuple.of((Object)levelSubst, (Object)levelVars.view().map(Level.Reference::new).map(Sort::new).toImmutableSeq());
    }

    private boolean unifyTy(@NotNull Term upper, @NotNull Term lower, @NotNull SourcePos pos) {
        this.tracing(builder -> builder.append(new Trace.UnifyT(lower, upper, pos)));
        return this.unifier(pos, Ordering.Lt).compare(lower, upper, FormTerm.freshUniv(pos));
    }

    @NotNull
    public DefEq unifier(@NotNull SourcePos pos, @NotNull Ordering ord) {
        return new DefEq(ord, this.reporter, false, this.traceBuilder, this.state, pos);
    }

    void unifyTyReported(@NotNull Term upper, @NotNull Term lower, Expr loc) {
        boolean unification = this.unifyTy(upper, lower, loc.sourcePos());
        if (!unification) {
            this.reporter.report((Problem)new UnifyError(loc, upper, lower));
        }
    }

    private Result unifyTyMaybeInsert(@NotNull Term upper, @NotNull Result result, Expr loc) {
        FormTerm.Pi pi;
        Term term;
        Term lower = result.type;
        Term term2 = result.wellTyped;
        while ((term = lower.normalize(this.state, NormalizeMode.WHNF)) instanceof FormTerm.Pi && !(pi = (FormTerm.Pi)term).param().explicit()) {
            Term mock = this.mockTerm(pi.param(), loc.sourcePos());
            term2 = CallTerm.make(term2, (Arg<Term>)new Arg((AyaDocile)mock, false));
            lower = pi.substBody(mock);
        }
        if (this.unifyTy(upper, lower, loc.sourcePos())) {
            return new Result(term2, lower);
        }
        return this.fail((AyaDocile)term2.freezeHoles(this.state), upper, (Problem)new UnifyError(loc, upper, lower));
    }

    @NotNull
    private Term mockTerm(Term.Param param, SourcePos pos) {
        String genName = param.ref().name().concat("'");
        return (Term)this.localCtx.freshHole((Term)param.type(), (String)genName, (SourcePos)pos)._2;
    }

    private /* synthetic */ Result lambda$inherit$16(Expr expr, FormTerm.Pi pi, Term.Param implicitParam) {
        return this.inherit(expr, pi.substBody(implicitParam.toTerm()));
    }

    public record Result(@NotNull Term wellTyped, @NotNull Term type) {
        @Contract(value=" -> new", pure=true)
        @NotNull
        public Tuple2<Term, Term> toTuple() {
            return Tuple.of((Object)this.type, (Object)this.wellTyped);
        }
    }

    public static class TyckerException
    extends InternalException {
        public void printHint() {
            System.err.println("A type error was discovered during type checking.");
        }

        public int exitCode() {
            return 2;
        }
    }

    private static final class NotPi
    extends Exception {
        @NotNull
        private final Term what;

        public NotPi(@NotNull Term what) {
            this.what = what;
        }
    }
}

