/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Stmt;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.NotNull;

public record CircularSignatureError(@NotNull ImmutableSeq<Stmt> cycles) implements Problem
{
    @NotNull
    public SourcePos sourcePos() {
        return (SourcePos)this.cycles.view().map(Stmt::sourcePos).max(Comparator.comparingInt(SourcePos::endLine));
    }

    @NotNull
    public Doc describe(@NotNull DistillerOptions options) {
        return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Circular signature dependency found between"), Doc.commaList((SeqLike)this.cycles.view().map(this::nameOf).toImmutableSeq().sorted().view().map(Doc::plain))});
    }

    @NotNull
    private String nameOf(@NotNull Stmt stmt) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Sample.class, Remark.class}, (Object)stmt3, n)) {
            case 0 -> {
                Decl decl = (Decl)stmt3;
                yield decl.ref().name();
            }
            case 1 -> {
                Sample sample = (Sample)stmt3;
                yield this.nameOf(sample.delegate());
            }
            case 2 -> {
                Remark remark = (Remark)stmt3;
                yield remark.raw;
            }
            default -> throw new IllegalStateException("Unexpected stmt seen in SCCTycker: " + stmt);
        };
    }

    @NotNull
    public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }
}

