/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.ExprProblem;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.Var;
import org.aya.concrete.Expr;
import org.aya.distill.BaseDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FieldProblem
extends Problem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public static final class UnknownField
    extends Record
    implements FieldProblem,
    ExprProblem {
        @NotNull
        private final Expr.ProjExpr expr;
        @NotNull
        private final String name;

        public UnknownField(@NotNull Expr.ProjExpr expr, @NotNull String name) {
            this.expr = expr;
            this.name = name;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unknown field"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.name)), Doc.english((String)"projected")});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{UnknownField.class, "expr;name", "expr", "name"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UnknownField.class, "expr;name", "expr", "name"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UnknownField.class, "expr;name", "expr", "name"}, this, o);
        }

        @NotNull
        public Expr.ProjExpr expr() {
            return this.expr;
        }

        @NotNull
        public String name() {
            return this.name;
        }
    }

    public record NoSuchFieldError(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<String> notFound) implements FieldProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"No such field(s):"), Doc.commaList((SeqLike)this.notFound.view().map(m -> Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)m))))});
        }
    }

    public record MissingFieldError(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Var> missing) implements FieldProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Missing field(s):"), Doc.commaList((SeqLike)this.missing.view().map(BaseDistiller::varDoc).map(m -> Doc.styled((Style)Style.code(), (Doc)m)))});
        }
    }
}

