/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.LocalVar;
import org.aya.api.util.WithPos;
import org.aya.core.term.CallTerm;
import org.aya.core.term.Term;
import org.aya.distill.BaseDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.tyck.TyckState;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HoleProblem
extends Problem {
    @NotNull
    public CallTerm.Hole term();

    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public record CannotFindGeneralSolution(@NotNull ImmutableSeq<TyckState.Eqn> eqns) implements Problem
    {
        @NotNull
        public SourcePos sourcePos() {
            return ((TyckState.Eqn)this.eqns.last()).pos();
        }

        @NotNull
        public SeqLike<WithPos<Doc>> inlineHints(@NotNull DistillerOptions options) {
            return this.eqns.map(eqn -> new WithPos(eqn.pos(), (Object)eqn.toDoc(options)));
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.english((String)"Solving equation(s) with not very general solution(s)");
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public record RecursionError(@NotNull CallTerm.Hole term, @NotNull Term sol, @NotNull SourcePos sourcePos) implements HoleProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"Trying to solve hole"), Doc.styled((Style)Style.code(), (Doc)BaseDistiller.linkDef(this.term.ref())), Doc.plain((String)"as")}), Doc.par((int)1, (Doc)this.sol.toDoc(options)), Doc.english((String)"which is recursive")});
        }
    }

    public record BadlyScopedError(@NotNull CallTerm.Hole term, @NotNull Term solved, @NotNull Seq<LocalVar> scopeCheck, @NotNull SourcePos sourcePos) implements HoleProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"The solution"), Doc.par((int)1, (Doc)this.solved.toDoc(options)), Doc.plain((String)"is not well-scoped"), Doc.cat((Doc[])new Doc[]{Doc.english((String)"In particular, these variables are not in scope:"), Doc.ONE_WS, Doc.commaList((SeqLike)this.scopeCheck.view().map(BaseDistiller::varDoc).map(doc -> Doc.styled((Style)Style.code(), (Doc)doc)))})});
        }
    }

    public record BadSpineError(@NotNull CallTerm.Hole term, @NotNull SourcePos sourcePos) implements HoleProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Can't perform pattern unification on hole with the following spine:"), Doc.commaList((SeqLike)this.term.args().map(a -> a.toDoc(options)))});
        }
    }
}

