/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.ExprProblem;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.util.Arg;
import org.aya.concrete.Expr;
import org.aya.core.term.Term;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LicitProblem
extends Problem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public record UnexpectedImplicitArgError(@NotNull Arg<Expr.NamedArg> expr) implements LicitProblem
    {
        @NotNull
        public SourcePos sourcePos() {
            return ((Expr.NamedArg)this.expr.term()).expr().sourcePos();
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unexpected implicit argument"), Doc.styled((Style)Style.code(), (Doc)this.expr.toDoc(options))});
        }
    }

    public static final class LicitMismatchError
    extends Record
    implements LicitProblem,
    ExprProblem {
        @NotNull
        private final Expr expr;
        @NotNull
        private final Term type;

        public LicitMismatchError(@NotNull Expr expr, @NotNull Term type) {
            this.expr = expr;
            this.type = type;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot check"), Doc.par((int)1, (Doc)this.expr.toDoc(options)), Doc.english((String)"against the Pi type"), Doc.par((int)1, (Doc)this.type.toDoc(options)), Doc.english((String)"because explicitness do not match")});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LicitMismatchError.class, "expr;type", "expr", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LicitMismatchError.class, "expr;type", "expr", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LicitMismatchError.class, "expr;type", "expr", "type"}, this, o);
        }

        @NotNull
        public Expr expr() {
            return this.expr;
        }

        @NotNull
        public Term type() {
            return this.type;
        }
    }
}

