/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.order;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableSet;
import org.aya.concrete.resolve.ResolveInfo;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Stmt;
import org.aya.tyck.order.SCCTycker;
import org.aya.util.MutableGraph;
import org.jetbrains.annotations.NotNull;

public record IncrementalTycker(@NotNull SCCTycker sccTycker, @NotNull ResolveInfo usageInfo, @NotNull MutableSet<Stmt> skipped) {
    public IncrementalTycker(@NotNull SCCTycker sccTycker, @NotNull ResolveInfo resolveInfo) {
        this(sccTycker, resolveInfo.toUsageInfo(), (MutableSet<Stmt>)MutableSet.of());
    }

    public void tyckSCC(@NotNull ImmutableSeq<Stmt> scc) {
        try {
            if (this.skipped.isEmpty()) {
                this.sccTycker.tyckSCC(scc);
            } else {
                this.sccTycker.tyckSCC((ImmutableSeq<Stmt>)scc.filterNot(arg_0 -> this.skipped.contains(arg_0)));
            }
        }
        catch (SCCTycker.SCCTyckingFailed failed) {
            failed.what.forEach(this::skip);
        }
    }

    private void skip(@NotNull Stmt failed) {
        if (this.skipped.contains((Object)failed)) {
            return;
        }
        this.skipped.add((Object)failed);
        MutableGraph<Stmt> graph = failed instanceof Decl ? this.usageInfo.declGraph() : this.usageInfo.sampleGraph();
        graph.suc((Object)failed).forEach(this::skip);
    }
}

