/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.order;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.control.Option;
import org.aya.api.error.CollectingReporter;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.util.InterruptException;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.Def;
import org.aya.tyck.StmtTycker;
import org.aya.tyck.error.CircularSignatureError;
import org.aya.tyck.order.SigRefFinder;
import org.aya.tyck.trace.Trace;
import org.aya.util.MutableGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SCCTycker(@NotNull StmtTycker tycker, @NotNull CollectingReporter reporter, DynamicSeq<Def> wellTyped) {
    public SCCTycker(@Nullable Trace.Builder builder, @NotNull CollectingReporter reporter) {
        this(new StmtTycker((Reporter)reporter, builder), reporter, (DynamicSeq<Def>)DynamicSeq.create());
    }

    public void tyckSCC(@NotNull ImmutableSeq<Stmt> scc) throws SCCTyckingFailed {
        if (scc.sizeEquals(1)) {
            this.checkBody((Stmt)scc.first());
        } else {
            ImmutableSeq<Stmt> headerOrder = this.headerOrder(scc);
            headerOrder.forEach(this::checkHeader);
            headerOrder.forEach(this::checkBody);
        }
    }

    private void checkHeader(@NotNull Stmt stmt) {
        if (stmt instanceof Decl) {
            Decl decl = (Decl)stmt;
            this.tycker.tyckHeader(decl, this.tycker.newTycker());
        } else if (stmt instanceof Sample) {
            Sample sample = (Sample)stmt;
            sample.tyckHeader(this.tycker);
        }
        if (this.reporter.problems().anyMatch(Problem::isError)) {
            throw new SCCTyckingFailed((ImmutableSeq<Stmt>)ImmutableSeq.of((Object)stmt));
        }
    }

    private void checkBody(@NotNull Stmt stmt) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Sample.class, Remark.class}, (Object)stmt3, n)) {
            case 0: {
                Decl decl = (Decl)stmt3;
                this.wellTyped.append((Object)this.tycker.tyck(decl, this.tycker.newTycker()));
                break;
            }
            case 1: {
                Sample sample = (Sample)stmt3;
                this.wellTyped.append((Object)sample.tyck(this.tycker));
                break;
            }
            case 2: {
                Remark remark = (Remark)stmt3;
                Option.of((Object)remark.literate).forEach(l -> l.tyck(this.tycker.newTycker()));
                break;
            }
        }
        if (this.reporter.problems().anyMatch(Problem::isError)) {
            throw new SCCTyckingFailed((ImmutableSeq<Stmt>)ImmutableSeq.of((Object)stmt));
        }
    }

    @NotNull
    public ImmutableSeq<Stmt> headerOrder(@NotNull ImmutableSeq<Stmt> stmts) {
        MutableGraph graph = MutableGraph.create();
        stmts.forEach(stmt -> {
            DynamicSeq reference = DynamicSeq.create();
            stmt.accept(SigRefFinder.HEADER_ONLY, reference);
            graph.suc(stmt).appendAll((Iterable)reference);
        });
        ImmutableSeq order = graph.topologicalOrder();
        SeqView cycle = order.view().filter(s -> s.sizeGreaterThan(1));
        if (cycle.isNotEmpty()) {
            cycle.forEach(c -> this.reporter.report((Problem)new CircularSignatureError((ImmutableSeq<Stmt>)c)));
            throw new SCCTyckingFailed(stmts);
        }
        return order.flatMap(Function.identity());
    }

    public static class SCCTyckingFailed
    extends InterruptException {
        @NotNull
        public ImmutableSeq<Stmt> what;

        public SCCTyckingFailed(@NotNull ImmutableSeq<Stmt> what) {
            this.what = what;
        }

        public InterruptException.InterruptStage stage() {
            return InterruptException.InterruptStage.Tycking;
        }
    }
}

