/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.Tuple3;
import kala.tuple.Unit;
import org.aya.api.distill.AyaDocile;
import org.aya.api.error.IgnoringReporter;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.api.util.NormalizeMode;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.visitor.ExprRefSubst;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.pat.PatMatcher;
import org.aya.core.sort.LevelSubst;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Substituter;
import org.aya.core.visitor.Unfolder;
import org.aya.generic.GenericBuilder;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.LocalCtx;
import org.aya.tyck.error.NotYetTyckedError;
import org.aya.tyck.pat.PatternProblem;
import org.aya.tyck.trace.Trace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatTycker {
    @NotNull
    private final ExprTycker exprTycker;
    @NotNull
    public final ExprRefSubst refSubst;
    private final @NotNull Substituter.TermSubst termSubst;
    private final  @Nullable Trace.Builder traceBuilder;
    private boolean hasError = false;
    private Pattern.Clause currentClause = null;

    public boolean noError() {
        return !this.hasError;
    }

    public PatTycker(@NotNull ExprTycker exprTycker, @NotNull ExprRefSubst refSubst, @NotNull Substituter.TermSubst termSubst, @Nullable Trace.Builder traceBuilder) {
        this.exprTycker = exprTycker;
        this.refSubst = refSubst;
        this.termSubst = termSubst;
        this.traceBuilder = traceBuilder;
    }

    private void tracing(@NotNull @NotNull Consumer< @NotNull Trace.Builder> consumer) {
        if (this.traceBuilder != null) {
            consumer.accept(this.traceBuilder);
        }
    }

    public PatTycker(@NotNull ExprTycker exprTycker) {
        this(exprTycker, new ExprRefSubst(exprTycker.reporter), new Substituter.TermSubst((MutableMap<Var, Term>)MutableMap.create()), exprTycker.traceBuilder);
    }

    @NotNull
    public @NotNull Tuple2<@NotNull Term, @NotNull ImmutableSeq<Pat.PrototypeClause>> elabClauses(@NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature signature) {
        ImmutableSeq res = clauses.mapIndexed((index, clause) -> {
            this.tracing(builder -> builder.shift(new Trace.LabelT(clause.sourcePos, "clause " + (1 + index))));
            this.refSubst.clear();
            Pat.PrototypeClause elabClause = this.visitMatch((Pattern.Clause)clause, signature);
            this.tracing(GenericBuilder::reduce);
            return elabClause;
        });
        this.exprTycker.solveMetas();
        return Tuple.of((Object)signature.result().zonk(this.exprTycker, null), (Object)res.map(c -> c.mapTerm(e -> e.zonk(this.exprTycker, null))));
    }

    @NotNull
    public ImmutableSeq<Pat.PrototypeClause> elabClauses(@Nullable ExprRefSubst patSubst, Def.Signature signature, @NotNull ImmutableSeq<Pattern.Clause> clauses) {
        ImmutableSeq checked = clauses.map(c -> {
            if (patSubst != null) {
                this.refSubst.resetTo(patSubst);
            }
            return Tuple.of((Object)this.visitMatch((Pattern.Clause)c, signature), (Object)c.sourcePos);
        });
        this.exprTycker.solveMetas();
        return checked.map(c -> ((Pat.PrototypeClause)c._1).mapTerm(e -> e.zonk(this.exprTycker, (SourcePos)c._2)));
    }

    @NotNull
    private Pat doTyck(@NotNull Pattern pattern, @NotNull Term term) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Absurd.class, Pattern.Tuple.class, Pattern.Ctor.class, Pattern.Bind.class}, (Object)pattern3, n)) {
            case 0 -> {
                Pattern.Absurd absurd = (Pattern.Absurd)pattern3;
                Tuple3<CallTerm.Data, Substituter.TermSubst, CallTerm.ConHead> selection = this.selectCtor(term, null, this.refSubst.reporter(), absurd);
                if (selection != null) {
                    this.foundError();
                    this.refSubst.reporter().report((Problem)new PatternProblem.PossiblePat(absurd, (CallTerm.ConHead)selection._3));
                }
                yield new Pat.Absurd(absurd.explicit(), term);
            }
            case 1 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                if (!(term instanceof FormTerm.Sigma)) {
                    yield this.withError(new PatternProblem.TupleNonSig(tuple, term), tuple, "?", term);
                }
                FormTerm.Sigma sigma = (FormTerm.Sigma)term;
                Def.Signature sig = new Def.Signature((ImmutableSeq<Sort.LvlVar>)ImmutableSeq.empty(), sigma.params(), new ErrorTerm(Doc.plain((String)"Rua"), false));
                LocalVar as = tuple.as();
                if (as != null) {
                    this.exprTycker.localCtx.put(as, sigma);
                }
                yield new Pat.Tuple(tuple.explicit(), (ImmutableSeq<Pat>)((ImmutableSeq)this.visitPatterns((Def.Signature)sig, (SeqView<Pattern>)tuple.patterns().view())._1), as, sigma);
            }
            case 2 -> {
                DefVar<CtorDef, Decl.DataCtor> ctorRef;
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                Tuple3<CallTerm.Data, Substituter.TermSubst, CallTerm.ConHead> realCtor = this.selectCtor(term, (String)ctor.name().data(), this.refSubst.reporter(), ctor);
                if (realCtor == null) {
                    yield this.withError(new PatternProblem.UnknownCtor(ctor), ctor, (String)ctor.name().data(), term);
                }
                ctor.resolved().value = ctorRef = ((CallTerm.ConHead)realCtor._3).ref();
                CtorDef ctorCore = (CtorDef)ctorRef.core;
                CallTerm.Data dataCall = (CallTerm.Data)realCtor._1;
                LevelSubst levelSubst = Unfolder.buildSubst(Def.defLevels(dataCall.ref()), dataCall.sortArgs());
                Def.Signature sig = new Def.Signature((ImmutableSeq<Sort.LvlVar>)ImmutableSeq.empty(), Term.Param.subst((ImmutableSeq<Term.Param>)ctorCore.selfTele, (Substituter.TermSubst)realCtor._2, levelSubst), dataCall);
                Tuple2<ImmutableSeq<Pat>, Term> patterns = this.visitPatterns(sig, (SeqView<Pattern>)ctor.params().view());
                yield new Pat.Ctor(ctor.explicit(), ((CallTerm.ConHead)realCtor._3).ref(), (ImmutableSeq<Pat>)((ImmutableSeq)patterns._1), ctor.as(), (CallTerm.Data)realCtor._1);
            }
            case 3 -> {
                Tuple3<CallTerm.Data, Substituter.TermSubst, CallTerm.ConHead> selected;
                Pattern.Bind bind = (Pattern.Bind)pattern3;
                LocalVar v = bind.bind();
                if (term instanceof CallTerm.Prim) {
                    CallTerm.Prim prim = (CallTerm.Prim)term;
                    if (((PrimDef)prim.ref().core).id == PrimDef.ID.INTERVAL) {
                        for (PrimDef.ID primName : PrimDef.Factory.LEFT_RIGHT) {
                            if (!Objects.equals(bind.bind().name(), primName.id)) continue;
                            this.refSubst.bad().add((Object)bind.bind());
                            yield new Pat.Prim(bind.explicit(), ((PrimDef)PrimDef.Factory.INSTANCE.getOption(primName).get()).ref(), term);
                        }
                    }
                }
                if ((selected = this.selectCtor(term, v.name(), (Reporter)IgnoringReporter.INSTANCE, bind)) == null) {
                    this.exprTycker.localCtx.put(v, term);
                    yield new Pat.Bind(bind.explicit(), v, term);
                }
                CtorDef ctorCore = (CtorDef)((CallTerm.ConHead)selected._3).ref().core;
                if (ctorCore.selfTele.isNotEmpty()) {
                    this.foundError();
                    throw new ExprTycker.TyckerException();
                }
                Var value = (Var)bind.resolved().value;
                if (value != null) {
                    this.refSubst.good().putIfAbsent((Object)v, (Object)value);
                } else {
                    this.refSubst.bad().add((Object)v);
                }
                yield new Pat.Ctor(bind.explicit(), ((CallTerm.ConHead)selected._3).ref(), (ImmutableSeq<Pat>)ImmutableSeq.empty(), null, (CallTerm.Data)selected._1);
            }
            default -> throw new UnsupportedOperationException("Number and underscore patterns are unsupported yet");
        };
    }

    private Pat.PrototypeClause visitMatch(@NotNull Pattern.Clause match, @NotNull Def.Signature signature) {
        this.exprTycker.localCtx = this.exprTycker.localCtx.derive();
        this.currentClause = match;
        Tuple2<ImmutableSeq<Pat>, Term> patterns = this.visitPatterns(signature, (SeqView<Pattern>)match.patterns.view());
        Term type = (Term)patterns._2;
        match.expr = match.expr.map(e -> e.accept(this.refSubst, Unit.unit()));
        Option result = match.hasError ? match.expr.map(e -> new ErrorTerm((AyaDocile)e, false)) : match.expr.map(e -> this.exprTycker.inherit((Expr)e, type).wellTyped().subst(this.termSubst));
        this.termSubst.clear();
        LocalCtx parent = this.exprTycker.localCtx.parent();
        assert (parent != null);
        this.exprTycker.localCtx = parent;
        return new Pat.PrototypeClause(match.sourcePos, (ImmutableSeq<Pat>)((ImmutableSeq)patterns._1), (Option<Term>)result);
    }

    @NotNull
    public Tuple2<ImmutableSeq<Pat>, Term> visitPatterns(Def.Signature sig, SeqView<Pattern> stream) {
        DynamicSeq results = DynamicSeq.create();
        while (sig.param().isNotEmpty()) {
            Pattern pat;
            Term.Param param = (Term.Param)sig.param().first();
            if (param.explicit()) {
                if (stream.isEmpty()) {
                    this.foundError();
                    throw new ExprTycker.TyckerException();
                }
                pat = (Pattern)stream.first();
                stream = stream.drop(1);
                if (!pat.explicit()) {
                    this.foundError();
                    throw new ExprTycker.TyckerException();
                }
            } else {
                if (stream.isEmpty()) {
                    sig = this.generatePat(new PatData(sig, (DynamicSeq<Pat>)results, param));
                    continue;
                }
                pat = (Pattern)stream.first();
                if (pat.explicit()) {
                    sig = this.generatePat(new PatData(sig, (DynamicSeq<Pat>)results, param));
                    continue;
                }
                stream = stream.drop(1);
            }
            sig = this.updateSig(new PatData(sig, (DynamicSeq<Pat>)results, param), pat);
        }
        if (stream.isNotEmpty()) {
            this.foundError();
            this.exprTycker.reporter.report((Problem)new PatternProblem.TooManyPattern((Pattern)stream.first(), sig.result().freezeHoles(this.exprTycker.state)));
        }
        return Tuple.of((Object)results.toImmutableSeq(), (Object)sig.result());
    }

    @NotNull
    private Def.Signature updateSig(PatData data, Pattern pat) {
        Term type = data.param.type();
        this.tracing(builder -> builder.shift(new Trace.PatT(type, pat, pat.sourcePos())));
        Pat res = this.doTyck(pat, type);
        this.tracing(GenericBuilder::reduce);
        this.termSubst.add((Var)data.param.ref(), res.toTerm());
        data.results.append((Object)res);
        return data.sig.inst(this.termSubst);
    }

    @NotNull
    private Def.Signature generatePat(PatData data) {
        LocalVar ref = data.param.ref();
        Pat.Bind bind = new Pat.Bind(false, new LocalVar(ref.name(), ref.definition()), data.param.type());
        data.results.append((Object)bind);
        this.exprTycker.localCtx.put(bind.as(), data.param.type());
        this.termSubst.add((Var)ref, bind.toTerm());
        return data.sig.inst(this.termSubst);
    }

    private void foundError() {
        this.hasError = true;
        if (this.currentClause != null) {
            this.currentClause.hasError = true;
        }
    }

    @NotNull
    private Pat withError(Problem problem, Pattern pattern, String name, Term param) {
        this.exprTycker.reporter.report(problem);
        this.foundError();
        return new Pat.Bind(pattern.explicit(), new LocalVar(name), param);
    }

    @Nullable
    private Tuple3<CallTerm.Data, Substituter.TermSubst, CallTerm.ConHead> selectCtor(Term param, @Nullable String name, @NotNull Reporter reporter, @NotNull Pattern pos) {
        Term term = param.normalize(this.exprTycker.state, NormalizeMode.WHNF);
        if (!(term instanceof CallTerm.Data)) {
            reporter.report((Problem)new PatternProblem.SplittingOnNonData(pos, param));
            return null;
        }
        CallTerm.Data dataCall = (CallTerm.Data)term;
        DataDef core = (DataDef)dataCall.ref().core;
        if (core == null) {
            reporter.report((Problem)new NotYetTyckedError(pos.sourcePos(), (Var)dataCall.ref()));
            return null;
        }
        for (CtorDef ctor : core.body) {
            if (name != null && !Objects.equals(ctor.ref().name(), name)) continue;
            Substituter.TermSubst matchy = this.mischa(dataCall, core, ctor);
            if (matchy != null) {
                return Tuple.of((Object)dataCall, (Object)matchy, (Object)dataCall.conHead(ctor.ref()));
            }
            if (name == null) continue;
            Problem.Severity severity = reporter == IgnoringReporter.INSTANCE ? Problem.Severity.WARN : Problem.Severity.ERROR;
            this.refSubst.reporter().report((Problem)new PatternProblem.UnavailableCtor(pos, severity));
            return null;
        }
        return null;
    }

    @Nullable
    private Substituter.TermSubst mischa(CallTerm.Data dataCall, DataDef core, CtorDef ctor) {
        if (ctor.pats.isNotEmpty()) {
            return PatMatcher.tryBuildSubstArgs(ctor.pats, dataCall.args());
        }
        return Unfolder.buildSubst(core.telescope(), dataCall.args());
    }

    private record PatData(Def.Signature sig, DynamicSeq<Pat> results, Term.Param param) {
    }
}

