/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.concrete.Pattern;
import org.aya.core.term.CallTerm;
import org.aya.core.term.Term;
import org.aya.distill.BaseDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PatternProblem
extends Problem {
    @NotNull
    public Pattern pattern();

    @NotNull
    default public SourcePos sourcePos() {
        return this.pattern().sourcePos();
    }

    public record TooManyPattern(@NotNull Pattern pattern, @NotNull Term retTy) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"There is no parameter for the pattern"), Doc.par((int)1, (Doc)this.pattern.toDoc(options)), Doc.english((String)"to match against, given the return type"), Doc.par((int)1, (Doc)this.retTy.toDoc(options)), Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.english((String)"and in case it's a function type, you may want to move its parameters before the"), Doc.styled((Style)Style.code(), (String)":"), Doc.english((String)"in the signature")}))});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public static final class TupleNonSig
    extends Record
    implements PatternProblem {
        @NotNull
        private final Pattern.Tuple pattern;
        @NotNull
        private final Term type;

        public TupleNonSig(@NotNull Pattern.Tuple pattern, @NotNull Term type) {
            this.pattern = pattern;
            this.type = type;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"The tuple pattern"), Doc.par((int)1, (Doc)this.pattern.toDoc(options)), Doc.english((String)"splits only on sigma types, while the actual type"), Doc.par((int)1, (Doc)this.type.freezeHoles(null).toDoc(options)), Doc.english((String)"does not look like one")});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TupleNonSig.class, "pattern;type", "pattern", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TupleNonSig.class, "pattern;type", "pattern", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TupleNonSig.class, "pattern;type", "pattern", "type"}, this, o);
        }

        @Override
        @NotNull
        public Pattern.Tuple pattern() {
            return this.pattern;
        }

        @NotNull
        public Term type() {
            return this.type;
        }
    }

    public record UnknownCtor(@NotNull Pattern pattern) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Unknown constructor"), Doc.par((int)1, (Doc)this.pattern.toDoc(options))});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public record UnavailableCtor(@NotNull Pattern pattern, @NotNull Problem.Severity level) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot match with"), Doc.par((int)1, (Doc)this.pattern.toDoc(options)), Doc.cat((Doc[])new Doc[]{Doc.english((String)"due to a failed index unification"), Doc.emptyIf((boolean)this.isError(), () -> Doc.english((String)", treating as bind pattern"))})});
        }
    }

    public record SplittingOnNonData(@NotNull Pattern pattern, @NotNull Term type) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot split on a non-inductive type"), Doc.par((int)1, (Doc)this.type.toDoc(options)), Doc.english((String)"with a constructor pattern"), Doc.par((int)1, (Doc)this.pattern.toDoc(options))});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public record PossiblePat(@NotNull Pattern pattern, @NotNull CallTerm.ConHead available) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Absurd pattern does not fit here because"), Doc.styled((Style)Style.code(), (Doc)BaseDistiller.varDoc(this.available.ref())), Doc.english((String)"is still available")});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }
}

