/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.trace;

import kala.collection.SeqLike;
import kala.collection.mutable.DynamicSeq;
import kala.tuple.Unit;
import org.aya.api.distill.DistillerOptions;
import org.aya.distill.BaseDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.tyck.trace.Trace;
import org.jetbrains.annotations.NotNull;

public class MdUnicodeTrace
implements Trace.Visitor<Unit, Doc> {
    public final int indent;
    @NotNull
    public final DistillerOptions options;
    @NotNull
    public static final Doc plus = Doc.symbol((String)"+");
    @NotNull
    public static final Doc colon = Doc.symbol((String)":");

    public MdUnicodeTrace(int indent, @NotNull DistillerOptions options) {
        this.indent = indent;
        this.options = options;
    }

    public MdUnicodeTrace() {
        this(2, DistillerOptions.informative());
    }

    @Override
    public Doc visitDecl(@NotNull Trace.DeclT t, Unit unit) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, BaseDistiller.varDoc(t.var())}), this.indentedChildren(t.children())});
    }

    @NotNull
    private Doc indentedChildren(DynamicSeq<@NotNull Trace> children) {
        return Doc.nest((int)this.indent, (Doc)Doc.vcat((SeqLike)children.view().map(trace -> trace.accept(this, Unit.unit()))));
    }

    @Override
    public Doc visitExpr(@NotNull Trace.ExprT t, Unit unit) {
        DynamicSeq buf = DynamicSeq.of((Object)plus, (Object)Doc.symbol((String)"\u22a2"), (Object)Doc.styled((Style)Style.code(), (Doc)t.expr().toDoc(this.options)));
        if (t.term() != null) {
            buf.append((Object)colon);
            buf.append((Object)t.term().toDoc(this.options));
        }
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((SeqLike)buf), this.indentedChildren(t.children())});
    }

    @Override
    public Doc visitUnify(@NotNull Trace.UnifyT t, Unit unit) {
        DynamicSeq buf = DynamicSeq.of((Object)plus, (Object)Doc.symbol((String)"\u22a2"), (Object)t.lhs().toDoc(this.options), (Object)Doc.symbol((String)"\u2261"), (Object)t.rhs().toDoc(this.options));
        if (t.type() != null) {
            buf.append((Object)colon);
            buf.append((Object)t.type().toDoc(this.options));
        }
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((SeqLike)buf), this.indentedChildren(t.children())});
    }

    @Override
    public Doc visitTyck(@NotNull Trace.TyckT t, Unit unit) {
        assert (t.children().isEmpty());
        return Doc.sep((Doc[])new Doc[]{plus, Doc.plain((String)"result"), Doc.symbol((String)"\u22a2"), Doc.styled((Style)Style.code(), (Doc)t.term().toDoc(this.options)), Doc.symbol((String)"\u2191"), t.type().toDoc(this.options)});
    }

    @Override
    public Doc visitPat(@NotNull Trace.PatT t, Unit unit) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, Doc.plain((String)"pat"), Doc.symbol((String)"\u22a2"), Doc.styled((Style)Style.code(), (Doc)t.pat().toDoc(this.options)), colon, t.term().toDoc(this.options)}), this.indentedChildren(t.children())});
    }

    @Override
    public Doc visitLabel(@NotNull Trace.LabelT t, Unit unit) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, Doc.english((String)t.label())}), this.indentedChildren(t.children())});
    }

    @NotNull
    public Doc docify(@NotNull Trace.Builder traceBuilder) {
        return Doc.vcat((SeqLike)traceBuilder.root().view().map(e -> e.accept(this, Unit.unit())));
    }
}

