/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.unify.level;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.base.Growable;
import kala.collection.mutable.DynamicSeq;
import kala.collection.mutable.MutableMap;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.SourcePos;
import org.aya.core.sort.LevelSubst;
import org.aya.core.sort.Sort;
import org.aya.generic.Level;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.unify.level.LevelSolver;
import org.aya.util.Ordering;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public record LevelEqnSet(@NotNull DynamicSeq<Sort.LvlVar> vars, @NotNull @NotNull DynamicSeq<@NotNull Eqn> eqns, @NotNull @NotNull MutableMap<Sort.LvlVar, @NotNull Sort> solution) implements LevelSubst.Default
{
    public LevelEqnSet() {
        this((DynamicSeq<Sort.LvlVar>)DynamicSeq.create(), (DynamicSeq<Eqn>)DynamicSeq.create(), (MutableMap<Sort.LvlVar, Sort>)MutableMap.create());
    }

    public void add(@NotNull Sort lhs, @NotNull Sort rhs, @NotNull Ordering cmp, @NotNull SourcePos loc) {
        this.insertEqn(new Eqn(lhs, rhs, cmp, loc));
    }

    private void insertEqn(Eqn h) {
        this.eqns.append((Object)h);
    }

    public void solve() {
        LevelSolver solver = new LevelSolver();
        try {
            solver.solve(this);
            for (Sort.LvlVar lvlVar : this.vars) {
                if (this.solution.containsKey((Object)lvlVar)) continue;
                this.solution.put((Object)lvlVar, (Object)new Sort(new Level.Constant<Sort.LvlVar>(0)));
            }
            this.eqns.clear();
        }
        catch (LevelSolver.UnsatException ignored) {
            DynamicSeq buf = DynamicSeq.create();
            this.eqns.filterNotTo((Growable)buf, arg_0 -> solver.avoidableEqns.contains(arg_0));
            this.eqns.clear();
            this.eqns.appendAll((Iterable)buf);
        }
    }

    public boolean used(@NotNull Sort.LvlVar var) {
        return this.eqns.anyMatch(eqn -> eqn.used(var)) || this.solution.valuesView().anyMatch(level -> Eqn.used(var, level));
    }

    public Sort markUsed(@NotNull Sort.LvlVar universe) {
        return (Sort)this.solution.getOrPut((Object)universe, () -> new Sort(new Level.Reference<Sort.LvlVar>(universe)));
    }

    @TestOnly
    @NotNull
    public String forZZS() {
        StringBuilder builder = new StringBuilder("List.of(");
        boolean started = false;
        for (Eqn eqn : this.eqns) {
            if (started) {
                builder.append(", ");
            }
            started = true;
            eqn.forZZS(builder);
        }
        return builder.append(")").toString();
    }

    public record Eqn(@NotNull Sort lhs, @NotNull Sort rhs, @NotNull Ordering cmp, @NotNull SourcePos sourcePos) implements AyaDocile
    {
        public boolean used(@NotNull Sort.LvlVar var) {
            return Eqn.used(var, this.lhs) || Eqn.used(var, this.rhs);
        }

        public static boolean used(@NotNull Sort.LvlVar var, @NotNull Level<Sort.LvlVar> lvl) {
            Level.Reference l;
            return lvl instanceof Level.Reference && (l = (Level.Reference)lvl).ref() == var;
        }

        public static boolean used(@NotNull Sort.LvlVar var, @NotNull Sort lvl) {
            return lvl.levels().anyMatch(level -> Eqn.used(var, level));
        }

        @TestOnly
        @NotNull
        public String forZZS(@NotNull Level<Sort.LvlVar> level) {
            Level<Sort.LvlVar> level2 = level;
            Objects.requireNonNull(level2);
            Level<Sort.LvlVar> level3 = level2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Level.Reference.class, Level.Constant.class}, level3, n)) {
                case 0 -> {
                    Level.Reference ref = (Level.Reference)level3;
                    Sort.LvlVar r = (Sort.LvlVar)ref.ref();
                    yield "new Reference(new Var(\"" + r.name() + "\", " + r.free() + "), " + ref.lift() + ")";
                }
                case 1 -> {
                    Level.Constant constant = (Level.Constant)level3;
                    yield "new Const(" + constant.value() + ")";
                }
                default -> throw new IllegalArgumentException(level.toString());
            };
        }

        @TestOnly
        public void forZZS(@NotNull StringBuilder builder) {
            builder.append("new Equation(Ord.").append(this.cmp.name()).append(", new Max(List.of(");
            this.lhs.levels().joinTo((Appendable)builder, (CharSequence)", ", this::forZZS);
            builder.append(")), new Max(List.of(");
            this.rhs.levels().joinTo((Appendable)builder, (CharSequence)", ", this::forZZS);
            builder.append(")))");
        }

        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return Doc.stickySep((Doc[])new Doc[]{this.lhs.toDoc(options), Doc.symbol((String)this.cmp.symbol), this.rhs.toDoc(options)});
        }
    }
}

