/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.unify.level;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import org.aya.core.sort.Sort;
import org.aya.generic.Level;
import org.aya.tyck.unify.level.LevelEqnSet;
import org.aya.util.Ordering;
import org.jetbrains.annotations.NotNull;

public class LevelSolver {
    public static final int INF = 100000000;
    private int nodeSize;
    private final MutableSet<Sort.LvlVar> unfreeNodes = MutableSet.create();
    private final MutableSet<Sort.LvlVar> freeNodes = MutableSet.create();
    private final MutableMap<Sort.LvlVar, Integer> graphMap = MutableMap.create();
    private final MutableMap<Sort.LvlVar, Integer> defaultValues = MutableMap.create();
    public final DynamicSeq<LevelEqnSet.Eqn> avoidableEqns = DynamicSeq.create();

    public static String markdownify(int[][] g) {
        return Seq.from((Object[])g).view().map(ints -> Arrays.stream(ints).mapToObj(Objects::toString).collect(Collectors.joining("|", "|", "|"))).joinToString((CharSequence)"\n");
    }

    boolean floyd(int[][] d) {
        for (int k = 0; k <= this.nodeSize; ++k) {
            for (int i = 0; i <= this.nodeSize; ++i) {
                for (int j = 0; j <= this.nodeSize; ++j) {
                    d[i][j] = Math.min(d[i][j], d[i][k] + d[k][j]);
                }
            }
        }
        for (int i = 0; i <= this.nodeSize; ++i) {
            if (d[i][i] >= 0) continue;
            return true;
        }
        for (Sort.LvlVar nu : this.unfreeNodes) {
            int u = (Integer)this.graphMap.get((Object)nu);
            if (d[u][0] < 0) {
                return true;
            }
            if (d[0][u] < 50000000) {
                return true;
            }
            for (Sort.LvlVar nv : this.unfreeNodes) {
                int v = (Integer)this.graphMap.get((Object)nv);
                if (u == v || d[u][v] >= 50000000) continue;
                return true;
            }
            for (int v = 1; v <= this.nodeSize; ++v) {
                if (d[u][v] >= 0) continue;
                return true;
            }
        }
        return false;
    }

    void addEdge(int[][] g, int u, int v, int dist) {
        g[u][v] = Math.min(g[u][v], dist);
    }

    private void genGraphNode(SeqLike<Level<Sort.LvlVar>> l) {
        for (Level e : l) {
            Level.Reference th;
            if (!(e instanceof Level.Reference) || this.graphMap.containsKey((Object)((Sort.LvlVar)(th = (Level.Reference)e).ref()))) continue;
            this.graphMap.put((Object)((Sort.LvlVar)th.ref()), (Object)(++this.nodeSize));
        }
    }

    private boolean dealSingleLt(int[][] g, Level<Sort.LvlVar> a, Level<Sort.LvlVar> b) {
        if (a instanceof Level.Constant) {
            Level.Constant ca = (Level.Constant)a;
            if (b instanceof Level.Constant) {
                Level.Constant cb = (Level.Constant)b;
                return ca.value() > cb.value();
            }
            if (b instanceof Level.Reference) {
                Level.Reference rb = (Level.Reference)b;
                int u = ca.value();
                int v = rb.lift();
                int x = (Integer)this.graphMap.get((Object)((Sort.LvlVar)rb.ref()));
                this.addEdge(g, x, 0, v - u);
            }
        } else if (a instanceof Level.Reference) {
            Level.Reference ra = (Level.Reference)a;
            int x = (Integer)this.graphMap.get((Object)((Sort.LvlVar)ra.ref()));
            int u = ra.lift();
            if (b instanceof Level.Constant) {
                Level.Constant cb = (Level.Constant)b;
                int v = cb.value();
                this.addEdge(g, 0, x, v - u);
            } else if (b instanceof Level.Reference) {
                Level.Reference rb = (Level.Reference)b;
                int y = (Integer)this.graphMap.get((Object)((Sort.LvlVar)rb.ref()));
                int v = rb.lift();
                this.addEdge(g, y, x, v - u);
            }
        }
        return false;
    }

    void prepareGraphNode(int[][] g, SeqLike<Level<Sort.LvlVar>> l) {
        for (Level e : l) {
            if (!(e instanceof Level.Reference)) continue;
            Level.Reference th = (Level.Reference)e;
            int defaultValue = -th.lift();
            int u = (Integer)this.graphMap.get((Object)((Sort.LvlVar)th.ref()));
            if (((Sort.LvlVar)th.ref()).free()) {
                this.defaultValues.put((Object)((Sort.LvlVar)th.ref()), (Object)0);
                this.freeNodes.add((Object)((Sort.LvlVar)th.ref()));
                this.addEdge(g, 0, u, 100000000);
                continue;
            }
            this.unfreeNodes.add((Object)((Sort.LvlVar)th.ref()));
        }
    }

    private int[][] dfs(SeqLike<LevelEqnSet.Eqn> l, int pos, int[][] g) throws UnsatException {
        if (l.sizeLessThanOrEquals(pos)) {
            if (this.floyd(g)) {
                throw new UnsatException();
            }
            return g;
        }
        LevelEqnSet.Eqn th = (LevelEqnSet.Eqn)l.get(pos);
        ImmutableSeq<Level<Sort.LvlVar>> lhsVar = th.lhs().levels();
        ImmutableSeq<Level<Sort.LvlVar>> rhsVar = th.rhs().levels();
        if (lhsVar.isEmpty() || rhsVar.isEmpty()) {
            return this.dfs(l, pos + 1, g);
        }
        for (Level max : rhsVar) {
            int[][] gg = new int[this.nodeSize + 1][this.nodeSize + 1];
            for (int i = 0; i <= this.nodeSize; ++i) {
                if (this.nodeSize + 1 < 0) continue;
                System.arraycopy(g[i], 0, gg[i], 0, this.nodeSize + 1);
            }
            for (Level v : lhsVar) {
                this.dealSingleLt(gg, v, max);
            }
            for (Level v : rhsVar) {
                this.dealSingleLt(gg, v, max);
            }
            try {
                return this.dfs(l, pos + 1, gg);
            }
            catch (UnsatException unsatException) {
            }
        }
        throw new UnsatException();
    }

    public void solve(@NotNull LevelEqnSet eqns) throws UnsatException {
        DynamicSeq<LevelEqnSet.Eqn> equations = eqns.eqns();
        this.nodeSize = 0;
        this.graphMap.clear();
        for (LevelEqnSet.Eqn e2 : equations) {
            this.genGraphNode((SeqLike<Level<Sort.LvlVar>>)e2.lhs().levels());
            this.genGraphNode((SeqLike<Level<Sort.LvlVar>>)e2.rhs().levels());
        }
        int[][] g = new int[this.nodeSize + 1][this.nodeSize + 1];
        for (int i = 0; i <= this.nodeSize; ++i) {
            for (int j = 0; j <= this.nodeSize; ++j) {
                g[i][j] = i == j ? 0 : 100000000;
            }
        }
        for (LevelEqnSet.Eqn e3 : equations) {
            this.prepareGraphNode(g, (SeqLike<Level<Sort.LvlVar>>)e3.lhs().levels());
            this.prepareGraphNode(g, (SeqLike<Level<Sort.LvlVar>>)e3.rhs().levels());
        }
        DynamicSeq specialEq = DynamicSeq.create();
        ImmutableSeq equationsImm = equations.toImmutableSeq();
        boolean hasError = equationsImm.map(e -> this.populate(g, (DynamicSeq<LevelEqnSet.Eqn>)specialEq, (LevelEqnSet.Eqn)e, true)).anyMatch(b -> b);
        if (hasError || this.floyd(g)) {
            throw new UnsatException();
        }
        hasError = equationsImm.map(e -> this.populate(g, (DynamicSeq<LevelEqnSet.Eqn>)specialEq, (LevelEqnSet.Eqn)e, false)).anyMatch(b -> b);
        if (hasError || this.floyd(g)) {
            throw new UnsatException();
        }
        int[][] gg = this.dfs((SeqLike<LevelEqnSet.Eqn>)specialEq, 0, g);
        for (Sort.LvlVar name : this.freeNodes) {
            int lowerBound;
            int thDefault;
            int u = (Integer)this.graphMap.get((Object)name);
            int upperBound = gg[0][u];
            if (upperBound >= (thDefault = ((Integer)this.defaultValues.get((Object)name)).intValue())) {
                this.addEdge(gg, u, 0, thDefault);
                this.floyd(gg);
                upperBound = gg[0][u];
            }
            if ((lowerBound = -gg[u][0]) < 0) {
                lowerBound = 0;
            }
            DynamicSeq upperNodes = DynamicSeq.create();
            DynamicSeq lowerNodes = DynamicSeq.create();
            for (Sort.LvlVar nu : this.unfreeNodes) {
                int v = (Integer)this.graphMap.get((Object)nu);
                if (gg[v][u] != 100000000) {
                    upperNodes.append(new Level.Reference<Sort.LvlVar>(nu, gg[v][u]));
                }
                if (gg[u][v] >= 50000000) continue;
                lowerNodes.append(new Level.Reference<Sort.LvlVar>(nu, -gg[u][v]));
            }
            DynamicSeq retList = DynamicSeq.create();
            if (!lowerNodes.isEmpty() || upperNodes.isEmpty()) {
                if (lowerBound != 0 || lowerNodes.isEmpty()) {
                    retList.append(new Level.Constant(lowerBound));
                }
                retList.appendAll((Iterable)lowerNodes);
            } else {
                int minv = upperBound;
                for (Level _l : upperNodes) {
                    if (!(_l instanceof Level.Reference)) continue;
                    Level.Reference l = (Level.Reference)_l;
                    minv = Math.min(minv, l.lift());
                }
                retList.append(new Level.Constant(minv));
            }
            eqns.solution().put((Object)name, (Object)new Sort((ImmutableSeq<Level<Sort.LvlVar>>)retList.toImmutableSeq()));
        }
    }

    private boolean populate(int[][] g, DynamicSeq<LevelEqnSet.Eqn> specialEq, LevelEqnSet.Eqn e, boolean complex) {
        Sort lhs = e.lhs();
        Sort rhs = e.rhs();
        return switch (e.cmp()) {
            default -> throw new IncompatibleClassChangeError();
            case Ordering.Gt -> this.populateLt(g, specialEq, e, rhs, lhs, complex);
            case Ordering.Lt -> this.populateLt(g, specialEq, e, lhs, rhs, complex);
            case Ordering.Eq -> Boolean.logicalAnd(this.populateLt(g, specialEq, e, rhs, lhs, complex), this.populateLt(g, specialEq, e, lhs, rhs, complex));
        };
    }

    private boolean populateLt(int[][] g, DynamicSeq<LevelEqnSet.Eqn> specialEq, LevelEqnSet.Eqn e, Sort lhs, Sort rhs, boolean complex) {
        if (complex && rhs.levels().sizeGreaterThan(1)) {
            return false;
        }
        ImmutableSeq lhsLevels = lhs.levels().filter(vr -> {
            if (vr instanceof Level.Reference) {
                Level.Reference ref = (Level.Reference)vr;
                Sort.LvlVar th = (Sort.LvlVar)ref.ref();
                for (Level vp : rhs.levels()) {
                    Level.Reference __r;
                    Sort.LvlVar tp;
                    if (!(vp instanceof Level.Reference) || g[(Integer)this.graphMap.get((Object)(tp = (Sort.LvlVar)(__r = (Level.Reference)vp).ref()))][(Integer)this.graphMap.get((Object)th)] + ref.lift() - __r.lift() > 0) continue;
                    return false;
                }
            }
            return true;
        });
        DynamicSeq rhsLevels = DynamicSeq.create();
        for (Level vr2 : rhs.levels()) {
            Level.Reference ref;
            Sort.LvlVar th;
            boolean insert = true;
            if (vr2 instanceof Level.Reference && !(th = (Sort.LvlVar)(ref = (Level.Reference)vr2).ref()).free()) {
                insert = false;
                if (lhsLevels.anyMatch(left -> this.dealSingleLt(g, (Level<Sort.LvlVar>)left, vr2))) {
                    return true;
                }
            }
            if (!insert) continue;
            rhsLevels.append((Object)vr2);
        }
        if (lhsLevels.isEmpty() || rhsLevels.isEmpty()) {
            return false;
        }
        if (lhsLevels.sizeEquals(1) && rhsLevels.sizeGreaterThan(1)) {
            Level.Constant constant;
            Level left2 = (Level)lhsLevels.get(0);
            if (left2 instanceof Level.Constant && (constant = (Level.Constant)left2).value() == 0) {
                this.avoidableEqns.append((Object)e);
                return false;
            }
            return rhsLevels.anyMatch(right -> this.dealSingleLt(g, left2, (Level<Sort.LvlVar>)right));
        }
        if (rhsLevels.sizeEquals(1)) {
            Level right2 = (Level)rhsLevels.get(0);
            return lhsLevels.anyMatch(left -> this.dealSingleLt(g, (Level<Sort.LvlVar>)left, right2));
        }
        specialEq.append((Object)new LevelEqnSet.Eqn(new Sort((ImmutableSeq<Level<Sort.LvlVar>>)lhsLevels), new Sort((ImmutableSeq<Level<Sort.LvlVar>>)rhsLevels.toImmutableSeq()), Ordering.Lt, e.sourcePos()));
        return false;
    }

    public static class UnsatException
    extends Exception {
    }
}

