/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Either;
import kala.value.Ref;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.visitor.ExprView;
import org.aya.core.pat.Pat;
import org.aya.distill.BaseDistiller;
import org.aya.distill.ConcreteDistiller;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.ref.LocalVar;
import org.aya.ref.Var;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.tyck.ExprTycker;
import org.aya.util.binop.BinOpParser;
import org.aya.util.distill.AyaDocile;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Expr
extends AyaDocile,
SourceNode {
    public <P, R> R doAccept(@NotNull Visitor<P, R> var1, P var2);

    default public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
        visitor.traceEntrance(this, p);
        R ret = this.doAccept(visitor, p);
        visitor.traceExit(ret, this, p);
        return ret;
    }

    @Contract(pure=true)
    default public Expr resolve(@NotNull ModuleContext context) {
        ExprResolver exprResolver = new ExprResolver(ExprResolver.RESTRICTIVE);
        exprResolver.enterBody();
        return this.accept(exprResolver, context);
    }

    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return new ConcreteDistiller(options).term(BaseDistiller.Outer.Free, this);
    }

    @NotNull
    public static Expr unapp(@NotNull Expr expr, @Nullable MutableList<NamedArg> args) {
        while (expr instanceof AppExpr) {
            AppExpr app = (AppExpr)expr;
            if (args != null) {
                args.append((Object)app.argument);
            }
            expr = app.function;
        }
        if (args != null) {
            args.reverse();
        }
        return expr;
    }

    @NotNull
    default public ExprView view() {
        return () -> this;
    }

    public static interface Visitor<P, R> {
        default public void traceEntrance(@NotNull Expr expr, P p) {
        }

        default public void traceExit(R r, @NotNull Expr expr, P p) {
        }

        public R visitRef(@NotNull RefExpr var1, P var2);

        public R visitUnresolved(@NotNull UnresolvedExpr var1, P var2);

        public R visitLam(@NotNull LamExpr var1, P var2);

        public R visitPi(@NotNull PiExpr var1, P var2);

        public R visitSigma(@NotNull SigmaExpr var1, P var2);

        public R visitRawUniv(@NotNull RawUnivExpr var1, P var2);

        public R visitLift(@NotNull LiftExpr var1, P var2);

        public R visitUniv(@NotNull UnivExpr var1, P var2);

        public R visitApp(@NotNull AppExpr var1, P var2);

        public R visitHole(@NotNull HoleExpr var1, P var2);

        public R visitTup(@NotNull TupExpr var1, P var2);

        public R visitProj(@NotNull ProjExpr var1, P var2);

        public R visitNew(@NotNull NewExpr var1, P var2);

        public R visitLitInt(@NotNull LitIntExpr var1, P var2);

        public R visitLitString(@NotNull LitStringExpr var1, P var2);

        public R visitBinOpSeq(@NotNull BinOpSeq var1, P var2);

        public R visitError(@NotNull ErrorExpr var1, P var2);

        public R visitMetaPat(@NotNull MetaPat var1, P var2);
    }

    public record AppExpr(@NotNull SourcePos sourcePos, @NotNull Expr function, @NotNull NamedArg argument) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitApp(this, p);
        }
    }

    public static final class NamedArg
    extends Record
    implements AyaDocile,
    SourceNode,
    BinOpParser.Elem<Expr> {
        private final boolean explicit;
        @Nullable
        private final String name;
        @NotNull
        private final Expr expr;

        public NamedArg(boolean explicit, @NotNull Expr expr) {
            this(explicit, null, expr);
        }

        public NamedArg(boolean explicit, @Nullable String name, @NotNull Expr expr) {
            this.explicit = explicit;
            this.name = name;
            this.expr = expr;
        }

        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            Doc doc = this.name == null ? this.expr.toDoc(options) : Doc.braced((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)this.name), Doc.symbol((String)"=>"), this.expr.toDoc(options)}));
            return Doc.bracedUnless((Doc)doc, (boolean)this.explicit);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.expr.sourcePos();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NamedArg.class, "explicit;name;expr", "explicit", "name", "expr"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NamedArg.class, "explicit;name;expr", "explicit", "name", "expr"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NamedArg.class, "explicit;name;expr", "explicit", "name", "expr"}, this, o);
        }

        public boolean explicit() {
            return this.explicit;
        }

        @Nullable
        public String name() {
            return this.name;
        }

        @NotNull
        public Expr expr() {
            return this.expr;
        }
    }

    public static final class Param
    extends Record
    implements ParamLike<Expr> {
        @NotNull
        private final SourcePos sourcePos;
        @NotNull
        private final LocalVar ref;
        @NotNull
        private final Expr type;
        private final boolean pattern;
        private final boolean explicit;

        public Param(@NotNull Param param, @NotNull Expr type) {
            this(param.sourcePos, param.ref, type, param.pattern, param.explicit);
        }

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar var, boolean explicit) {
            this(sourcePos, var, new HoleExpr(sourcePos, false, null), false, explicit);
        }

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar ref, @NotNull Expr type, boolean pattern, boolean explicit) {
            this.sourcePos = sourcePos;
            this.ref = ref;
            this.type = type;
            this.pattern = pattern;
            this.explicit = explicit;
        }

        @NotNull
        public Param mapExpr(@NotNull @NotNull Function<@NotNull Expr, @NotNull Expr> mapper) {
            return new Param(this.sourcePos, this.ref, mapper.apply(this.type), this.pattern, this.explicit);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Param.class, "sourcePos;ref;type;pattern;explicit", "sourcePos", "ref", "type", "pattern", "explicit"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Param.class, "sourcePos;ref;type;pattern;explicit", "sourcePos", "ref", "type", "pattern", "explicit"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Param.class, "sourcePos;ref;type;pattern;explicit", "sourcePos", "ref", "type", "pattern", "explicit"}, this, o);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }

        @Override
        @NotNull
        public LocalVar ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public Expr type() {
            return this.type;
        }

        @Override
        public boolean pattern() {
            return this.pattern;
        }

        @Override
        public boolean explicit() {
            return this.explicit;
        }
    }

    public record BinOpSeq(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<NamedArg> seq) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitBinOpSeq(this, p);
        }
    }

    public record MetaPat(@NotNull SourcePos sourcePos, Pat.Meta meta) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitMetaPat(this, p);
        }
    }

    public record LitStringExpr(@NotNull SourcePos sourcePos, @NotNull String string) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLitString(this, p);
        }
    }

    public record LitIntExpr(@NotNull SourcePos sourcePos, int integer) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLitInt(this, p);
        }
    }

    public record Field(@NotNull WithPos<String> name, @NotNull ImmutableSeq<WithPos<LocalVar>> bindings, @NotNull Expr body, @NotNull Ref<Var> resolvedField) {
    }

    public record NewExpr(@NotNull SourcePos sourcePos, @NotNull Expr struct, @NotNull ImmutableSeq<Field> fields) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitNew(this, p);
        }
    }

    public record ProjExpr(@NotNull SourcePos sourcePos, @NotNull Expr tup, @NotNull Either<Integer, QualifiedID> ix, @Nullable Var resolvedIx, @NotNull Ref<ExprTycker.Result> theCore) implements Expr,
    WithTerm
    {
        public ProjExpr(@NotNull SourcePos sourcePos, @NotNull Expr tup, @NotNull Either<Integer, QualifiedID> ix) {
            this(sourcePos, tup, ix, null, (Ref<ExprTycker.Result>)new Ref());
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitProj(this, p);
        }
    }

    public record TupExpr(@NotNull SourcePos sourcePos, @NotNull @NotNull ImmutableSeq<@NotNull Expr> items) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitTup(this, p);
        }
    }

    public record UnivExpr(@NotNull SourcePos sourcePos, int lift) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitUniv(this, p);
        }
    }

    public record RawUnivExpr(@NotNull SourcePos sourcePos) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitRawUniv(this, p);
        }
    }

    public record LiftExpr(@NotNull SourcePos sourcePos, @NotNull Expr expr, int lift) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLift(this, p);
        }
    }

    public record RefExpr(@NotNull SourcePos sourcePos, @NotNull Var resolvedVar, @NotNull Ref<ExprTycker.Result> theCore) implements Expr,
    WithTerm
    {
        public RefExpr(@NotNull SourcePos sourcePos, @NotNull Var resolvedVar) {
            this(sourcePos, resolvedVar, (Ref<ExprTycker.Result>)new Ref());
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitRef(this, p);
        }
    }

    public record SigmaExpr(@NotNull SourcePos sourcePos, boolean co, @NotNull @NotNull ImmutableSeq<@NotNull Param> params) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitSigma(this, p);
        }
    }

    public record LamExpr(@NotNull SourcePos sourcePos, @NotNull Param param, @NotNull Expr body) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLam(this, p);
        }
    }

    public record PiExpr(@NotNull SourcePos sourcePos, boolean co, @NotNull Param param, @NotNull Expr last) implements Expr
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitPi(this, p);
        }
    }

    public record HoleExpr(@NotNull SourcePos sourcePos, boolean explicit, @Nullable Expr filling, Ref<ImmutableSeq<LocalVar>> accessibleLocal) implements Expr
    {
        public HoleExpr(@NotNull SourcePos sourcePos, boolean explicit, @Nullable Expr filling) {
            this(sourcePos, explicit, filling, (Ref<ImmutableSeq<LocalVar>>)new Ref());
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitHole(this, p);
        }
    }

    public record ErrorExpr(@NotNull SourcePos sourcePos, @NotNull AyaDocile description) implements Expr
    {
        public ErrorExpr(@NotNull SourcePos sourcePos, @NotNull Doc description) {
            this(sourcePos, options -> description);
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitError(this, p);
        }
    }

    public record UnresolvedExpr(@NotNull SourcePos sourcePos, @NotNull QualifiedID name) implements Expr
    {
        public UnresolvedExpr(@NotNull SourcePos sourcePos, @NotNull String name) {
            this(sourcePos, new QualifiedID(sourcePos, name));
        }

        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitUnresolved(this, p);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WithTerm
    extends Expr {
        @NotNull
        public Ref<ExprTycker.Result> theCore();

        @Nullable
        default public ExprTycker.Result core() {
            return (ExprTycker.Result)this.theCore().value;
        }
    }
}

