/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar;

import java.util.function.Function;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.error.OperatorProblem;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.tyck.pat.PatternProblem;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.BinOpParser;
import org.aya.util.binop.BinOpSet;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinPatternParser
extends BinOpParser<AyaBinOpSet, Pattern, Pattern> {
    private final boolean outerMostLicit;
    @NotNull
    private final ResolveInfo resolveInfo;
    private static final Pattern OP_APP = new Pattern.Bind(SourcePos.NONE, true, new LocalVar(BinOpSet.APP_ELEM.name()));

    public BinPatternParser(boolean outerMostLicit, @NotNull ResolveInfo resolveInfo, @NotNull @NotNull SeqView<@NotNull Pattern> seq) {
        super((BinOpSet)resolveInfo.opSet(), seq);
        this.outerMostLicit = outerMostLicit;
        this.resolveInfo = resolveInfo;
    }

    @NotNull
    protected BinOpParser<AyaBinOpSet, Pattern, Pattern> replicate(@NotNull @NotNull SeqView<@NotNull Pattern> seq) {
        return new BinPatternParser(this.outerMostLicit, this.resolveInfo, seq);
    }

    @NotNull
    protected Pattern appOp() {
        return OP_APP;
    }

    @NotNull
    public Pattern makeSectionApp(@NotNull SourcePos pos, @NotNull Pattern op, @NotNull Function<Pattern, Pattern> lamBody) {
        return this.createErrorExpr(pos);
    }

    protected void reportAmbiguousPred(String op1, String op2, SourcePos pos) {
        ((AyaBinOpSet)this.opSet).reporter.report((Problem)new OperatorProblem.AmbiguousPredError(op1, op2, pos));
    }

    protected void reportFixityError(Assoc top, Assoc current, String topOp, String currentOp, SourcePos pos) {
        ((AyaBinOpSet)this.opSet).reporter.report((Problem)new OperatorProblem.FixityError(currentOp, current, topOp, top, pos));
    }

    @NotNull
    protected Pattern createErrorExpr(@NotNull SourcePos sourcePos) {
        return new Pattern.Bind(sourcePos, true, new LocalVar("a broken constructor pattern"));
    }

    @Nullable
    protected OpDecl underlyingOpDecl(@NotNull Pattern elem) {
        OpDecl opDecl;
        Pattern.Ctor ref;
        Object object = elem.expr();
        if (object instanceof Pattern.Ctor && (object = (ref = (Pattern.Ctor)object).resolved().data()) instanceof DefVar) {
            DefVar defVar = (DefVar)object;
            opDecl = (OpDecl)defVar.opDeclRename.getOrDefault(this.resolveInfo.thisModule().moduleName(), (Object)defVar.opDecl);
        } else {
            opDecl = null;
        }
        return opDecl;
    }

    @NotNull
    protected Pattern makeArg(@NotNull SourcePos pos, @NotNull Pattern func, @NotNull Pattern arg, boolean explicit) {
        if (func instanceof Pattern.Ctor) {
            Pattern.Ctor ctor = (Pattern.Ctor)func;
            return new Pattern.Ctor(pos, this.outerMostLicit, ctor.resolved(), (ImmutableSeq<Pattern>)ctor.params().appended((Object)arg), ctor.as());
        }
        ((AyaBinOpSet)this.opSet).reporter.report((Problem)new PatternProblem.UnknownCtor(func));
        throw new Context.ResolvingInterruptedException();
    }
}

