/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Unit;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.BinExprParser;
import org.aya.concrete.desugar.BinPatternParser;
import org.aya.concrete.error.LevelProblem;
import org.aya.concrete.visitor.ExprOps;
import org.aya.concrete.visitor.ExprView;
import org.aya.concrete.visitor.StmtOps;
import org.aya.resolve.ResolveInfo;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public record Desugarer(@NotNull ResolveInfo resolveInfo) implements StmtOps<Unit>
{
    @Override
    @NotNull
    public Expr visitExpr(@NotNull Expr expr, Unit pp) {
        return new ForExpr(expr.view(), this.resolveInfo).commit();
    }

    @Override
    @NotNull
    public Pattern visitBinOpPattern(@NotNull Pattern.BinOpSeq binOpSeq, Unit unit) {
        ImmutableSeq<Pattern> seq = binOpSeq.seq();
        assert (seq.isNotEmpty()) : binOpSeq.sourcePos().toString();
        Pattern pat = (Pattern)new BinPatternParser(binOpSeq.explicit(), this.resolveInfo, (SeqView<Pattern>)seq.view()).build(binOpSeq.sourcePos());
        return StmtOps.super.visitPattern(pat, unit);
    }

    public record ForExpr(@NotNull ExprView view, @NotNull ResolveInfo info) implements ExprOps
    {
        private int levelVar(@NotNull Expr expr) throws DesugarInterruption {
            Expr expr2 = expr;
            Objects.requireNonNull(expr2);
            Expr expr3 = expr2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.BinOpSeq.class, Expr.LitIntExpr.class}, (Object)expr3, n)) {
                case 0 -> {
                    Expr.BinOpSeq binOpSeq = (Expr.BinOpSeq)expr3;
                    yield this.levelVar(this.pre(binOpSeq));
                }
                case 1 -> {
                    Expr.LitIntExpr uLit = (Expr.LitIntExpr)expr3;
                    yield uLit.integer();
                }
                default -> {
                    this.info.opSet().reporter.report((Problem)new LevelProblem.BadLevelExpr(expr));
                    throw new DesugarInterruption();
                }
            };
        }

        @Override
        @NotNull
        public Expr pre(@NotNull Expr expr) {
            Expr expr2;
            Expr expr3 = expr;
            int n = 0;
            block7: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.AppExpr.class, Expr.RawUnivExpr.class, Expr.BinOpSeq.class, Expr.class}, (Object)expr3, n)) {
                    case 0: {
                        Expr.AppExpr app = (Expr.AppExpr)expr3;
                        Expr expr4 = app.function();
                        if (!(expr4 instanceof Expr.RawUnivExpr)) {
                            n = 1;
                            continue block7;
                        }
                        Expr.RawUnivExpr univ = (Expr.RawUnivExpr)expr4;
                        try {
                            Expr.UnivExpr univExpr = new Expr.UnivExpr(univ.sourcePos(), this.levelVar(app.argument().expr()));
                            expr2 = univExpr;
                        }
                        catch (DesugarInterruption e) {
                            Expr.ErrorExpr errorExpr = new Expr.ErrorExpr(app.sourcePos(), app);
                            expr2 = errorExpr;
                        }
                        break block7;
                    }
                    case 1: {
                        Expr.RawUnivExpr univ = (Expr.RawUnivExpr)expr3;
                        Expr.UnivExpr univExpr = new Expr.UnivExpr(univ.sourcePos(), 0);
                        expr2 = univExpr;
                        break block7;
                    }
                    case 2: {
                        Expr expr5;
                        Expr.BinOpSeq binOpSeq = (Expr.BinOpSeq)expr3;
                        ImmutableSeq<Expr.NamedArg> seq = binOpSeq.seq();
                        assert (seq.isNotEmpty()) : binOpSeq.sourcePos().toString();
                        expr2 = expr5 = this.pre((Expr)new BinExprParser(this.info, (SeqView<Expr.NamedArg>)seq.view()).build(binOpSeq.sourcePos()));
                        break block7;
                    }
                    default: {
                        Expr misc;
                        Expr expr6;
                        expr2 = expr6 = (misc = expr3);
                        break block7;
                    }
                }
                break;
            }
            return expr2;
        }
    }

    public static class DesugarInterruption
    extends Exception {
    }
}

