/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.error;

import java.util.Comparator;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.distill.BaseDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.pretty.doc.Styles;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.BinOpSet;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public final class OperatorProblem {

    public record Circular(@NotNull ImmutableSeq<BinOpSet.BinOP> items) implements Problem
    {
        @NotNull
        public SourcePos sourcePos() {
            return (SourcePos)this.items.view().map(BinOpSet.BinOP::firstBind).max(Comparator.comparingInt(SourcePos::endLine));
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Circular precedence found between"), Doc.commaList((SeqLike)this.items.view().map(BinOpSet.BinOP::name).toImmutableSeq().sorted().view().map(Doc::plain))});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public record BindSelfError(@NotNull SourcePos sourcePos) implements Problem
    {
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.english((String)"Self bind is not allowed");
        }
    }

    public record AmbiguousPredError(@NotNull String op1, @NotNull String op2, @NotNull SourcePos sourcePos) implements Problem
    {
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Ambiguous operator precedence detected between"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.op1)), Doc.plain((String)"and"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.op2))});
        }

        @NotNull
        public Doc hint(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Use"), Doc.styled((Styles)BaseDistiller.KEYWORD.and().code(), (Doc)Doc.plain((String)"bind")), Doc.english((String)"statement or insert parentheses to make it clear.")});
        }
    }

    public record FixityError(@NotNull String op1, @NotNull Assoc assoc1, @NotNull String op2, @NotNull Assoc assoc2, @NotNull SourcePos sourcePos) implements Problem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Cannot figure out computation order because"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.op1)), Doc.parened((Doc)Doc.plain((String)this.assoc1.name())), Doc.plain((String)"and"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.op2)), Doc.parened((Doc)Doc.plain((String)this.assoc1.name())), this.reason()});
        }

        @NotNull
        private Doc reason() {
            return this.assoc1 == this.assoc2 && this.assoc1 == Assoc.Infix ? Doc.english((String)"share the same precedence but no associativity was specified.") : Doc.english((String)"share the same precedence but don't share the same associativity.");
        }

        @NotNull
        public Doc hint(@NotNull DistillerOptions options) {
            return Doc.english((String)"Make them both left/right-associative to resolve this problem.");
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public record NotOperator(@NotNull SourcePos sourcePos, @NotNull String op) implements Problem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.plain((String)this.op), Doc.english((String)"is not an operator. It cannot have bind block.")});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }
}

