/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.remark;

import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.value.Ref;
import org.aya.concrete.Expr;
import org.aya.concrete.remark.CodeOptions;
import org.aya.concrete.visitor.ExprConsumer;
import org.aya.core.def.UserDef;
import org.aya.core.term.Term;
import org.aya.generic.util.NormalizeMode;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Docile;
import org.aya.pretty.doc.Style;
import org.aya.ref.DefVar;
import org.aya.ref.Var;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.order.TyckOrder;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Literate
extends Docile {
    default public <P> void modify(@NotNull Function<Expr, Expr> fixpoint) {
    }

    default public <P> void visit(@NotNull ExprConsumer<P> consumer, P p) {
    }

    default public void tyck(@NotNull ExprTycker tycker) {
    }

    @NotNull
    public ImmutableSeq<TyckOrder> resolve(@NotNull ResolveInfo var1, @NotNull Context var2);

    public static final class Code
    implements Literate {
        @NotNull
        public Expr expr;
        @Nullable
        public ExprTycker.Result tyckResult;
        @NotNull
        public final CodeOptions options;

        public Code(@NotNull Expr expr, @NotNull CodeOptions options) {
            this.expr = expr;
            this.options = options;
        }

        @Override
        @Contract(mutates="this")
        public <P> void modify(@NotNull Function<Expr, Expr> fixpoint) {
            this.expr = fixpoint.apply(this.expr);
        }

        @Override
        public <P> void visit(@NotNull ExprConsumer<P> consumer, P p) {
            this.expr.accept(consumer, p);
        }

        @Override
        public void tyck(@NotNull ExprTycker tycker) {
            this.tyckResult = tycker.zonk(tycker.synthesize(this.expr));
        }

        @Override
        @NotNull
        public ImmutableSeq<TyckOrder> resolve(@NotNull ResolveInfo info, @NotNull Context context) {
            ExprResolver resolver = new ExprResolver(ExprResolver.RESTRICTIVE);
            resolver.enterBody();
            this.modify(e -> e.accept(resolver, context));
            return resolver.reference().toImmutableSeq();
        }

        @NotNull
        private Doc normalize(@NotNull Term term) {
            NormalizeMode mode = this.options.mode();
            return term.normalize(null, mode).toDoc(this.options.options());
        }

        @NotNull
        public Doc toDoc() {
            if (this.tyckResult == null) {
                return Doc.plain((String)"Error");
            }
            Style style = Style.code();
            return Doc.styled((Style)style, (Doc)(switch (this.options.showCode()) {
                default -> throw new IncompatibleClassChangeError();
                case CodeOptions.ShowCode.Concrete -> this.expr.toDoc(this.options.options());
                case CodeOptions.ShowCode.Core -> this.normalize(this.tyckResult.wellTyped());
                case CodeOptions.ShowCode.Type -> this.normalize(this.tyckResult.type());
            }));
        }
    }

    public record Err(@NotNull Ref<Var> def, @NotNull SourcePos sourcePos) implements Literate
    {
        @Override
        @NotNull
        public ImmutableSeq<TyckOrder> resolve(@NotNull ResolveInfo info, @NotNull Context context) {
            this.def.set((Object)context.getUnqualified(((Var)this.def.value).name(), this.sourcePos));
            return ImmutableSeq.empty();
        }

        @NotNull
        public Doc toDoc() {
            Object object = this.def.value;
            if (object instanceof DefVar) {
                DefVar defVar = (DefVar)object;
                object = defVar.core;
                if (object instanceof UserDef) {
                    UserDef userDef = (UserDef)object;
                    ImmutableSeq<Problem> problems = userDef.problems;
                    if (problems == null) {
                        return Doc.styled((Style)Style.bold(), (Doc)Doc.english((String)"No error message."));
                    }
                    return Doc.vcat((SeqLike)problems.map(problem -> problem.brief(DistillerOptions.informative())));
                }
            }
            return Doc.styled((Style)Style.bold(), (Doc)Doc.english((String)"Not a definition that can obtain error message."));
        }
    }

    public record Many(@Nullable Style style, @NotNull ImmutableSeq<Literate> children) implements Literate
    {
        @Override
        @NotNull
        public ImmutableSeq<TyckOrder> resolve(@NotNull ResolveInfo info, @NotNull Context context) {
            this.children.forEach(child -> child.resolve(info, context));
            return ImmutableSeq.empty();
        }

        @Override
        public <P> void modify(@NotNull Function<Expr, Expr> fixpoint) {
            this.children.forEach(literate -> literate.modify(fixpoint));
        }

        @Override
        public <P> void visit(@NotNull ExprConsumer<P> consumer, P p) {
            this.children.forEach(literate -> literate.visit(consumer, p));
        }

        @Override
        public void tyck(@NotNull ExprTycker tycker) {
            this.children.forEach(literate -> literate.tyck(tycker));
        }

        @NotNull
        public Doc toDoc() {
            Doc cat = Doc.cat((SeqLike)this.children.map(Docile::toDoc));
            return this.style == null ? cat : Doc.styled((Style)this.style, (Doc)cat);
        }
    }

    public record Raw(@NotNull Doc toDoc) implements Literate
    {
        @Override
        @NotNull
        public ImmutableSeq<TyckOrder> resolve(@NotNull ResolveInfo info, @NotNull Context context) {
            return ImmutableSeq.empty();
        }
    }
}

