/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.remark;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.remark.CodeAttrProcessor;
import org.aya.concrete.remark.CodeOptions;
import org.aya.concrete.remark.Literate;
import org.aya.concrete.remark.UnsupportedMarkdown;
import org.aya.concrete.stmt.Stmt;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.tyck.order.TyckOrder;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Remark
implements Stmt {
    @Nullable
    public final Literate literate;
    @NotNull
    public final String raw;
    @NotNull
    public final SourcePos sourcePos;
    @Nullable
    public Context ctx = null;

    private Remark(@Nullable Literate literate, @NotNull String raw, @NotNull SourcePos sourcePos) {
        this.literate = literate;
        this.raw = raw;
        this.sourcePos = sourcePos;
    }

    @NotNull
    public static Remark make(@NotNull String raw, @NotNull SourcePos pos, @NotNull GenericAyaParser ayaParser) {
        Parser mdParser = Parser.builder().customDelimiterProcessor((DelimiterProcessor)CodeAttrProcessor.INSTANCE).build();
        Node ast = mdParser.parse(raw);
        return new Remark(Remark.mapAST(ast, pos, ayaParser), raw, pos);
    }

    @NotNull
    private static ImmutableSeq<Literate> mapChildren(@NotNull Node parent, @NotNull SourcePos pos, @NotNull GenericAyaParser producer) {
        MutableList children = MutableList.create();
        Node node = parent.getFirstChild();
        while (node != null) {
            if (children.isNotEmpty() && node instanceof Paragraph) {
                children.append((Object)new Literate.Raw(Doc.line()));
            }
            Node next = node.getNext();
            children.append((Object)Remark.mapAST(node, pos, producer));
            node = next;
        }
        return children.toImmutableSeq();
    }

    @Nullable
    private static Literate mapAST(@NotNull Node node, @NotNull SourcePos pos, @NotNull GenericAyaParser producer) {
        if (node instanceof Code) {
            Code code = (Code)node;
            return CodeOptions.analyze(code, producer.expr(code.getLiteral(), pos));
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            return new Literate.Raw(Doc.plain((String)text.getLiteral()));
        }
        if (node instanceof Emphasis) {
            Emphasis emphasis = (Emphasis)node;
            return new Literate.Many(Style.italic(), Remark.mapChildren((Node)emphasis, pos, producer));
        }
        if (node instanceof HardLineBreak || node instanceof SoftLineBreak) {
            return new Literate.Raw(Doc.line());
        }
        if (node instanceof StrongEmphasis) {
            StrongEmphasis emphasis = (StrongEmphasis)node;
            return new Literate.Many(Style.bold(), Remark.mapChildren((Node)emphasis, pos, producer));
        }
        if (node instanceof Paragraph) {
            return new Literate.Many(null, Remark.mapChildren(node, pos, producer));
        }
        if (node instanceof Document) {
            ImmutableSeq<Literate> children = Remark.mapChildren(node, pos, producer);
            if (children.sizeEquals(1)) {
                return (Literate)children.first();
            }
            return new Literate.Many(null, children);
        }
        producer.reporter().report((Problem)new UnsupportedMarkdown(pos, node.getClass().getSimpleName()));
        return null;
    }

    @Override
    @NotNull
    public Stmt.Accessibility accessibility() {
        return Stmt.Accessibility.Private;
    }

    @Override
    public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
        return visitor.visitRemark(this, p);
    }

    @NotNull
    public SourcePos sourcePos() {
        return this.sourcePos;
    }

    @NotNull
    public ImmutableSeq<TyckOrder> doResolve(@NotNull ResolveInfo info) {
        if (this.literate == null) {
            return ImmutableSeq.empty();
        }
        assert (this.ctx != null) : "Be sure to call the shallow resolver before resolving";
        return this.literate.resolve(info, this.ctx);
    }

    @Override
    public boolean needTyck(@NotNull ImmutableSeq<String> currentMod) {
        return true;
    }
}

