/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import kala.collection.Map;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.util.binop.Assoc;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Command
extends Stmt {
    @Override
    default public boolean needTyck(@NotNull ImmutableSeq<String> currentMod) {
        return false;
    }

    public record Module(@NotNull SourcePos sourcePos, @NotNull String name, @NotNull @NotNull ImmutableSeq<@NotNull Stmt> contents) implements Command
    {
        @Override
        @NotNull
        public Stmt.Accessibility accessibility() {
            return Stmt.Accessibility.Public;
        }

        @Override
        public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
            return visitor.visitModule(this, p);
        }
    }

    public record Open(@NotNull SourcePos sourcePos, @NotNull Stmt.Accessibility accessibility, @NotNull QualifiedID path, @NotNull UseHide useHide, boolean openExample) implements Command
    {
        @Override
        public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
            return visitor.visitOpen(this, p);
        }

        public record UseHide(@NotNull @NotNull ImmutableSeq<@NotNull UseHideName> list, @NotNull Strategy strategy) {
            public static final UseHide EMPTY = new UseHide((ImmutableSeq<UseHideName>)ImmutableSeq.empty(), Strategy.Hiding);

            public boolean uses(@NotNull String name) {
                return switch (this.strategy) {
                    default -> throw new IncompatibleClassChangeError();
                    case Strategy.Using -> this.list.find(n -> n.id.equals(name)).isDefined();
                    case Strategy.Hiding -> this.list.find(n -> n.id.equals(name)).isEmpty();
                };
            }

            @NotNull
            public Map<String, String> renaming() {
                if (this.strategy == Strategy.Hiding) {
                    return ImmutableMap.empty();
                }
                return this.list.view().map(i -> Tuple.of((Object)i.id, (Object)i.asName)).toImmutableMap();
            }

            public static enum Strategy {
                Using,
                Hiding;

            }
        }

        public record UseHideName(@NotNull String id, @NotNull String asName, @NotNull Assoc asAssoc, @NotNull BindBlock asBind) {
        }
    }

    public record Import(@NotNull SourcePos sourcePos, @NotNull QualifiedID path, @Nullable String asName) implements Command
    {
        @Override
        @NotNull
        public Stmt.Accessibility accessibility() {
            return Stmt.Accessibility.Private;
        }

        @Override
        public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
            return visitor.visitImport(this, p);
        }
    }
}

