/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import java.util.EnumSet;
import java.util.function.BiFunction;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Either;
import kala.control.Option;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.Term;
import org.aya.generic.Modifier;
import org.aya.ref.DefVar;
import org.aya.resolve.context.Context;
import org.aya.tyck.pat.PatTycker;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Decl
extends Signatured
implements Stmt {
    @NotNull
    public final Stmt.Accessibility accessibility;
    @Nullable
    public Context ctx = null;
    @NotNull
    public Expr result;
    @NotNull
    public final Personality personality;

    @Override
    @NotNull
    public Stmt.Accessibility accessibility() {
        return this.accessibility;
    }

    protected Decl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @Nullable OpDecl.OpInfo opInfo, @NotNull BindBlock bindBlock, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Personality personality) {
        super(sourcePos, entireSourcePos, opInfo, bindBlock, telescope);
        this.accessibility = accessibility;
        this.result = result;
        this.personality = personality;
    }

    @Contract(pure=true)
    @NotNull
    public abstract DefVar<? extends Def, ? extends Decl> ref();

    protected abstract <P, R> R doAccept(@NotNull Visitor<P, R> var1, P var2);

    @Override
    public final <P, R> R accept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
        return this.accept((Visitor<P, R>)visitor, p);
    }

    public final <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
        visitor.traceEntrance(this, p);
        R ret = this.doAccept(visitor, p);
        visitor.traceExit(p, ret);
        return ret;
    }

    @Override
    @ApiStatus.NonExtendable
    public final <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
        return this.doAccept((Visitor<P, R>)visitor, p);
    }

    public static enum Personality {
        NORMAL,
        EXAMPLE,
        COUNTEREXAMPLE;

    }

    public static interface Visitor<P, R> {
        default public void traceEntrance(@NotNull Signatured item, P p) {
        }

        default public void traceExit(P p, R r) {
        }

        @ApiStatus.NonExtendable
        default public <T extends Signatured, RR extends R> RR traced(@NotNull T yeah, P p, @NotNull BiFunction<T, P, RR> f) {
            this.traceEntrance(yeah, p);
            RR r = f.apply(yeah, p);
            this.traceExit(p, r);
            return r;
        }

        @ApiStatus.OverrideOnly
        public R visitCtor(@NotNull DataCtor var1, P var2);

        @ApiStatus.OverrideOnly
        public R visitField(@NotNull StructField var1, P var2);

        public R visitData(@NotNull DataDecl var1, P var2);

        public R visitStruct(@NotNull StructDecl var1, P var2);

        public R visitFn(@NotNull FnDecl var1, P var2);

        public R visitPrim(@NotNull PrimDecl var1, P var2);
    }

    public static final class FnDecl
    extends Decl {
        @NotNull
        public final EnumSet<Modifier> modifiers;
        @NotNull
        public final DefVar<FnDef, FnDecl> ref;
        @NotNull
        public Either<Expr, ImmutableSeq<Pattern.Clause>> body;

        public FnDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @NotNull EnumSet<Modifier> modifiers, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Either<Expr, ImmutableSeq<Pattern.Clause>> body, @NotNull BindBlock bindBlock, @NotNull Personality personality) {
            super(sourcePos, entireSourcePos, accessibility, opInfo, bindBlock, telescope, result, personality);
            this.modifiers = modifiers;
            this.ref = DefVar.concrete(this, name);
            this.body = body;
        }

        @Override
        protected <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitFn(this, p);
        }

        @NotNull
        public DefVar<FnDef, FnDecl> ref() {
            return this.ref;
        }
    }

    public static final class StructField
    extends Signatured {
        @NotNull
        public final DefVar<FieldDef, StructField> ref;
        public DefVar<StructDef, StructDecl> structRef;
        @NotNull
        public ImmutableSeq<Pattern.Clause> clauses;
        @NotNull
        public Expr result;
        @NotNull
        public Option<Expr> body;
        public final boolean coerce;

        public StructField(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Option<Expr> body, @NotNull ImmutableSeq<Pattern.Clause> clauses, boolean coerce, @NotNull BindBlock bindBlock) {
            super(sourcePos, entireSourcePos, opInfo, bindBlock, telescope);
            this.coerce = coerce;
            this.result = result;
            this.clauses = clauses;
            this.body = body;
            this.ref = DefVar.concrete(this, name);
        }

        @NotNull
        public DefVar<FieldDef, StructField> ref() {
            return this.ref;
        }
    }

    public static final class StructDecl
    extends Decl {
        @NotNull
        public final DefVar<StructDef, StructDecl> ref;
        @NotNull
        public final ImmutableSeq<StructField> fields;
        public int ulift;

        public StructDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull ImmutableSeq<StructField> fields, @NotNull BindBlock bindBlock, @NotNull Personality personality) {
            super(sourcePos, entireSourcePos, accessibility, opInfo, bindBlock, telescope, result, personality);
            this.fields = fields;
            this.ref = DefVar.concrete(this, name);
            fields.forEach(field -> {
                field.structRef = this.ref;
            });
        }

        @NotNull
        public DefVar<StructDef, StructDecl> ref() {
            return this.ref;
        }

        @Override
        protected <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitStruct(this, p);
        }
    }

    public static final class DataDecl
    extends Decl {
        @NotNull
        public final DefVar<DataDef, DataDecl> ref;
        @NotNull
        public final ImmutableSeq<DataCtor> body;
        @NotNull
        public final @NotNull MutableList<@NotNull CtorDef> checkedBody = MutableList.create();
        public int ulift;

        public DataDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull ImmutableSeq<DataCtor> body, @NotNull BindBlock bindBlock, @NotNull Personality personality) {
            super(sourcePos, entireSourcePos, accessibility, opInfo, bindBlock, telescope, result, personality);
            this.body = body;
            this.ref = DefVar.concrete(this, name);
            body.forEach(ctors -> {
                ctors.dataRef = this.ref;
            });
        }

        @Override
        protected <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitData(this, p);
        }

        @NotNull
        public DefVar<DataDef, DataDecl> ref() {
            return this.ref;
        }
    }

    public static final class DataCtor
    extends Signatured {
        @NotNull
        public final DefVar<CtorDef, DataCtor> ref;
        public DefVar<DataDef, DataDecl> dataRef;
        public ImmutableSeq<Term.Param> patternTele;
        @NotNull
        public ImmutableSeq<Pattern.Clause> clauses;
        @NotNull
        public ImmutableSeq<Pattern> patterns;
        public final boolean coerce;
        @Nullable
        public ImmutableSeq<Pat> yetTyckedPat;
        @Nullable
        public PatTycker yetTycker;

        public DataCtor(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @Nullable OpDecl.OpInfo opInfo, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull ImmutableSeq<Pattern.Clause> clauses, @NotNull ImmutableSeq<Pattern> patterns, boolean coerce, @NotNull BindBlock bindBlock) {
            super(sourcePos, entireSourcePos, opInfo, bindBlock, telescope);
            this.clauses = clauses;
            this.coerce = coerce;
            this.patterns = patterns;
            this.ref = DefVar.concrete(this, name);
        }

        @NotNull
        public DefVar<CtorDef, DataCtor> ref() {
            return this.ref;
        }
    }

    public static final class PrimDecl
    extends Decl {
        @NotNull
        public final DefVar<PrimDef, PrimDecl> ref;

        public PrimDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result) {
            super(sourcePos, entireSourcePos, Stmt.Accessibility.Public, null, BindBlock.EMPTY, telescope, result, Personality.NORMAL);
            this.ref = DefVar.concrete(this, name);
        }

        @Override
        public boolean needTyck(@NotNull ImmutableSeq<String> currentMod) {
            return this.ref.isInModule(currentMod) && ((PrimDecl)this.ref.concrete).signature == null;
        }

        @NotNull
        public DefVar<PrimDef, PrimDecl> ref() {
            return this.ref;
        }

        @Override
        protected <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitPrim(this, p);
        }
    }
}

