/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Unit;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.desugar.Desugarer;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.distill.ConcreteDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.module.ModuleLoader;
import org.aya.resolve.visitor.StmtResolver;
import org.aya.resolve.visitor.StmtShallowResolver;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.distill.AyaDocile;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Stmt
extends AyaDocile,
TyckUnit {
    @Contract(pure=true)
    @NotNull
    public Accessibility accessibility();

    @Contract(mutates="param1")
    public static void resolve(@NotNull SeqLike<Stmt> statements, @NotNull ResolveInfo resolveInfo, @NotNull ModuleLoader loader) {
        StmtShallowResolver shallowResolver = new StmtShallowResolver(loader, resolveInfo);
        shallowResolver.resolveStmt(statements, resolveInfo.thisModule());
        StmtResolver.resolveStmt(statements, resolveInfo);
        StmtResolver.resolveBind(statements, resolveInfo);
        AyaBinOpSet opSet = resolveInfo.opSet();
        opSet.reportIfCyclic();
        statements.forEach(s -> s.desugar(resolveInfo));
    }

    default public void desugar(@NotNull ResolveInfo resolveInfo) {
        this.accept(new Desugarer(resolveInfo), Unit.unit());
    }

    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return new ConcreteDistiller(options).stmt(this);
    }

    public <P, R> R doAccept(@NotNull Visitor<P, R> var1, P var2);

    default public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
        return this.doAccept(visitor, p);
    }

    public static interface Visitor<P, R>
    extends Decl.Visitor<P, R> {
        default public void visitAll(@NotNull @NotNull ImmutableSeq<@NotNull Stmt> stmts, P p) {
            stmts.forEach(stmt -> stmt.accept(this, p));
        }

        public R visitImport(@NotNull Command.Import var1, P var2);

        public R visitOpen(@NotNull Command.Open var1, P var2);

        public R visitModule(@NotNull Command.Module var1, P var2);

        public R visitRemark(@NotNull Remark var1, P var2);

        public R visitGeneralize(@NotNull Generalize var1, P var2);
    }

    public static enum Accessibility {
        Private("private"),
        Public("public");

        @NotNull
        public final String keyword;

        private Accessibility(String keyword) {
            this.keyword = keyword;
        }

        public boolean lessThan(Accessibility accessibility) {
            return this.ordinal() < accessibility.ordinal();
        }
    }
}

