/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.Expr;
import org.jetbrains.annotations.NotNull;

public interface ExprView {
    @NotNull
    public Expr initial();

    @NotNull
    default public Expr pre(@NotNull Expr expr) {
        return expr;
    }

    @NotNull
    default public Expr post(@NotNull Expr expr) {
        return expr;
    }

    @NotNull
    private Expr commit(@NotNull Expr expr) {
        return this.post(this.traverse(this.pre(expr)));
    }

    private @NotNull Expr.Param commit(@NotNull Expr.Param param) {
        Expr type = this.commit(param.type());
        if (type == param.type()) {
            return param;
        }
        return new Expr.Param(param, type);
    }

    private @NotNull Expr.NamedArg commit(@NotNull Expr.NamedArg arg) {
        Expr expr = this.commit(arg.expr());
        if (expr == arg.expr()) {
            return arg;
        }
        return new Expr.NamedArg(arg.explicit(), expr);
    }

    @NotNull
    private Expr traverse(@NotNull Expr expr) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.RefExpr.class, Expr.UnresolvedExpr.class, Expr.LamExpr.class, Expr.PiExpr.class, Expr.SigmaExpr.class, Expr.RawUnivExpr.class, Expr.LiftExpr.class, Expr.UnivExpr.class, Expr.AppExpr.class, Expr.HoleExpr.class, Expr.TupExpr.class, Expr.ProjExpr.class, Expr.NewExpr.class, Expr.LitIntExpr.class, Expr.LitStringExpr.class, Expr.BinOpSeq.class, Expr.ErrorExpr.class, Expr.MetaPat.class}, (Object)expr3, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                Expr.RefExpr ref;
                yield ref = (Expr.RefExpr)expr3;
            }
            case 1 -> {
                Expr.UnresolvedExpr unresolved = (Expr.UnresolvedExpr)expr3;
                yield unresolved;
            }
            case 2 -> {
                Expr.LamExpr lam = (Expr.LamExpr)expr3;
                Expr.Param param = this.commit(lam.param());
                Expr body = this.commit(lam.body());
                if (param == lam.param() && body == lam.body()) {
                    yield lam;
                }
                yield new Expr.LamExpr(lam.sourcePos(), param, body);
            }
            case 3 -> {
                Expr.PiExpr pi = (Expr.PiExpr)expr3;
                Expr.Param param = this.commit(pi.param());
                Expr last = this.commit(pi.last());
                if (param == pi.param() && last == pi.last()) {
                    yield pi;
                }
                yield new Expr.PiExpr(pi.sourcePos(), pi.co(), param, last);
            }
            case 4 -> {
                Expr.SigmaExpr sigma = (Expr.SigmaExpr)expr3;
                ImmutableSeq params = sigma.params().map(this::commit);
                if (params.sameElements(sigma.params(), true)) {
                    yield sigma;
                }
                yield new Expr.SigmaExpr(sigma.sourcePos(), sigma.co(), (ImmutableSeq<Expr.Param>)params);
            }
            case 5 -> {
                Expr.RawUnivExpr rawUniv = (Expr.RawUnivExpr)expr3;
                yield rawUniv;
            }
            case 6 -> {
                Expr.LiftExpr lift = (Expr.LiftExpr)expr3;
                yield lift;
            }
            case 7 -> {
                Expr.UnivExpr univ = (Expr.UnivExpr)expr3;
                yield univ;
            }
            case 8 -> {
                Expr.AppExpr app = (Expr.AppExpr)expr3;
                Expr func = this.commit(app.function());
                Expr.NamedArg arg = this.commit(app.argument());
                if (func == app.function() && arg == app.argument()) {
                    yield app;
                }
                yield new Expr.AppExpr(app.sourcePos(), func, arg);
            }
            case 9 -> {
                Expr committed;
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                Expr filling = hole.filling();
                Expr v2 = committed = filling != null ? this.commit(filling) : null;
                if (committed == filling) {
                    yield hole;
                }
                yield new Expr.HoleExpr(hole.sourcePos(), hole.explicit(), committed);
            }
            case 10 -> {
                Expr.TupExpr tup = (Expr.TupExpr)expr3;
                ImmutableSeq items = tup.items().map(this::commit);
                if (items.sameElements(tup.items(), true)) {
                    yield tup;
                }
                yield new Expr.TupExpr(tup.sourcePos(), (ImmutableSeq<Expr>)items);
            }
            case 11 -> {
                Expr.ProjExpr proj = (Expr.ProjExpr)expr3;
                Expr tup = this.commit(proj.tup());
                if (tup == proj.tup()) {
                    yield proj;
                }
                yield new Expr.ProjExpr(proj.sourcePos(), tup, proj.ix(), proj.resolvedIx(), proj.theCore());
            }
            case 12 -> {
                Expr.NewExpr neu = (Expr.NewExpr)expr3;
                Expr struct = this.commit(neu.struct());
                ImmutableSeq fields = neu.fields().map(field -> new Expr.Field(field.name(), field.bindings(), this.commit(field.body()), field.resolvedField()));
                if (struct == neu.struct() && fields.sameElements(neu.fields(), true)) {
                    yield neu;
                }
                yield new Expr.NewExpr(neu.sourcePos(), struct, (ImmutableSeq<Expr.Field>)fields);
            }
            case 13 -> {
                Expr.LitIntExpr litInt = (Expr.LitIntExpr)expr3;
                yield litInt;
            }
            case 14 -> {
                Expr.LitStringExpr litStr = (Expr.LitStringExpr)expr3;
                yield litStr;
            }
            case 15 -> {
                Expr.BinOpSeq binOpSeq = (Expr.BinOpSeq)expr3;
                ImmutableSeq seq = binOpSeq.seq().map(this::commit);
                if (seq.sameElements(binOpSeq.seq(), true)) {
                    yield binOpSeq;
                }
                yield new Expr.BinOpSeq(binOpSeq.sourcePos(), (ImmutableSeq<Expr.NamedArg>)seq);
            }
            case 16 -> {
                Expr.ErrorExpr error = (Expr.ErrorExpr)expr3;
                yield error;
            }
            case 17 -> {
                Expr.MetaPat meta = (Expr.MetaPat)expr3;
                yield meta;
            }
        };
    }

    @NotNull
    default public Expr commit() {
        return this.commit(this.initial());
    }
}

