/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.tuple.Unit;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.visitor.ExprConsumer;
import org.jetbrains.annotations.NotNull;

public interface StmtConsumer<P>
extends Stmt.Visitor<P, Unit>,
ExprConsumer<P> {
    default public void visitSignatured(@NotNull Signatured signatured, P pp) {
        signatured.telescope.forEach(p -> {
            Expr type = p.type();
            type.accept(this, pp);
        });
    }

    default public void visitDecl(@NotNull Decl decl, P pp) {
        this.visitSignatured(decl, pp);
        decl.result.accept(this, pp);
    }

    default public void visitClause(@NotNull Pattern.Clause c, P pp) {
        c.patterns.forEach(pattern -> this.visitPattern((Pattern)pattern, pp));
        c.expr.forEach(expr -> expr.accept(this, pp));
    }

    default public void visitPattern(@NotNull Pattern pattern, P p) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Ctor.class, Pattern.Tuple.class, Pattern.BinOpSeq.class}, (Object)pattern3, n)) {
            case 0: {
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                ctor.params().forEach(pat -> this.visitPattern((Pattern)pat, p));
                break;
            }
            case 1: {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                tuple.patterns().forEach(pat -> this.visitPattern((Pattern)pat, p));
                break;
            }
            case 2: {
                Pattern.BinOpSeq seq = (Pattern.BinOpSeq)pattern3;
                seq.seq().forEach(pat -> this.visitPattern((Pattern)pat, p));
                break;
            }
        }
    }

    @Override
    default public Unit visitData(@NotNull Decl.DataDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.body.forEach(ctor -> this.traced(ctor, p, this::visitCtor));
        return Unit.unit();
    }

    @Override
    default public Unit visitStruct(@NotNull Decl.StructDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.fields.forEach(field -> this.traced(field, p, this::visitField));
        return Unit.unit();
    }

    @Override
    default public Unit visitFn(@NotNull Decl.FnDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.body.forEach(expr -> expr.accept(this, p), clauses -> clauses.forEach(clause -> this.visitClause((Pattern.Clause)clause, p)));
        return Unit.unit();
    }

    @Override
    default public Unit visitPrim(@NotNull Decl.PrimDecl decl, P p) {
        this.visitDecl(decl, p);
        return Unit.unit();
    }

    @Override
    default public Unit visitImport(@NotNull Command.Import cmd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitOpen(@NotNull Command.Open cmd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitModule(@NotNull Command.Module mod, P p) {
        mod.contents().forEach(stmt -> stmt.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitCtor(@NotNull Decl.DataCtor ctor, P p) {
        this.visitSignatured(ctor, p);
        ctor.patterns.forEach(pattern -> this.visitPattern((Pattern)pattern, p));
        ctor.clauses.forEach(clause -> this.visitClause((Pattern.Clause)clause, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitField(@NotNull Decl.StructField field, P p) {
        this.visitSignatured(field, p);
        field.result.accept(this, p);
        field.clauses.forEach(clause -> this.visitClause((Pattern.Clause)clause, p));
        field.body.forEach(expr -> expr.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitRemark(@NotNull Remark remark, P p) {
        if (remark.literate != null) {
            remark.literate.visit(this, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitGeneralize(@NotNull Generalize variables, P p) {
        variables.type.accept(this, p);
        return Unit.unit();
    }
}

