/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Unit;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.jetbrains.annotations.NotNull;

public interface StmtOps<P>
extends Stmt.Visitor<P, Unit> {
    default public void visitSignatured(@NotNull Signatured signatured, P pp) {
        signatured.telescope = signatured.telescope.map(p -> p.mapExpr(expr -> this.visitExpr((Expr)expr, pp)));
    }

    @Override
    default public Unit visitRemark(@NotNull Remark remark, P p) {
        if (remark.literate != null) {
            remark.literate.modify(expr -> this.visitExpr((Expr)expr, p));
        }
        return Unit.unit();
    }

    default public void visitDecl(@NotNull Decl decl, P pp) {
        this.visitSignatured(decl, pp);
        decl.result = this.visitExpr(decl.result, pp);
    }

    @NotNull
    default public Expr visitExpr(@NotNull Expr expr, P pp) {
        return expr;
    }

    @NotNull
    default public Pattern.Clause visitClause(@NotNull Pattern.Clause c, P pp) {
        return new Pattern.Clause(c.sourcePos, (ImmutableSeq<Pattern>)c.patterns.map(p -> this.visitPattern((Pattern)p, pp)), (Option<Expr>)c.expr.map(expr -> this.visitExpr((Expr)expr, pp)));
    }

    @NotNull
    default public Pattern visitPattern(@NotNull Pattern pattern, P pp) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.BinOpSeq.class, Pattern.Ctor.class, Pattern.Tuple.class}, (Object)pattern3, n)) {
            case 0 -> {
                Pattern.BinOpSeq seq = (Pattern.BinOpSeq)pattern3;
                yield this.visitBinOpPattern(seq, pp);
            }
            case 1 -> {
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                yield new Pattern.Ctor(ctor.sourcePos(), ctor.explicit(), ctor.resolved(), (ImmutableSeq<Pattern>)ctor.params().map(p -> this.visitPattern((Pattern)p, pp)), ctor.as());
            }
            case 2 -> {
                Pattern.Tuple tup = (Pattern.Tuple)pattern3;
                yield new Pattern.Tuple(tup.sourcePos(), tup.explicit(), (ImmutableSeq<Pattern>)tup.patterns().map(p -> this.visitPattern((Pattern)p, pp)), tup.as());
            }
            default -> pattern;
        };
    }

    @NotNull
    default public Pattern visitBinOpPattern(@NotNull Pattern.BinOpSeq seq, P pp) {
        return new Pattern.BinOpSeq(seq.sourcePos(), (ImmutableSeq<Pattern>)seq.seq().map(p -> this.visitPattern((Pattern)p, pp)), seq.as(), seq.explicit());
    }

    @Override
    default public Unit visitData(@NotNull Decl.DataDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.body.forEach(ctor -> this.traced(ctor, p, this::visitCtor));
        return Unit.unit();
    }

    @Override
    default public Unit visitStruct(@NotNull Decl.StructDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.fields.forEach(field -> this.traced(field, p, this::visitField));
        return Unit.unit();
    }

    @Override
    default public Unit visitFn(@NotNull Decl.FnDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.body = decl.body.map(expr -> this.visitExpr((Expr)expr, p), clauses -> clauses.map(clause -> this.visitClause((Pattern.Clause)clause, p)));
        return Unit.unit();
    }

    @Override
    default public Unit visitPrim(@NotNull Decl.PrimDecl decl, P p) {
        this.visitDecl(decl, p);
        return Unit.unit();
    }

    @Override
    default public Unit visitImport(@NotNull Command.Import cmd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitOpen(@NotNull Command.Open cmd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitModule(@NotNull Command.Module mod, P p) {
        mod.contents().forEach(stmt -> stmt.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitCtor(@NotNull Decl.DataCtor ctor, P p) {
        this.visitSignatured(ctor, p);
        ctor.patterns = ctor.patterns.map(pat -> this.visitPattern((Pattern)pat, p));
        ctor.clauses = ctor.clauses.map(clause -> this.visitClause((Pattern.Clause)clause, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitField(@NotNull Decl.StructField field, P p) {
        this.visitSignatured(field, p);
        field.result = this.visitExpr(field.result, p);
        field.clauses = field.clauses.map(clause -> this.visitClause((Pattern.Clause)clause, p));
        field.body = field.body.map(expr -> this.visitExpr((Expr)expr, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitGeneralize(@NotNull Generalize variables, P p) {
        variables.type = this.visitExpr(variables.type, p);
        return Unit.unit();
    }
}

